package com.tykj.classified.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-11-09 16:51
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("dm培训情况添加Vo")
public class ConfClassifiedTrainingAddVo {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "培训时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date trainingTime;

    @ApiModelProperty(value = "学时")
    private String creditHours;

    @ApiModelProperty(value = "培训人数")
    private Integer trainingPersonNum;

    @ApiModelProperty(value = "培训对象id （1-保密干部、2-dm责任人） ")
    private Integer trainingObjectId;

    @ApiModelProperty(value = "培训对象")
    private String trainingObject;

    @ApiModelProperty(value = "备注")
    private String des;
}
