package com.tykj.classified.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-11-09 16:54
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("不明确事项确定情况添加Vo")
public class ConfClassifiedUnclearMattersAddVo {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "授权单位/单位名称id")
    private String authUnitId;

    @ApiModelProperty(value = "授权单位/单位名称")
    private String authUnit;

    @ApiModelProperty(value = "事项名称")
    private String itemName;

    @ApiModelProperty(value = "密级id")
    private Integer classificationId;

    @ApiModelProperty(value = "密级")
    private String classification;

    @ApiModelProperty(value = "保密期限")
    private Integer secrecyTermContent;

    @ApiModelProperty(value = "确定时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date sureTime;

    @ApiModelProperty(value = "确定理由")
    private String sureReason;

    @ApiModelProperty(value = "备注")
    private String des;
}
