package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhaolu
 * @create 2022-11-14 13:35
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("单位节点树添加Vo")
public class ConfUnitNodeAddVo {

    @ApiModelProperty(value = "节点id")
    private String id;

    @ApiModelProperty(value = "节点名称")
    private String nodeName;

    @ApiModelProperty(value = "父节点ID")
    private String parentId;

    @ApiModelProperty(value = "节点关系 例如0.1.4.5 这些数字代表的节点的父节点之间的关系")
    private String nodeRelationship;

    @ApiModelProperty(value = "节点等级，行政级别，0-国家、1-省（自治区、直辖市）、2-市（地、州）、3-县（区）、4-下级单位、5-直属单位、6-部门、7-小组")
    private String nodeLevel;

    @ApiModelProperty(value = "管理单位id")
    private String unitManagementId;

    @ApiModelProperty(value = "管理单位")
    private String unitManagement;

    @ApiModelProperty(value = "单位类型id")
    private String unitTypeId;

    @ApiModelProperty(value = "单位类型")
    private String unitType;

    @ApiModelProperty(value = "单位属地id")
    private String unitTerritoryId;

    @ApiModelProperty(value = "单位属地")
    private String unitTerritory;

    @ApiModelProperty(value = "是否单位节点(true-是,false-否)")
    private Boolean isUnitNode;

    @ApiModelProperty(value = "是否管理节点(true-是,false-否)")
    private Boolean isManageNode;

}
