package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;

/**
 * @author zhaolu
 * @create 2022-11-14 16:57
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("单位添加Vo")
public class DataUnitAddVo {

    @ApiModelProperty(value = "统一社会信用代码")
    private String unitId;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "规范化简称")
    private String normalizeUnitId;

    @ApiModelProperty(value = "上一级统一社会信用代码")
    private String superiorUnitId;

    @ApiModelProperty(value = "单位类型")
    private String unitType;

    @ApiModelProperty(value = "所属领域")
    private String unitField;

    @ApiModelProperty(value = "单位所属级层")
    private String unitStrata;

    @ApiModelProperty(value = "单位性质")
    private String unitNature;

    @ApiModelProperty(value = "省")
    private String unitProvince;

    @ApiModelProperty(value = "市")
    private String unitCity;

    @ApiModelProperty(value = "区")
    private String unitArea;

    @ApiModelProperty(value = "区名称")
    private String areaName;

    @ApiModelProperty(value = "详细地址")
    private String unitAddress;

    @ApiModelProperty(value = "Bm办主任")
    private String secretDirector;

    @ApiModelProperty(value = "Bm办联系方式")
    private String secretDirectorTel;

    @ApiModelProperty(value = "联系人")
    private String unitContacts;

    @ApiModelProperty(value = "联系方式")
    private String unitTel;

    @ApiModelProperty(value = "单位网址")
    private String unitWebsite;

    @ApiModelProperty(value = "邮箱")
    private String unitEmail;

    @ApiModelProperty(value = "备注")
    private String unitRemarks;

    @ApiModelProperty(value = "委托单位id")
    private String unitClientId;

    @ApiModelProperty(value = "委托单位(这个单位委托给哪个单位做管理)")
    private String unitClient;

    @ApiModelProperty(value = "是否委托(true-是,false-否)")
    private Boolean isClient;

    @ApiModelProperty(value = "是否作为管理单位(true-是,false-否)")
    private Boolean isManageNode;

    @ApiModelProperty(value = "类型:1-新增,2-修改")
    private Integer insertType;
}
