package com.tykj.classified.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-11-14 19:58
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("人员添加Vo3")
public class EmployeeAddVo {

    @ApiModelProperty(value = "id")
    private String personId;

    @ApiModelProperty(value = "姓名")
    private String personName;

    @ApiModelProperty(value = "手机号")
    private String personTel;

    @ApiModelProperty(value = "部门")
    private String unitDepartment;

    @ApiModelProperty(value = "密级 == dm权限")
    private String secretRelateLevel;

    @ApiModelProperty(value = "法定定密责任人(0-否，1-是)")
    private Integer legalClassifiedResponsible;

    @ApiModelProperty(value = "指定定密责任人(0-否，1-是)")
    private Integer specifyClassifiedResponsible;

    @ApiModelProperty(value = "承办人(0-否，1-是)")
    private Integer undertaker;

    @ApiModelProperty(value = "单位统一社会信用代码")
    private String unitId;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "职务")
    private String officialCpacity;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
