package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 单位树Vo
 *
 * @author zhaolu
 * @create 2022-11-10 16:35
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("单位树Vo")
public class TreeVo {

    /** 单位ID */
    @ApiModelProperty(value = "单位id")
    private String unitId;

    /** 单位名称 */
    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "是否为末节点")
    private Boolean isEnd;

    /** 子节点 */
    @ApiModelProperty(value = "子节点List")
    private List<TreeVo> treeChildVoList;
}
