package com.tykj.classified.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-11-15 11:25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("单位依据Vo")
public class UnitBasisShowVo {

    @ApiModelProperty(value = "依据id")
    private String basisId;

    @ApiModelProperty(value = "依据名称")
    private String basisName;

    @ApiModelProperty(value = "是否为末节点(是-true,否-false)")
    private Boolean isEnd;

    @ApiModelProperty(value = "选中状态")
    private Integer isCheck;

    /** 子节点 */
    @ApiModelProperty(value = "子节点List")
    private List<UnitBasisShowVo> unitBasisShowVos;
}
