package com.tykj.classified.entity.vo.classcount;

import com.tykj.classified.entity.db1.ConfUnitNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 大屏总数居Vo类
 *
 * @author 邵越
 * @create 2022/11/18 10:06
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("大屏总数据Vo类")
public class ScreenCountVo {

    @ApiModelProperty(value = "查看是单位还是全部:1.全部,2.单位")
    private Integer isAll=1;

    @ApiModelProperty(value = "若是单位的话需要单位单位编号")
    private String unitId;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "问题总汇(提供给非最高市级使用)")
    private ScreenProblemVo screenProblemVo;

    @ApiModelProperty(value = "属地各单位情况")
    private ScreenAllProblemVo screenAllProblemVo;

    @ApiModelProperty(value = "授权情况统计数据")
    private ScreenAuthCountVo screenAuthCountVo;

    @ApiModelProperty(value = "gj统计数据")
    private ScreenCityCountVo screenCityCountVo;

    @ApiModelProperty(value = "zrr统计数据")
    private ScreenChargeCountVo screenChargeCountVo ;

    @ApiModelProperty(value = "制度统计数据")
    private ScreenSystemCountVo screenSystemCountVo ;

    @ApiModelProperty(value = "培训统计数据")
    private ScreenTrainingCountVo screenTrainingCountVo ;

    @ApiModelProperty(value = "工作mm情况")
    private ScreenWorkCountVo screenWorkCountVo;

    @ApiModelProperty(value = "是否是委托单位(0-不是委托单位,1-是委托单位)")
    private Integer isClient = 0;

}
