package com.tykj.classified.entity.vo.classcount;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author 邵越
 * @create 2022/11/19 10:48
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("单位统计")
public class ScreenUnitCountVo {

    @ApiModelProperty(value = "统一社会信用代码")
    private String unitId;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "未设定定密责任人:1.未设定.2.已设定")
    private Integer isHaveZrr = 1;

    @ApiModelProperty(value = "未记录定密培训:1.未设定.2.已设定")
    private Integer isHaveTraining = 1;

    @ApiModelProperty(value = "未设定定密制度:1.未提交.2.已提交")
    private Integer isHaveSystem = 1;

    @ApiModelProperty(value = "有几个未设置(旁边筛选出前三个重点关注)")
    private Integer isNoConfigNum  = 0;
}
