package com.tykj.classified.entity.vo.mythreadlocal;

/**
 * @author zhaolu
 * @create 2022-08-23 19:59
 */

import com.tykj.classified.entity.vo.UserVo;

import java.util.Map;

/**
 * 单实例
 */
public class MyThreadLocal {

    private MyThreadLocal() {
    }

    private static final ThreadLocal<UserVo> threadLocal = new ThreadLocal<UserVo>();

    /**
     * 对当前线程中的map域设置属性值，不会对其他线程产生影响  Thread.currentThread()
     * @param userVo
     */
    public static void set(UserVo userVo){
        threadLocal.set(userVo);
    }

    public static UserVo get(){
        return threadLocal.get();
    }

    public static String getUnitId(){
        UserVo userVo = threadLocal.get();
        return userVo.getUnitId();
    }

    /**
     * 本质上是调用当前线程的remove，不会对其他线程产生影响
     */
    public static void remove(){
        threadLocal.remove();
    }
}


