package com.tykj.classified.response;


/**
 *
 * @author 邵越
 * @create 2022/06/06 10:28
 */

public enum ResultCode {


    /**
     * 操作成功状态码
     */
    SUCCESS(true,200,"操作成功！"),
    //---系统错误返回码-----
    /**
     * 操作失败
     */
    FAIL(false,400,"操作失败"),
    /**
     * 您还未登录
     */
    UN_AUTHENTICATED(false,10002,"您还未登录"),
    /**
     * 权限不足
     */
    UN_AUTHORISE(false,10003,"权限不足"),
    /**
     * 认证凭证
     */
    UN_AUTHORIZED(false,401,"认证凭证"),
    /**
     * 抱歉，系统繁忙，请稍后重试！
     */
    SERVER_ERROR(false,99999,"抱歉，系统繁忙，请稍后重试！"),

    //---用户操作返回码  2xxxx----
    /**
     * 用户名或密码错误
     */

    MOBILE_OR_PASSWORD_ERROR(false,20001,"用户名或密码错误");

    //---企业操作返回码  3xxxx----
    //---权限操作返回码----
    //---其他操作返回码----

    /**
     * 操作是否成功
     */
    final boolean success;
    /**
     * 操作代码
     */
    final int code;
    /**
     * 提示信息
     */
    final String msg;

    ResultCode(boolean success,int code, String msg){
        this.success = success;
        this.code = code;
        this.msg = msg;
    }

    public boolean success() {
        return success;
    }

    public int code() {
        return code;
    }

    public String msg() {
        return msg;
    }

}
