package com.tykj.classified.service;

import com.tykj.classified.entity.vo.*;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author zhaolu
 * @create 2022-08-17 10:45
 */
@Service
public interface ConfClassifiedBasisService {

    /**
     * 查询定密依据-分页
     */
    ConfClassifiedBasisVo findAllClassifiedBasicPaging(ConfClassifiedBasisPageVo confClassifiedBasisPageVo);

    /**
     * 新增或编辑定密依据
     *
     * @param confClassifiedBasisAddVo 修改或者添加的数据
     */
    void addClassifiedBasic(ConfClassifiedBasisAddVo confClassifiedBasisAddVo);

    /**
     * 根据编号查询定密依据详情
     *
     * @param id 定密依据编号
     * @return 查询到的定密依据
     */
    ConfClassifiedBasisAddVo findOneClassifiedBasicById(String id);

    /**
     * 删除定密依据
     * @param id 定密依据id
     */
    void deleteClassifiedBasis(String id);

    /**
     * 多文件上传
     * @param files 文件
     */
    List<FileVo> filesUpload(MultipartFile[] files);

    List<BasisTreeVo> findBasisTree(String unitId);

    ConfClassifiedBasisVo findAllClassifiedBasicByBasisCatalogueId(ConfClassifiedBasisPageTwoVo confClassifiedBasisPageTwoVo);

    void checkBasis(BasisCheckVo basisCheckVo);
}
