package com.tykj.classified.service;

import com.tykj.classified.entity.vo.*;

import java.util.List;

public interface ConfClassifiedDecryptService {

    /**
     * 根据定密id查询基本信息以及解密信息
     * @param classifiedId 定密id
     * @return ConfClassifiedAndDecryptVo
     */
    ConfClassifiedAndDecryptVo findClassifiedDecryptByClassifiedId(String classifiedId);

    /**
     * 解密新增操作提示
     * @param classifiedId 定密id
     */
    void decryptNewOperations(String classifiedId);

    /**
     * 新增or修改解密信息
     * @param confClassifiedDecryptVo 定密事项解密Vo
     */
    void addClassifiedDecrypt(ConfClassifiedDecryptVo confClassifiedDecryptVo);

    /**
     * 解密审核通过
     * @param confClassifiedDecryptVo 定密事项解密Vo
     */
    void decryptAuditPass(ConfClassifiedDecryptVo confClassifiedDecryptVo);

    /**
     * 批量解密操作提示
     * @param confClassifiedDecryptBatchVo 定密idList
     */
    void decryptBatchOperations(ConfClassifiedDecryptBatchVo confClassifiedDecryptBatchVo);

    /**
     * 批量解密
     * @param confClassifiedIdListAndDecryptVo 定密IdList和解密Vo
     */
    void batchDecrypt(ConfClassifiedIdListAndDecryptVo confClassifiedIdListAndDecryptVo);

    /**
     * 每天上午4点定时执行解密
     */
    void decryptActuator();

    /**
     * 新增or修改公开信息
     * @param confClassifiedPublicVo 定密公开Vo
     */
    void addClassifiedPublic(ConfClassifiedPublicVo confClassifiedPublicVo);

    /**
     * 根据定密id查询公开信息
     * @param classifiedId 定密id
     * @return ConfClassifiedPublicVo
     */
    ConfClassifiedPublicVo findClassifiedPublicByClassifiedId(String classifiedId);

    /**
     * 公开审核通过
     * @param confClassifiedPublicVo 定密公开Vo
     */
    void publicAuditPass(ConfClassifiedPublicVo confClassifiedPublicVo);

    /**
     * 每天上午4点定时执行公开
     */
    void publicActuator();
}