package com.tykj.classified.service;

import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.count.ClassifiedCountVo;

public interface ConfClassifiedService {

    /**
     * 查询定密信息-分页
     * @param confClassifiedPageVo 定密分页查询Vo
     * @return 定密Vo
     */
    ConfClassifiedVo findAllClassifiedPaging(ConfClassifiedPageVo confClassifiedPageVo);

    /**
     * 新增or修改定密信息
     * @param confClassifiedAndDetailsVo 定密主表与子表Vo
     * @param secretType 秘密类型
     */
    void addClassified(ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo,Integer secretType);

    /**
     * 查看待编辑定密详情
     * @param classifiedId 定密id
     * @return 定密主表与子表Vo
     */
    ConfClassifiedAndDetailsVo findClassifiedInfo(String classifiedId);

    /**
     * GM查询人员信息以及其他下拉信息
     * @return 人员以及其他下拉框Vo
     */
    EmployeeAndOtherOfGmVo findEmployeeAndOtherInfoOfGM(DownListVo downListVo);

    /**
     * 定密审批通过
     * @param confClassifiedAndDetailsVo 定密主表与子表Vo
     */
    void classifiedApproved(ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo);

    /**
     * 查看定密所有信息详情
     * @param classifiedId 定密id
     * @return 定密所有信息Vo
     */
    ConfClassifiedInfoVo findClassifiedAllInfo(String classifiedId);

    /**
     * 定密统计
     */
    ClassifiedCountVo classifiedCount();

    /**
     * 每天上午4点定时执行定密
     */
    void classifiedActuator();

    void initManage();

    /**
     * 查询常用语
     * @return ConfClassifiedOptionsVo
     */
    ConfClassifiedOptionsVo findOption();

    ConfClassifiedVo findAllClassifiedPagingByDpNodeId(ConfClassifiedPageTwoVo confClassifiedPageTwoVo);

    ConfClassifiedVo findAllClassifiedPagingByDpUnitId(ConfClassifiedPageThreeVo confClassifiedPageThreeVo);
}