package com.tykj.classified.service.impl;


import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfClassifiedAuthDao;
import com.tykj.classified.dao.db1.DataUnitDao;
import com.tykj.classified.entity.db1.ConfClassifiedAuth;
import com.tykj.classified.entity.db1.ConfUnitNode;
import com.tykj.classified.entity.db1.DataUnit;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedAuthService;
import com.tykj.classified.service.ConfClassifiedPersonLiableService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ConfClassifiedAuthServiceImpl implements ConfClassifiedAuthService {

    private final ConfClassifiedAuthDao confClassifiedAuthDao;

    private final IdWorker idWorker;

    EntityManager entityManager;

    private final ApplicationContext applicationContext;

    private final DataUnitDao dataUnitDao;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    private final ConfClassifiedPersonLiableService confClassifiedPersonLiableService;

    public ConfClassifiedAuthServiceImpl(ConfClassifiedAuthDao confClassifiedAuthDao, IdWorker idWorker, ApplicationContext applicationContext, DataUnitDao dataUnitDao, ConfClassifiedPersonLiableService confClassifiedPersonLiableService) {
        this.confClassifiedAuthDao = confClassifiedAuthDao;
        this.idWorker = idWorker;
        this.applicationContext = applicationContext;
        this.dataUnitDao = dataUnitDao;
        this.confClassifiedPersonLiableService = confClassifiedPersonLiableService;
        Map<String, EntityManager> beansOfType = this.applicationContext.getBeansOfType(EntityManager.class);
        for (String s : beansOfType.keySet()) {
            EntityManager entityManagerIndex = beansOfType.get(s);
            String persistenceUnitName = entityManagerIndex.getEntityManagerFactory().getProperties().get("hibernate.ejb.persistenceUnitName").toString();
            if (persistenceUnitName.equals("mysqlPersistenceUnit")) {
                entityManager = entityManagerIndex;
            }
        }
    }

    @Override
    public ConfClassifiedAuthVo findAllClassifiedAuthPaging(ConfClassifiedAuthPageVo confClassifiedAuthPageVo) {
        ConfClassifiedAuthVo confClassifiedAuthVo = new ConfClassifiedAuthVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedAuth> confClassifiedAuthPredicateBuilder = Specifications.and();
        confClassifiedAuthPredicateBuilder.eq("fillingUnitId",MyThreadLocal.get().getUnitIdTwo());
        confClassifiedAuthPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedAuthPageVo.getCurrentPage() - 1, confClassifiedAuthPageVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedAuth> confClassifiedAuthPage = confClassifiedAuthDao.findAll(confClassifiedAuthPredicateBuilder.build(), pageRequest);
        confClassifiedAuthVo.setConfClassifiedAuthList(confClassifiedAuthPage.getContent());
        confClassifiedAuthVo.setTotalPage(confClassifiedAuthPage.getTotalElements());
        return confClassifiedAuthVo;

    }

    @Override
    public void addConfClassifiedAuth(ConfClassifiedAuthAddVo confClassifiedAuthAddVo) {
        Date date = new Date();
        ConfClassifiedAuth confClassifiedAuth = new ConfClassifiedAuth();
        if (StringUtils.isNotEmpty(confClassifiedAuthAddVo.getId())) { // 修改
            Optional<ConfClassifiedAuth> byId = confClassifiedAuthDao.findById(confClassifiedAuthAddVo.getId());
            if (!byId.isPresent()) {
                throw new BizException("授权名录信息不存在");
            }
            confClassifiedAuth = byId.get();
            confClassifiedAuth.setAuthUnitId(confClassifiedAuthAddVo.getAuthUnitId());
            confClassifiedAuth.setAuthUnit(confClassifiedAuthAddVo.getAuthUnit());
            confClassifiedAuth.setQuiltAuthUnit(confClassifiedAuthAddVo.getQuiltAuthUnit());
            confClassifiedAuth.setAuthId(confClassifiedAuthAddVo.getAuthId());
            confClassifiedAuth.setAuth(confClassifiedAuthAddVo.getAuth());
            confClassifiedAuth.setTime(confClassifiedAuthAddVo.getTime());
            confClassifiedAuth.setTerm(confClassifiedAuthAddVo.getTerm());
            confClassifiedAuth.setMatter(confClassifiedAuthAddVo.getMatter());
            confClassifiedAuth.setDes(confClassifiedAuthAddVo.getDes());
            confClassifiedAuth.setUpdateTime(date);
            confClassifiedAuth.setDeleteStatus(0);
            confClassifiedAuthDao.save(confClassifiedAuth);
        } else { // 新增
            BeanUtils.copyProperties(confClassifiedAuthAddVo,confClassifiedAuth);
            confClassifiedAuth.setId(idWorker.nextId() + "");
            confClassifiedAuth.setFillingPersonId(MyThreadLocal.get().getId());
            confClassifiedAuth.setFillingPerson(MyThreadLocal.get().getUserName());
            confClassifiedAuth.setFillingTime(date);
            confClassifiedAuth.setFillingUnitId(MyThreadLocal.get().getUnitIdTwo());
            confClassifiedAuth.setFillingUnit(MyThreadLocal.get().getUnitNameTwo());
            confClassifiedAuth.setCreateTime(date);
            confClassifiedAuth.setUpdateTime(date);
            confClassifiedAuth.setDeleteStatus(0);
            confClassifiedAuthDao.save(confClassifiedAuth);
        }
    }

    @Override
    public UserInfoVo findLoginUserUnit() {
        if (MyThreadLocal.get() == null && StringUtils.isEmpty(MyThreadLocal.get().getUnitId())) {
            throw new BizException("登录人信息异常,请重新登录!");
        }
        UserInfoVo userInfoVo = new UserInfoVo();
        userInfoVo.setUnitId(MyThreadLocal.get().getUnitIdTwo());
        userInfoVo.setUnitName(MyThreadLocal.get().getUnitNameTwo());
        return userInfoVo;
    }

    @Override
    public void deleteConfClassifiedAuth(String id) {
        if (StringUtils.isNotEmpty(id)) {
            Optional<ConfClassifiedAuth> byId = confClassifiedAuthDao.findById(id);
            if (!byId.isPresent()) {
                throw new BizException("授权名录信息不存在");
            }
            ConfClassifiedAuth confClassifiedAuth = byId.get();
            confClassifiedAuth.setDeleteStatus(1);
            confClassifiedAuthDao.save(confClassifiedAuth);
        } else {
            throw new BizException("授权名录信息不存在");
        }
    }

    @Override
    public ConfClassifiedAuthVo findAllClassifiedAuthPagingByDpNodeId(ConfClassifiedAuthPageTwoVo confClassifiedAuthPageTwoVo) {
        List<String> unitIdList = getUnitIdList(confClassifiedAuthPageTwoVo.getNodeId());
        ConfClassifiedAuthVo confClassifiedAuthVo = new ConfClassifiedAuthVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedAuth> confClassifiedAuthPredicateBuilder = Specifications.and();
        confClassifiedAuthPredicateBuilder.in("fillingUnitId",unitIdList);
        confClassifiedAuthPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedAuthPageTwoVo.getCurrentPage() - 1, confClassifiedAuthPageTwoVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedAuth> confClassifiedAuthPage = confClassifiedAuthDao.findAll(confClassifiedAuthPredicateBuilder.build(), pageRequest);
        confClassifiedAuthVo.setConfClassifiedAuthList(confClassifiedAuthPage.getContent());
        confClassifiedAuthVo.setTotalPage(confClassifiedAuthPage.getTotalElements());
        return confClassifiedAuthVo;
    }

    @Override
    public ConfClassifiedAuthVo findAllClassifiedAuthPagingByDpUnitId(ConfClassifiedAuthPageThreeVo confClassifiedAuthPageThreeVo) {
        ConfClassifiedAuthVo confClassifiedAuthVo = new ConfClassifiedAuthVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedAuth> confClassifiedAuthPredicateBuilder = Specifications.and();
        if (StringUtils.isEmpty(confClassifiedAuthPageThreeVo.getUnitId())) {
            confClassifiedAuthPageThreeVo.setUnitId(MyThreadLocal.get().getUnitId());
        }
        confClassifiedAuthPredicateBuilder.eq("fillingUnitId",confClassifiedAuthPageThreeVo.getUnitId());
        confClassifiedAuthPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedAuthPageThreeVo.getCurrentPage() - 1, confClassifiedAuthPageThreeVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedAuth> confClassifiedAuthPage = confClassifiedAuthDao.findAll(confClassifiedAuthPredicateBuilder.build(), pageRequest);
        confClassifiedAuthVo.setConfClassifiedAuthList(confClassifiedAuthPage.getContent());
        confClassifiedAuthVo.setTotalPage(confClassifiedAuthPage.getTotalElements());
        return confClassifiedAuthVo;
    }

    // 根据节点id获取节点id下面所有的节点并得到所有单位
    private List<String> getUnitIdList(String nodeId) {
        List<String> unitIdList = new ArrayList<>();
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(nodeId)) {
            if (nodeId.equals("0")) { // 选杭州市
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    unitIdList = dataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            } else {
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    String sql = "from ConfUnitNode  where nodeRelationship like '%"+ nodeId +"%'";
                    // 获取到所有叶子节点和当前节点
                    List<ConfUnitNode> all = entityManager.createQuery(sql).getResultList();
                    // 查询所有单位
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    List<ConfUnitNode> unitNodeList = new ArrayList<>();
                    List<DataUnit> newDataUnitList = new ArrayList<>();
                    List<DataUnit> allDataUnitList = new ArrayList<>();
                    for (ConfUnitNode confUnitNode : all) {
                        // 只要是单位节点,就去匹配所有单位
                        if (confUnitNode.getIsUnitNode()) {
                            if (confUnitNode.getUnitType().equals("全部")) {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()))
                                        .collect(Collectors.toList());
                            } else {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()) &&
                                                dataUnit.getUnitNature().equals(confUnitNode.getUnitType()))
                                        .collect(Collectors.toList());
                            }
                        }
                        // 查询出所有匹配的单位并存入进去
                        allDataUnitList.addAll(newDataUnitList);
                    }
                    unitIdList = allDataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    unitIdList = unitIdList.stream().distinct().collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            }
        } else {
            throw new BizException("请选择节点!");
        }
    }
}
