package com.tykj.classified.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfClassifiedBasisCatalogueDao;
import com.tykj.classified.dao.db1.ConfClassifiedBasisDao;
import com.tykj.classified.dao.db1.UnitBasisDao;
import com.tykj.classified.entity.db1.ConfClassifiedBasis;
import com.tykj.classified.entity.db1.ConfClassifiedBasisCatalogue;
import com.tykj.classified.entity.vo.ConfClassifiedBasisCatalogueAddVo;
import com.tykj.classified.entity.vo.ConfClassifiedBasisCataloguePageVo;
import com.tykj.classified.entity.vo.ConfClassifiedBasisCatalogueShowVo;
import com.tykj.classified.entity.vo.FindConfClassifiedBasisCatalogueVo;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedBasisCatalogueService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.persistence.Id;
import javax.transaction.Transactional;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zhaolu
 * @create 2022-11-14 18:27
 */
@Service
public class ConfClassifiedBasisCatalogueServiceImpl implements ConfClassifiedBasisCatalogueService {

    @Autowired
    private ConfClassifiedBasisCatalogueDao confClassifiedBasisCatalogueDao;

    @Autowired
    private ConfClassifiedBasisDao confClassifiedBasisDao;

    @Autowired
    private UnitBasisDao unitBasisDao;

    @Autowired
    private IdWorker idWorker;

    @Override
    public ConfClassifiedBasisCatalogueShowVo findAllClassifiedBasisCatalogue(ConfClassifiedBasisCataloguePageVo confClassifiedBasisCataloguePageVo) {
        ConfClassifiedBasisCatalogueShowVo confClassifiedBasisCatalogueShowVo = new ConfClassifiedBasisCatalogueShowVo();
        PredicateBuilder<ConfClassifiedBasisCatalogue> predicateBuilder = Specifications.and();
        predicateBuilder.like(StringUtils.isNotEmpty(confClassifiedBasisCataloguePageVo.getCatalogueName()),"catalogueName","%" + confClassifiedBasisCataloguePageVo.getCatalogueName() + "%");
        predicateBuilder.eq("deleteStatus",0);// 未删除
        List<ConfClassifiedBasisCatalogue> all = confClassifiedBasisCatalogueDao.findAll(predicateBuilder.build());
        confClassifiedBasisCatalogueShowVo.setConfClassifiedBasisCatalogueList(all);
        confClassifiedBasisCatalogueShowVo.setTotalPage(all.size());
        return confClassifiedBasisCatalogueShowVo;
    }

    @Override
    public void addClassifiedBasisCatalogue(ConfClassifiedBasisCatalogueAddVo confClassifiedBasisCatalogueAddVo) {
        Date date = new Date();
        ConfClassifiedBasisCatalogue confClassifiedBasisCatalogue = new ConfClassifiedBasisCatalogue();
        if (StringUtils.isNotEmpty(confClassifiedBasisCatalogueAddVo.getCatalogueId())) { // 修改
            Optional<ConfClassifiedBasisCatalogue> byId = confClassifiedBasisCatalogueDao.findById(confClassifiedBasisCatalogueAddVo.getCatalogueId());
            if (!byId.isPresent()) {
                throw new BizException("依据目录不存在!");
            }
            confClassifiedBasisCatalogue = byId.get();
            BeanUtils.copyProperties(confClassifiedBasisCatalogueAddVo,confClassifiedBasisCatalogue);
            confClassifiedBasisCatalogue.setUpdateTime(date);
        } else { // 新增
            BeanUtils.copyProperties(confClassifiedBasisCatalogueAddVo,confClassifiedBasisCatalogue);
            confClassifiedBasisCatalogue.setId(idWorker.nextId() + "");
            confClassifiedBasisCatalogue.setCreateTime(date);
            confClassifiedBasisCatalogue.setUpdateTime(date);
            confClassifiedBasisCatalogue.setOperatorId(MyThreadLocal.get().getId());
            confClassifiedBasisCatalogue.setOperatorUnit(MyThreadLocal.get().getUnitId());
            confClassifiedBasisCatalogue.setCanDel(0); // 不可删除
        }
        confClassifiedBasisCatalogueDao.save(confClassifiedBasisCatalogue);
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void deleteClassifiedBasisCatalogue(String catalogueId) {
        Optional<ConfClassifiedBasisCatalogue> byId = confClassifiedBasisCatalogueDao.findById(catalogueId);
        if (!byId.isPresent()) {
            throw new BizException("该目录不存在");
        }
        List<ConfClassifiedBasis> confClassifiedBasisList = confClassifiedBasisDao.findAllByCatalogueId(catalogueId);
        if (confClassifiedBasisList != null && confClassifiedBasisList.size() > 0) {
            throw new BizException("该目录下面存在依据,不能删除!");
        }
        ConfClassifiedBasisCatalogue confClassifiedBasisCatalogue = byId.get();
        confClassifiedBasisCatalogue.setDeleteStatus(1);

        // 删除目录将目录下的依据,单位依据中间表数据也删除
        List<ConfClassifiedBasis> allByCatalogueId = confClassifiedBasisDao.findAllByCatalogueId(catalogueId);
        if (allByCatalogueId != null && allByCatalogueId.size() > 0) {
            List<String> collect = allByCatalogueId.stream().map(ConfClassifiedBasis::getId).collect(Collectors.toList());
            unitBasisDao.deleteAllByBasisIdIn(collect);
        }
        confClassifiedBasisDao.deleteAllByCatalogueId(catalogueId);
        confClassifiedBasisCatalogueDao.save(confClassifiedBasisCatalogue);
    }

    @Override
    public FindConfClassifiedBasisCatalogueVo findClassifiedBasisCatalogueByName() {
        FindConfClassifiedBasisCatalogueVo findConfClassifiedBasisCatalogueVo = new FindConfClassifiedBasisCatalogueVo();
        PredicateBuilder<ConfClassifiedBasisCatalogue> predicateBuilder = Specifications.and();
        predicateBuilder.eq("deleteStatus",0);
        List<ConfClassifiedBasisCatalogue> all = confClassifiedBasisCatalogueDao.findAll();
        for (ConfClassifiedBasisCatalogue confClassifiedBasisCatalogue : all) {
            findConfClassifiedBasisCatalogueVo.setCatalogueId(confClassifiedBasisCatalogue.getId());
            findConfClassifiedBasisCatalogueVo.setCatalogueName(confClassifiedBasisCatalogue.getCatalogueName());
        }
        return findConfClassifiedBasisCatalogueVo;
    }
}
