package com.tykj.classified.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.*;
import com.tykj.classified.entity.db1.*;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedBasisService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.transaction.Transactional;
import java.io.File;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhaolu
 * @create 2022-08-17 10:45
 */
@Slf4j
@Service
public class ConfClassifiedBasisServiceImpl implements ConfClassifiedBasisService {

    @Value("${file.upload.path}")
    private String path;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    private final IdWorker idWorker;

    private final ConfClassifiedBasisCatalogueDao confClassifiedBasisCatalogueDao;

    private final ConfClassifiedBasisDao confClassifiedBasisDao;

    private final ConfManageDetailDao confManageDetailDao;

    private final DataUnitDao dataUnitDao;

    private final UnitBasisDao unitBasisDao;

    public ConfClassifiedBasisServiceImpl(ConfClassifiedBasisDao confClassifiedBasisDao, IdWorker idWorker, ConfClassifiedBasisCatalogueDao confClassifiedBasisCatalogueDao, ConfManageDetailDao confManageDetailDao, DataUnitDao dataUnitDao, UnitBasisDao unitBasisDao) {
        this.confClassifiedBasisDao = confClassifiedBasisDao;
        this.idWorker = idWorker;
        this.confClassifiedBasisCatalogueDao = confClassifiedBasisCatalogueDao;
        this.confManageDetailDao = confManageDetailDao;
        this.dataUnitDao = dataUnitDao;
        this.unitBasisDao = unitBasisDao;
    }

    @Override
    public ConfClassifiedBasisVo findAllClassifiedBasicPaging(ConfClassifiedBasisPageVo confClassifiedBasisPageVo) {
        ConfClassifiedBasisVo confClassifiedBasisVo = new ConfClassifiedBasisVo();

        //创建查询条件
        PredicateBuilder<UnitBasis> unitBasisPredicateBuilder = Specifications.and();
        unitBasisPredicateBuilder.eq("unitId",MyThreadLocal.get().getUnitIdTwo());
        unitBasisPredicateBuilder.eq("isCheck",1);// 已选中
        List<UnitBasis> all = unitBasisDao.findAll(unitBasisPredicateBuilder.build());
        List<String> basisIdList = all.stream().map(UnitBasis::getBasisId).collect(Collectors.toList());
        //进行查询并转换为返回的类型
        if (basisIdList.size() > 0) {
            PredicateBuilder<ConfClassifiedBasis> confClassifiedBasisPredicateBuilder = Specifications.and();
            confClassifiedBasisPredicateBuilder.in("id",basisIdList);
            confClassifiedBasisPredicateBuilder.like(StringUtils.isNotEmpty(confClassifiedBasisPageVo.getBasisName()),"basisName","%" + confClassifiedBasisPageVo.getBasisName() + "%");
            if (MyThreadLocal.get().getClassification() == 3) {
                confClassifiedBasisPredicateBuilder.le("classificationSortNum", 4);
            } else if (MyThreadLocal.get().getClassification() == 2) {
                confClassifiedBasisPredicateBuilder.le("classificationSortNum", 3);
            } else if (MyThreadLocal.get().getClassification() == 1) {
                confClassifiedBasisPredicateBuilder.le("classificationSortNum", 2);
            } else {
                return confClassifiedBasisVo;
            }
            //创建查询顺序(默认为按照更新时间顺序)
            Sort sort = Sort.by(Sort.Direction.DESC, "updateTime");
            //创建查询页码
            PageRequest pageRequest = PageRequest.of(confClassifiedBasisPageVo.getCurrentPage() - 1, confClassifiedBasisPageVo.getPageSize(), sort);

            Page<ConfClassifiedBasis> confClassifiedBasicPage = confClassifiedBasisDao.findAll(confClassifiedBasisPredicateBuilder.build(), pageRequest);
            confClassifiedBasisVo.setConfClassifiedBasisList(confClassifiedBasicPage.getContent());
            confClassifiedBasisVo.setTotalPage(confClassifiedBasicPage.getTotalElements());
        } else {
            confClassifiedBasisVo.setTotalPage(0);
        }
        return confClassifiedBasisVo;
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void addClassifiedBasic(ConfClassifiedBasisAddVo confClassifiedBasisAddVo) {
        List<ConfClassifiedBasisCatalogue> confClassifiedBasisCatalogueList = new ArrayList<>();
        Date date = new Date();
        ConfClassifiedBasis confClassifiedBasis;
        ConfClassifiedBasisCatalogue confClassifiedBasisCatalogueByCatalogueName = confClassifiedBasisCatalogueDao.findConfClassifiedBasisCatalogueByCatalogueName(confClassifiedBasisAddVo.getCatalogueName());
        if (confClassifiedBasisCatalogueByCatalogueName != null) {
            // 根据目录id判断序号是否重复
            List<ConfClassifiedBasis> allBySerialNo = confClassifiedBasisDao.findAllByCatalogueIdAndSerialNo(confClassifiedBasisAddVo.getCatalogueId(),confClassifiedBasisAddVo.getSerialNo());
            if (StringUtils.isEmpty(confClassifiedBasisAddVo.getId())) { // 新增
                if (allBySerialNo.size() > 0) {
                    throw new BizException("序号重复");
                }
            } else { // 修改
                if (allBySerialNo.size() > 1) {
                    throw new BizException("序号重复");
                }
            }
        }
        ConfManageDetail confManageDetailByManageId = confManageDetailDao.findConfManageDetailById(confClassifiedBasisAddVo.getClassification());

        List<UnitBasis> unitBasisList = new ArrayList<>();
        //判断是否为新增
        if (StringUtils.isEmpty(confClassifiedBasisAddVo.getId())){
            String basisId = idWorker.nextId() + "";
            confClassifiedBasis = new ConfClassifiedBasis();
            //生成编号
            confClassifiedBasis.setId(basisId);
            confClassifiedBasis.setCreateTime(date);
            confClassifiedBasis.setOperatorId(MyThreadLocal.get().getId());
            confClassifiedBasis.setOperatorName(MyThreadLocal.get().getUserName());
            confClassifiedBasis.setOperatorUnit(MyThreadLocal.get().getUnitId());

            // 查询所有单位
            List<DataUnit> all = dataUnitDao.findAll();
            UnitBasis unitBasis;
            for (DataUnit dataUnit : all) {
                unitBasis = new UnitBasis();
                unitBasis.setId(idWorker.nextId() + "");
                unitBasis.setBasisId(basisId);
                unitBasis.setIsCheck(0);
                unitBasis.setUnitId(dataUnit.getUnitId());
                unitBasisList.add(unitBasis);
            }
        } else {
            Optional<ConfClassifiedBasis> confClassifiedBasicDaoById = confClassifiedBasisDao.findById(confClassifiedBasisAddVo.getId());
            if (!confClassifiedBasicDaoById.isPresent()){
                throw new BizException("查询不到当前数据信息,无法修改");
            }
            confClassifiedBasis = confClassifiedBasicDaoById.get();
//            if (!confClassifiedBasis.getCatalogueName().equals(confClassifiedBasisAddVo.getCatalogueName())) { // 如果目录不一样,就判断旧目录可不可以删除
//                ConfClassifiedBasisCatalogue confClassifiedBasisCatalogueByCatalogueName1 = confClassifiedBasisCatalogueDao.findConfClassifiedBasisCatalogueByCatalogueName(confClassifiedBasis.getCatalogueName());
//                List<ConfClassifiedBasis> allByCatalogueId = confClassifiedBasisDao.findAllByCatalogueId(confClassifiedBasisCatalogueByCatalogueName1.getId());
//                if (allByCatalogueId == null || allByCatalogueId.size() < 1) { // 旧目录下如果没有依据,就设置成可以删除
//                    confClassifiedBasisCatalogueByCatalogueName1.setCanDel(1); // 可删除
//                    confClassifiedBasisCatalogueList.add(confClassifiedBasisCatalogueByCatalogueName1);
//                }
//            }
        }
        confClassifiedBasis.setCatalogueName(confClassifiedBasisAddVo.getCatalogueName());
        confClassifiedBasis.setBasisName(confClassifiedBasisAddVo.getBasisName());
        confClassifiedBasis.setBasisDes(confClassifiedBasisAddVo.getBasisDes());
        confClassifiedBasis.setBasisFile(JSONObject.toJSONString(confClassifiedBasisAddVo.getBasisFile()));
        confClassifiedBasis.setSuitableType(confClassifiedBasisAddVo.getSuitableType());
        confClassifiedBasis.setClassification(confClassifiedBasisAddVo.getClassification());
        confClassifiedBasis.setClassificationSortNum(confManageDetailByManageId.getSortNum());
        confClassifiedBasis.setSecrecyTermType(confClassifiedBasisAddVo.getSecrecyTermType());
        confClassifiedBasis.setSecrecyTermContent(confClassifiedBasisAddVo.getSecrecyTermContent());
        confClassifiedBasis.setRange(confClassifiedBasisAddVo.getRange());
        confClassifiedBasis.setDes(confClassifiedBasisAddVo.getDes());
        confClassifiedBasis.setYearly(confClassifiedBasisAddVo.getYearly());
        confClassifiedBasis.setSerialNo(confClassifiedBasisAddVo.getSerialNo());
        //判断是否有文件路径
        if (!CollectionUtils.isEmpty(confClassifiedBasisAddVo.getBasisFile())){
            confClassifiedBasis.setIsUpload(1);
        }else {
            confClassifiedBasis.setBasisFile(null);
            confClassifiedBasis.setIsUpload(2);
        }
        confClassifiedBasis.setUpdateTime(date);

        // 目录id
        // 查看目录是否存在,如果目录不存在就自动新建一个目录
        if (confClassifiedBasisCatalogueByCatalogueName != null) {
            confClassifiedBasis.setCatalogueId(confClassifiedBasisCatalogueByCatalogueName.getId());
            confClassifiedBasisCatalogueByCatalogueName.setCanDel(0); // 不可删除
        } else {
            String id = idWorker.nextId() + "";
            confClassifiedBasis.setCatalogueId(id);
            confClassifiedBasisCatalogueByCatalogueName = new ConfClassifiedBasisCatalogue();
            confClassifiedBasisCatalogueByCatalogueName.setCreateTime(date);
            confClassifiedBasisCatalogueByCatalogueName.setUpdateTime(date);
            confClassifiedBasisCatalogueByCatalogueName.setOperatorUnit(MyThreadLocal.get().getUnitId());
            confClassifiedBasisCatalogueByCatalogueName.setOperatorId(MyThreadLocal.get().getId());
            confClassifiedBasisCatalogueByCatalogueName.setCanDel(0); // 不可删除
            confClassifiedBasisCatalogueByCatalogueName.setCatalogueName(confClassifiedBasisAddVo.getCatalogueName());
            confClassifiedBasisCatalogueByCatalogueName.setDeleteStatus(0);
            confClassifiedBasisCatalogueByCatalogueName.setId(id);
        }
        confClassifiedBasisCatalogueList.add(confClassifiedBasisCatalogueByCatalogueName);
        confClassifiedBasisCatalogueDao.saveAll(confClassifiedBasisCatalogueList);
        confClassifiedBasisDao.save(confClassifiedBasis);
        unitBasisDao.saveAll(unitBasisList);
    }

    @Override
    public ConfClassifiedBasisAddVo findOneClassifiedBasicById(String id) {

        ConfClassifiedBasisAddVo confClassifiedBasisAddVo = new ConfClassifiedBasisAddVo();
        Optional<ConfClassifiedBasis> confClassifiedBasicDaoById = confClassifiedBasisDao.findById(id);

        if (!confClassifiedBasicDaoById.isPresent()){
            throw new BizException("查询不到当前数据信息,无法修改");
        }

        ConfClassifiedBasis confClassifiedBasis = confClassifiedBasicDaoById.get();

        BeanUtils.copyProperties(confClassifiedBasis, confClassifiedBasisAddVo);
        confClassifiedBasisAddVo.setBasisFile(JSONObject.parseArray(confClassifiedBasis.getBasisFile(), FileVo.class));
        return confClassifiedBasisAddVo;
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void deleteClassifiedBasis(String id) {
        Optional<ConfClassifiedBasis> byId = confClassifiedBasisDao.findById(id);
        if (!byId.isPresent()) {
            throw new BizException("依据不存在!");
        }
        ConfClassifiedBasis confClassifiedBasis = byId.get();

//        List<ConfClassifiedBasis> allByCatalogueId = confClassifiedBasisDao.findAllByCatalogueId(confClassifiedBasis.getCatalogueId());
//        if (allByCatalogueId == null || allByCatalogueId.size() <= 1) { // 表示没有其他依据在这个目录下面
//            Optional<ConfClassifiedBasisCatalogue> byId1 = confClassifiedBasisCatalogueDao.findById(confClassifiedBasis.getCatalogueId());
//            if (!byId1.isPresent()) {
//                throw new BizException("目录不存在!");
//            }
//            ConfClassifiedBasisCatalogue confClassifiedBasisCatalogue = byId1.get();
//            confClassifiedBasisCatalogue.setCanDel(1); // 可删除
//            confClassifiedBasisCatalogueDao.save(confClassifiedBasisCatalogue);
//        }
        confClassifiedBasisDao.delete(confClassifiedBasis);

        // 删除依据将单位依据中间表的数据也删除
        unitBasisDao.deleteByBasisId(id);
    }

    @Override
    public List<FileVo> filesUpload(MultipartFile[] files) {
        List<FileVo> fileVos = new ArrayList<>();
        //判断file数组不能为空并且长度大于0
        if (files != null && files.length > 0) {
            //循环获取file数组中得文件
            for (MultipartFile file : files) {
                //保存文件
                FileVo fileVo = saveFile(file, path);
                fileVos.add(fileVo);
            }
        }
        return fileVos;
    }

    @Override
    public List<BasisTreeVo> findBasisTree(String unitId) {
        // 查询所有目录
        List<ConfClassifiedBasisCatalogue> confClassifiedBasisCatalogueList = confClassifiedBasisCatalogueDao.findAllByDeleteStatus(0);
        // 查询所有依据
        List<ConfClassifiedBasis> confClassifiedBasisList = confClassifiedBasisDao.findAll();
        // 根据单位查询单位依据中间表
        List<UnitBasis> unitBasisList = unitBasisDao.findAllByUnitId(unitId);
        List<BasisTreeVo> basisTreeVoList = new ArrayList<>();
        BasisTreeVo basisTreeVo;
        // 将目录和依据放进树里面
        for (ConfClassifiedBasisCatalogue confClassifiedBasisCatalogue : confClassifiedBasisCatalogueList) {
            basisTreeVo = new BasisTreeVo();
            basisTreeVo.setBasisId(confClassifiedBasisCatalogue.getId()); // 目录id
            basisTreeVo.setBasisName(confClassifiedBasisCatalogue.getCatalogueName()); // 目录名称
            basisTreeVo.setParentId("0"); // 默认顶级节点"0"
            basisTreeVo.setIsCheck(0); // 先设置成未选中
            basisTreeVoList.add(basisTreeVo);
        }
        // 所有依据和单位依据中间表关联
        Map<String, List<UnitBasis>> basisIdMap = unitBasisList.stream()
                .collect(Collectors.groupingBy(UnitBasis::getBasisId));
        for (ConfClassifiedBasis confClassifiedBasis : confClassifiedBasisList) {
            basisTreeVo = new BasisTreeVo();
            List<UnitBasis> unitBasisList1 = basisIdMap.getOrDefault(confClassifiedBasis.getId(),new ArrayList<>());
            if (unitBasisList1 != null && unitBasisList1.size() > 0) {
                basisTreeVo.setIsCheck(unitBasisList1.get(0).getIsCheck());
            } else {
                basisTreeVo.setIsCheck(0);
            }
            basisTreeVo.setBasisId(confClassifiedBasis.getId()); // 依据id
            basisTreeVo.setBasisName(confClassifiedBasis.getBasisName()); // 依据名称
            basisTreeVo.setParentId(confClassifiedBasis.getCatalogueId()); // 目录id
            basisTreeVoList.add(basisTreeVo);
        }
        //获取父节点
        List<BasisTreeVo> collect = basisTreeVoList.stream().filter(m -> "0".equals(m.getParentId())).map(
                (m) -> {
                    m.setBasisTreeVos(getChildrenList(m, basisTreeVoList));
                    return m;
                }
        ).collect(Collectors.toList());
        return collect;
    }

    @Override
    public ConfClassifiedBasisVo findAllClassifiedBasicByBasisCatalogueId(ConfClassifiedBasisPageTwoVo confClassifiedBasisPageTwoVo) {
        ConfClassifiedBasisVo confClassifiedBasisVo = new ConfClassifiedBasisVo();
        PredicateBuilder<ConfClassifiedBasis> predicateBuilder = Specifications.and();
        predicateBuilder.eq("catalogueId",confClassifiedBasisPageTwoVo.getCatalogueId());
        predicateBuilder.like(StringUtils.isNotEmpty(confClassifiedBasisPageTwoVo.getBasisName()),"basisName",confClassifiedBasisPageTwoVo.getBasisName());
        List<ConfClassifiedBasis> all = confClassifiedBasisDao.findAll(predicateBuilder.build());
        confClassifiedBasisVo.setConfClassifiedBasisList(all);
        confClassifiedBasisVo.setTotalPage(all.size());
        return confClassifiedBasisVo;
    }

    @Override
    public void checkBasis(BasisCheckVo basisCheckVo) {
        if (StringUtils.isNotEmpty(basisCheckVo.getUnitId())) {
            if (basisCheckVo.getBasisIds() != null && basisCheckVo.getBasisIds().size() > 0) {
                PredicateBuilder<UnitBasis> predicateBuilder = Specifications.and();
                predicateBuilder.eq("unitId",basisCheckVo.getUnitId());
                List<UnitBasis> allUnitBasisList = unitBasisDao.findAll(predicateBuilder.build());
                for (UnitBasis unitBasis : allUnitBasisList) {
                    // 先设置成未选中
                    unitBasis.setIsCheck(0);
                    if (basisCheckVo.getBasisIds().contains(unitBasis.getBasisId())) {
                        unitBasis.setIsCheck(1);
                    }
                }
                unitBasisDao.saveAll(allUnitBasisList);
            } else { // 全部依据取消选中
                PredicateBuilder<UnitBasis> predicateBuilder = Specifications.and();
                predicateBuilder.eq("unitId",basisCheckVo.getUnitId());
                List<UnitBasis> allUnitBasisList = unitBasisDao.findAll(predicateBuilder.build());
                for (UnitBasis unitBasis : allUnitBasisList) {
                    // 未选中
                    unitBasis.setIsCheck(0);
                }
                unitBasisDao.saveAll(allUnitBasisList);
            }
        } else {
            throw new BizException("没有选择单位!");
        }
    }

    /**
     * 获取子节点列表
     *
     * @param tree
     * @param list
     * @return
     */
    public static List<BasisTreeVo> getChildrenList(BasisTreeVo tree, List<BasisTreeVo> list) {
        List<BasisTreeVo> children = list.stream().filter(item -> Objects.equals(item.getParentId(), tree.getBasisId())).map(
                (item) -> {
                    item.setBasisTreeVos(getChildrenList(item, list));
                    return item;
                }
        ).collect(Collectors.toList());
        return children;
    }

    /***
     * 保存文件
     * @param file 文件
     * @return 文件Vo
     */
    private FileVo saveFile(MultipartFile file, String path) {
        FileVo fileVo = new FileVo();
        // 判断文件是否为空
        if (!file.isEmpty()) {
            try {
                File filepath = new File(path);
                if (!filepath.exists()) {
                    filepath.mkdirs();
                }
                String id = idWorker.nextId() + "";
                // 文件保存路径
                String savePath = path + id + file.getOriginalFilename();
                log.info(savePath);
                // 转存文件
                file.transferTo(new File(savePath));
                fileVo.setName(file.getOriginalFilename());
                fileVo.setUrl("/conf/"+ id + file.getOriginalFilename());
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return fileVo;
    }
}
