package com.tykj.classified.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfClassifiedChangeDao;
import com.tykj.classified.dao.db1.ConfClassifiedDao;
import com.tykj.classified.dao.db1.ConfClassifiedDetailsDao;
import com.tykj.classified.dao.db1.ConfManageDetailDao;
import com.tykj.classified.entity.db1.ConfClassified;
import com.tykj.classified.entity.db1.ConfClassifiedChange;
import com.tykj.classified.entity.db1.ConfClassifiedDetails;
import com.tykj.classified.entity.db1.ConfManageDetail;
import com.tykj.classified.entity.vo.ConfClassifiedChangeVo;
import com.tykj.classified.entity.vo.ConfClassifiedDetailsVo;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedChangeService;
import com.tykj.classified.utils.date.DateUtils;
import com.tykj.classified.utils.date.TimeUtils;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.log.LogUtils;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Date;

@Slf4j
@Service
public class ConfClassifiedChangeServiceImpl implements ConfClassifiedChangeService {

    private final ConfClassifiedChangeDao confClassifiedChangeDao;

    private final ConfClassifiedDao confClassifiedDao;

    private final ConfClassifiedDetailsDao confClassifiedDetailsDao;

    private final ConfManageDetailDao confManageDetailDao;

    private final IdWorker idWorker;

    public ConfClassifiedChangeServiceImpl(ConfClassifiedChangeDao confClassifiedChangeDao, ConfClassifiedDao confClassifiedDao, ConfClassifiedDetailsDao confClassifiedDetailsDao, ConfManageDetailDao confManageDetailDao, IdWorker idWorker) {
        this.confClassifiedChangeDao = confClassifiedChangeDao;
        this.confClassifiedDao = confClassifiedDao;
        this.confClassifiedDetailsDao = confClassifiedDetailsDao;
        this.confManageDetailDao = confManageDetailDao;
        this.idWorker = idWorker;
    }

    @Override
    public ConfClassifiedChangeVo findClassifiedChangeByClassifiedId(String classifiedId) {
        ConfClassifiedChangeVo confClassifiedChangeVo = new ConfClassifiedChangeVo();
        ConfClassifiedChange confClassifiedChange = confClassifiedChangeDao.findConfClassifiedChangeByClassifiedId(classifiedId);
        if (confClassifiedChange != null) { // 有变更信息
            BeanUtils.copyProperties(confClassifiedChange,confClassifiedChangeVo);
            confClassifiedChangeVo.setChangeBasisContent(confClassifiedChange.getChangeBasisContent());
            confClassifiedChangeVo.setType(confClassifiedChange.getType());
        } else { // 没有变更信息 new一个ConfClassifiedChangeVo返回给前端显示
            ConfClassified confClassified = confClassifiedDao.findConfClassifiedById(classifiedId);
            if (confClassified != null) {
                ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsDao.findByClassifiedId(classifiedId);
                ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(confClassifiedDetails.getClassifiedContent(), ConfClassifiedDetailsVo.class);
                confClassifiedChangeVo.setClassifiedId(classifiedId);
                confClassifiedChangeVo.setItemName(confClassified.getItemName());
                confClassifiedChangeVo.setType(confClassified.getType());
                confClassifiedChangeVo.setUndertakerUnit(confClassified.getUndertakerUnit());
                confClassifiedChangeVo.setBeforeClassification(confClassified.getClassification());
                confClassifiedChangeVo.setBeforeSecrecyTermType(confClassified.getSecrecyTermType());
                confClassifiedChangeVo.setBeforeSecrecyTermContent(confClassified.getSecrecyTermContent());
                confClassifiedChangeVo.setBeforeRange(confClassifiedDetailsVo.getRange());
                confClassifiedChangeVo.setBeforeClassifiedBasisType(confClassifiedDetailsVo.getClassifiedBasisType());
                confClassifiedChangeVo.setBeforeClassifiedBasisContent(confClassifiedDetailsVo.getClassifiedBasisContent());
                confClassifiedChangeVo.setUndertaker(confClassified.getUndertaker());
                confClassifiedChangeVo.setUndertakerName(confClassified.getUndertakerName());
                confClassifiedChangeVo.setUndertakerPhone(confClassified.getUndertakerPhone());
                confClassifiedChangeVo.setClassificationOpinion(confClassifiedDetailsVo.getClassifiedOpinionContent());
                confClassifiedChangeVo.setCreateTime(new Date());
                // 如果是发文拟稿，则带出法定或者指定责任人其中一个，优先法定责任人
                if (confClassified.getType() == 1) {
                    if (StringUtils.isNotEmpty(confClassifiedDetailsVo.getLegalClassifiedResponsible())) {
                        confClassifiedChangeVo.setClassificationPerson(confClassifiedDetailsVo.getLegalClassifiedResponsible());
                        confClassifiedChangeVo.setClassificationPersonName(confClassifiedDetailsVo.getLegalClassifiedResponsibleName());
                    } else {
                        confClassifiedChangeVo.setClassificationPerson(confClassifiedDetailsVo.getSpecifyClassifiedResponsible());
                        confClassifiedChangeVo.setClassificationPersonName(confClassifiedDetailsVo.getSpecifyClassifiedResponsibleName());
                    }
                } else { // 如果是其他类型，则带出定M责任人即可
                    confClassifiedChangeVo.setClassificationPerson(confClassifiedDetailsVo.getClassifiedReviewer());
                    confClassifiedChangeVo.setClassificationPersonName(confClassifiedDetailsVo.getClassifiedReviewerName());
                }
            } else {
                throw new BizException("定密信息不存在");
            }
        }
        return confClassifiedChangeVo;
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void addClassifiedChange(ConfClassifiedChangeVo confClassifiedChangeVo) {
        if (confClassifiedChangeVo != null) {
            Date date = new Date();
            ConfClassifiedChange confClassifiedChange = new ConfClassifiedChange();
            ConfClassified confClassifiedById = confClassifiedDao.findConfClassifiedById(confClassifiedChangeVo.getClassifiedId());
            confClassifiedById.setUpdateTime(date);
            // 保存变更信息状态改为变更中
            confClassifiedById.setChangeStatus(6);
            // 修改
            if (StringUtils.isNotEmpty(confClassifiedChangeVo.getId())) {
                BeanUtils.copyProperties(confClassifiedChangeVo,confClassifiedChange);
                confClassifiedChange.setUpdateTime(date);
                confClassifiedChange.setOperatorId(MyThreadLocal.get().getId());
                confClassifiedChange.setOperatorUnit(MyThreadLocal.get().getUnitIdTwo());
            } else { // 新增
                BeanUtils.copyProperties(confClassifiedChangeVo,confClassifiedChange);
                confClassifiedChange.setId(idWorker.nextId() + "");
                confClassifiedChange.setOperatorId(MyThreadLocal.get().getId());
                confClassifiedChange.setOperatorUnit(MyThreadLocal.get().getUnitIdTwo());
                confClassifiedChange.setCreateTime(date);
                confClassifiedChange.setUpdateTime(date);

                // 操作记录
                LogUtils.addOperationRecord(confClassifiedChangeVo.getClassifiedId(),"变更",date,MyThreadLocal.get().getId(),MyThreadLocal.get().getUserName(),MyThreadLocal.get().getUnitNameTwo());
            }
            confClassifiedDao.save(confClassifiedById);
            confClassifiedChangeDao.save(confClassifiedChange);
        } else {
            throw new BizException("传入的数据为空");
        }
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void approvalClassifiedChange(ConfClassifiedChangeVo confClassifiedChangeVo) {
        if (confClassifiedChangeVo != null) {
            Date date = new Date();
            ConfClassified confClassified = confClassifiedDao.findConfClassifiedById(confClassifiedChangeVo.getClassifiedId());
            if (confClassified != null) {
                ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsDao.findByClassifiedId(confClassifiedChangeVo.getClassifiedId());
                ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(confClassifiedDetails.getClassifiedContent(), ConfClassifiedDetailsVo.class);
                if (confClassifiedChangeVo.getAfterClassification() != null) {
                    ConfManageDetail confManageDetailByManageId = confManageDetailDao.findConfManageDetailById(confClassifiedChangeVo.getAfterClassification());
                    confClassified.setClassification(confClassifiedChangeVo.getAfterClassification());
                    confClassified.setClassificationSortNum(confManageDetailByManageId.getSortNum());
                }
                confClassified.setUpdateTime(date);
                confClassified.setIsUpdate("是");
                // 变更审批通过状态改为保密中
                confClassified.setChangeStatus(2);
                if (confClassifiedChangeVo.getAfterSecrecyTermType() != null) {
                    confClassified.setSecrecyTermType(confClassifiedChangeVo.getAfterSecrecyTermType());
                    confClassified.setSecrecyTermContent(confClassifiedChangeVo.getAfterSecrecyTermContent());
                    // 变更需要计算定密到期时间 如果不是3->自定义，那么计算到期时间
                    if (confClassifiedChangeVo.getAfterSecrecyTermType() == 1 ||
                            confClassifiedChangeVo.getAfterSecrecyTermType() == 2 ||
                            confClassifiedChangeVo.getAfterSecrecyTermType() == 3) {
//                        if (confClassified.getClassifiedExpire() != null) {
//                            Date date1 = DateUtils.addYearOrMonth(confClassified.getClassifiedExpire(), confClassifiedChangeVo.getAfterSecrecyTermType(), Integer.parseInt(confClassifiedChangeVo.getAfterSecrecyTermContent()));
//                            confClassified.setClassifiedExpire(date1);
//                        }
                        Date date1 = DateUtils.addYearOrMonth(confClassified.getIssueDate(), confClassifiedChangeVo.getAfterSecrecyTermType(), Integer.parseInt(confClassifiedChangeVo.getAfterSecrecyTermContent()));
                        confClassified.setClassifiedExpire(date1);
                    } else if (confClassifiedChangeVo.getAfterSecrecyTermType() == 6) { // 如果是6->解密时间，先判断是不是日期类型，不是就不管，是就计算到期时间
                        boolean b = TimeUtils.validDateEffecitive(confClassifiedChangeVo.getAfterSecrecyTermContent());
                        if (b) {
                            Date date1 = TimeUtils.stringToDate(confClassifiedChangeVo.getAfterSecrecyTermContent());
                            confClassified.setClassifiedExpire(date1);
                        }
                    }
                }
                if (confClassifiedChangeVo.getAfterRange() != null) {
                    confClassifiedDetailsVo.setRange(confClassifiedChangeVo.getAfterRange());
                }
                confClassifiedDetails.setClassifiedContent(JSONObject.toJSONString(confClassifiedDetailsVo));

                // 操作记录
                LogUtils.addOperationRecord(confClassifiedChangeVo.getClassifiedId(),"变更审核通过时间",date,MyThreadLocal.get().getId(),MyThreadLocal.get().getUserName(),MyThreadLocal.get().getUnitNameTwo());
                if (confClassifiedChangeVo.getId() != null) {
                    confClassifiedChangeDao.deleteById(confClassifiedChangeVo.getId());
                }
                confClassifiedDao.save(confClassified);
                confClassifiedDetailsDao.save(confClassifiedDetails);
            } else {
                throw new BizException("定密信息不存在");
            }
        } else {
            throw new BizException("定密变更信息不存在");
        }
    }
}
