package com.tykj.classified.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.*;
import com.tykj.classified.entity.db1.*;
import com.tykj.classified.entity.vo.ConfClassifiedAndDetailsVo;
import com.tykj.classified.entity.vo.ConfClassifiedDetailsVo;
import com.tykj.classified.entity.vo.UserVo;
import com.tykj.classified.entity.vo.classcount.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedCountService;
import com.tykj.classified.utils.SpringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.persistence.EntityManager;
import java.nio.file.Path;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author 邵越
 * @create 2022/11/18 13:33
 */
@Service
public class ConfClassifiedCountServiceImpl implements ConfClassifiedCountService {

    @Value("${employee.unitId}")
    private String code;

    private final ConfClassifiedDao confClassifiedDao;

    private final ConfClassifiedAuthDao confClassifiedAuthDao;

    private final ConfClassifiedDetailsDao confClassifiedDetailsDao;

    private final ConfOperationRecordDao confOperationRecordDao;

    private final ConfClassifiedDecryptDao confClassifiedDecryptDao;

    private final ConfClassifiedPersonLiableDao confClassifiedPersonLiableDao;

    private final ConfClassifiedTrainingDao confClassifiedTrainingDao;

    private final ConfClassifiedSystemDao confClassifiedSystemDao;

    private final DataUnitDao dataUnitDao;

    private ConfUnitNodeDao confUnitNodeDao;

    @Value("${unit.firstNode}")
    private String unitFirstNode;

    EntityManager entityManager;

    final ApplicationContext applicationContext;

    public ConfClassifiedCountServiceImpl(ConfClassifiedDao confClassifiedDao, ConfClassifiedAuthDao confClassifiedAuthDao, ConfClassifiedDetailsDao confClassifiedDetailsDao, ConfOperationRecordDao confOperationRecordDao, ConfClassifiedDecryptDao confClassifiedDecryptDao, ConfClassifiedPersonLiableDao confClassifiedPersonLiableDao, ConfClassifiedSystemDao confClassifiedSystemDao, ConfClassifiedTrainingDao confClassifiedTrainingDao, DataUnitDao dataUnitDao, ConfUnitNodeDao confUnitNodeDao, ApplicationContext applicationContext) {
        this.confClassifiedDao = confClassifiedDao;
        this.confClassifiedAuthDao = confClassifiedAuthDao;
        this.confClassifiedDetailsDao = confClassifiedDetailsDao;
        this.confOperationRecordDao = confOperationRecordDao;
        this.confClassifiedDecryptDao = confClassifiedDecryptDao;
        this.confClassifiedPersonLiableDao = confClassifiedPersonLiableDao;
        this.confClassifiedSystemDao = confClassifiedSystemDao;
        this.confClassifiedTrainingDao = confClassifiedTrainingDao;
        this.dataUnitDao = dataUnitDao;
        this.confUnitNodeDao = confUnitNodeDao;
        Map<String, EntityManager> beansOfType = applicationContext.getBeansOfType(EntityManager.class);
        for (String s : beansOfType.keySet()) {
            EntityManager entityManagerIndex = beansOfType.get(s);
            String persistenceUnitName = entityManagerIndex.getEntityManagerFactory().getProperties().get("hibernate.ejb.persistenceUnitName").toString();
            if (persistenceUnitName.equals("mysqlPersistenceUnit")) {
                entityManager = entityManagerIndex;
            }
        }
        this.applicationContext = applicationContext;
    }

    /**
     * 如果是刚登录进去,单位id为空且登录人的单位id是最大权限人,就看所有单位统计,否则只能看到自己单位的统计
     * 如果是点击单位id进入,只查看这个单位
     */
    @Override
    public ScreenCountVo getAllCount(String unitId) {
        UserVo userVo = MyThreadLocal.get();
        if (userVo == null) {
            throw new BizException("查询不到当前登录人");
        }
        //判断是否为最高级单位
        if (!StringUtils.hasText(unitId)){
            unitId = userVo.getUnitId();
        }

        boolean isHighUnit = unitId.equals(code);

        ScreenCountVo screenCountVo = new ScreenCountVo();
//        if (isHighUnit) {
//            screenCountVo.setIsAll(1);
//        } else {
//            screenCountVo.setIsAll(2);
//        }
        screenCountVo.setIsAll(2);

        DataUnit dataUnitByUnitId = dataUnitDao.findDataUnitByUnitId(unitId);
        screenCountVo.setUnitId(unitId);
        screenCountVo.setUnitName(dataUnitByUnitId.getUnitName());

        //授权情况统计数据
        ScreenAuthCountVo screenAuthCountVo = getScreenAuthCountVo(unitId);
        screenCountVo.setScreenAuthCountVo(screenAuthCountVo);

        //gj统计数据
        ScreenCityCountVo screenCityCountVo = getScreenCityCountVo(unitId);
        screenCountVo.setScreenCityCountVo(screenCityCountVo);
        //zrr统计数据
        ScreenChargeCountVo screenChargeCountVo = getScreenChargeCountVo(unitId);
        screenCountVo.setScreenChargeCountVo(screenChargeCountVo);
        //制度统计数据
        ScreenSystemCountVo screenSystemCountVo = getScreenSystemCountVo(unitId);
        screenCountVo.setScreenSystemCountVo(screenSystemCountVo);
        //培训统计数据
        ScreenTrainingCountVo screenTrainingCountVo = getScreenTrainingCountVo(unitId);
        screenCountVo.setScreenTrainingCountVo(screenTrainingCountVo);
        //工作mm情况
        ScreenWorkCountVo screenWorkCountVo = getScreenWorkCountVo(unitId);
        screenCountVo.setScreenWorkCountVo(screenWorkCountVo);

        // 查询是否是委托单位
        Integer isClient = getIsClient(unitId);
        screenCountVo.setIsClient(isClient);

        //数据提交情况1.市级,2.市以外
//        if (isHighUnit) {
//            ScreenAllProblemVo screenAllProblemVo = getScreenAllProblemVo();
//            screenCountVo.setScreenAllProblemVo(screenAllProblemVo);
//        } else {
//            ScreenProblemVo screenProblemVo = getScreenProblemVo(screenCountVo);
//            screenCountVo.setScreenProblemVo(screenProblemVo);
//        }
        ScreenProblemVo screenProblemVo = getScreenProblemVo(screenCountVo);
        screenCountVo.setScreenProblemVo(screenProblemVo);
        return screenCountVo;

    }

    /**
     * 点节点
     */
    @Override
    public ScreenCountVo getAllCount2(String nodeId) {
        UserVo userVo = MyThreadLocal.get();
        if (userVo == null) {
            throw new BizException("查询不到当前登录人");
        }
        List<String> unitIdList;
        ConfUnitNode confUnitNode = confUnitNodeDao.findConfUnitNodeById(nodeId);
        if (nodeId.equals("0")) { // 如果是杭州市,查全部
            List<DataUnit> all = dataUnitDao.findAll();
            unitIdList = all.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
        } else { // 其他节点
            // 查询所有单位
            List<DataUnit> dataUnitList = dataUnitDao.findAll();
            List<DataUnit> newDataUnitList = new ArrayList<>();
            List<DataUnit> allDataUnitList = new ArrayList<>();
            String sql = "from ConfUnitNode  where nodeRelationship like '%"+ nodeId +"%'";
            // 获取到所有叶子节点和当前节点
            List<ConfUnitNode> all = entityManager.createQuery(sql).getResultList();
            for (ConfUnitNode unitNode : all) {
                // 只要是单位节点,就去匹配所有单位
                if (confUnitNode.getIsUnitNode()) {
                    if (confUnitNode.getUnitType().equals("全部")) {
                        newDataUnitList = dataUnitList.stream()
                                .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()))
                                .collect(Collectors.toList());
                    } else {
                        newDataUnitList = dataUnitList.stream()
                                .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()) &&
                                        dataUnit.getUnitNature().equals(confUnitNode.getUnitType()))
                                .collect(Collectors.toList());
                    }
                }
                // 查询出所有匹配的单位并存入进去
                allDataUnitList.addAll(newDataUnitList);
            }
            unitIdList = allDataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
        }

        ScreenCountVo screenCountVo = new ScreenCountVo();
        screenCountVo.setIsAll(1);

        screenCountVo.setUnitName(confUnitNode.getNodeName());

        //授权情况统计数据
        ScreenAuthCountVo screenAuthCountVo = getScreenAuthCountVo2(unitIdList);
        screenCountVo.setScreenAuthCountVo(screenAuthCountVo);

        //gj统计数据
        ScreenCityCountVo screenCityCountVo = getScreenCityCountVo2(unitIdList);
        screenCountVo.setScreenCityCountVo(screenCityCountVo);
        //zrr统计数据
        ScreenChargeCountVo screenChargeCountVo = getScreenChargeCountVo2(unitIdList);
        screenCountVo.setScreenChargeCountVo(screenChargeCountVo);
        //制度统计数据
        ScreenSystemCountVo screenSystemCountVo = getScreenSystemCountVo2(unitIdList);
        screenCountVo.setScreenSystemCountVo(screenSystemCountVo);
        //培训统计数据
        ScreenTrainingCountVo screenTrainingCountVo = getScreenTrainingCountVo2(unitIdList);
        screenCountVo.setScreenTrainingCountVo(screenTrainingCountVo);
        //工作mm情况
        ScreenWorkCountVo screenWorkCountVo = getScreenWorkCountVo2(unitIdList);
        screenCountVo.setScreenWorkCountVo(screenWorkCountVo);

        screenCountVo.setIsClient(0);

        //数据提交情况
        ScreenAllProblemVo screenAllProblemVo = getScreenAllProblemVo2(unitIdList);
        screenCountVo.setScreenAllProblemVo(screenAllProblemVo);

        return screenCountVo;
    }

//    /**
//     * 点节点
//     */
//    @Override
//    public ScreenCountVo getAllCount2(String nodeId) {
//        UserVo userVo = MyThreadLocal.get();
//        if (userVo == null) {
//            throw new BizException("查询不到当前登录人");
//        }
//        List<String> unitIdList = new ArrayList<>();
//        DataUnit dataUnitByUnitId = dataUnitDao.findDataUnitByUnitId(userVo.getUnitId());
//        ConfUnitNode confUnitNode;
//        if (nodeId.equals("0")) { // 如果是杭州市,查全部
//            if (dataUnitByUnitId.getIsManageNode()) { // 如果是管理单位,查询所有数据
//                confUnitNode = confUnitNodeDao.findConfUnitNodeById(nodeId);
//                PredicateBuilder<DataUnit> predicateBuilder = Specifications.and();
//                predicateBuilder.eq("isClient",true);
//                predicateBuilder.eq("unitClientId",userVo.getUnitId());
//
//                PredicateBuilder<DataUnit> predicateBuilder2 = Specifications.and();
//                predicateBuilder2.eq("unitId",userVo.getUnitId());
//                List<DataUnit> allByIsClientAndUnitClientId = dataUnitDao.findAll(predicateBuilder.build().or(predicateBuilder2.build()));
//                unitIdList = allByIsClientAndUnitClientId.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
//            } else {
//                unitIdList.add(userVo.getUnitId());
//            }
//        } else {
//            List<DataUnit> allByUnitAreaAndUnitNature;
//            confUnitNode = confUnitNodeDao.findConfUnitNodeById(nodeId);
//            if (confUnitNode.getUnitType().equals("全部")) {
//                PredicateBuilder<DataUnit> predicateBuilder = Specifications.and();
//                predicateBuilder.eq("unitArea",confUnitNode.getUnitTerritoryId());
//                predicateBuilder.eq("isClient",true);
//                predicateBuilder.eq("unitClientId",userVo.getUnitId());
//
//                PredicateBuilder<DataUnit> predicateBuilder2 = Specifications.and();
//                predicateBuilder2.eq("unitArea",confUnitNode.getUnitTerritoryId());
//                predicateBuilder2.eq("unitId",userVo.getUnitId());
//                allByUnitAreaAndUnitNature = dataUnitDao.findAll(predicateBuilder.build().or(predicateBuilder2.build()));
//            } else {
//                PredicateBuilder<DataUnit> predicateBuilder = Specifications.and();
//                predicateBuilder.eq("unitArea",confUnitNode.getUnitTerritoryId());
//                predicateBuilder.eq("unitNature",confUnitNode.getUnitType());
//                predicateBuilder.eq("isClient",true);
//                predicateBuilder.eq("unitClientId",userVo.getUnitId());
//
//                PredicateBuilder<DataUnit> predicateBuilder2 = Specifications.and();
//                predicateBuilder2.eq("unitArea",confUnitNode.getUnitTerritoryId());
//                predicateBuilder.eq("unitNature",confUnitNode.getUnitType());
//                predicateBuilder2.eq("unitId",userVo.getUnitId());
//                allByUnitAreaAndUnitNature = dataUnitDao.findAll(predicateBuilder.build().or(predicateBuilder2.build()));
//            }
//            unitIdList = allByUnitAreaAndUnitNature.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
//        }
//
//        ScreenCountVo screenCountVo = new ScreenCountVo();
//        screenCountVo.setIsAll(1);
//
//
//        screenCountVo.setUnitName(confUnitNode.getNodeName());
//
//        //授权情况统计数据
//        ScreenAuthCountVo screenAuthCountVo = getScreenAuthCountVo2(unitIdList);
//        screenCountVo.setScreenAuthCountVo(screenAuthCountVo);
//
//        //gj统计数据
//        ScreenCityCountVo screenCityCountVo = getScreenCityCountVo2(unitIdList);
//        screenCountVo.setScreenCityCountVo(screenCityCountVo);
//        //zrr统计数据
//        ScreenChargeCountVo screenChargeCountVo = getScreenChargeCountVo2(unitIdList);
//        screenCountVo.setScreenChargeCountVo(screenChargeCountVo);
//        //制度统计数据
//        ScreenSystemCountVo screenSystemCountVo = getScreenSystemCountVo2(unitIdList);
//        screenCountVo.setScreenSystemCountVo(screenSystemCountVo);
//        //培训统计数据
//        ScreenTrainingCountVo screenTrainingCountVo = getScreenTrainingCountVo2(unitIdList);
//        screenCountVo.setScreenTrainingCountVo(screenTrainingCountVo);
//        //工作mm情况
//        ScreenWorkCountVo screenWorkCountVo = getScreenWorkCountVo2(unitIdList);
//        screenCountVo.setScreenWorkCountVo(screenWorkCountVo);
//
//        screenCountVo.setIsClient(0);
//
//        //数据提交情况
//        ScreenAllProblemVo screenAllProblemVo = getScreenAllProblemVo2(unitIdList);
//        screenCountVo.setScreenAllProblemVo(screenAllProblemVo);
//
//        return screenCountVo;
//    }

    @Override
    public List<ConfUnitNode> getUnitTree() {
        List<ConfUnitNode> confUnitNodeTree;
        DataUnit dataUnitByUnitId = dataUnitDao.findDataUnitByUnitId(MyThreadLocal.get().getUnitId());
        if (dataUnitByUnitId.getIsManageNode() != null && dataUnitByUnitId.getIsManageNode()) { // 如果是管理单位
            // 查出所有管理节点
            List<ConfUnitNode> allByIsManageNodeAndUnitManagementId = confUnitNodeDao.findAllByIsManageNodeAndUnitManagementId(true, dataUnitByUnitId.getUnitId());
            if (allByIsManageNodeAndUnitManagementId.size() > 0) { // 如果有就调用此方法
                confUnitNodeTree = findDataUnitTreeByUnitNode(allByIsManageNodeAndUnitManagementId);
            } else { // 没有管理节点给管理单位
                // 只查当前单位的树
                confUnitNodeTree = findDataUnitTreeByUnit(dataUnitByUnitId);
            }
        } else { // 如果不是管理单位
            // 只查当前单位的树
            confUnitNodeTree = findDataUnitTreeByUnit(dataUnitByUnitId);
        }
        return confUnitNodeTree;
    }

    private List<ConfUnitNode> findDataUnitTreeByUnitNode(List<ConfUnitNode> allByIsManageNodeAndUnitManagementId) {
        List<ConfUnitNode> confUnitNodeTree = new ArrayList<>();
        // 先循环以下看看有没有杭州市这个最大节点作为管理节点
        int i = 0;
        for (ConfUnitNode confUnitNode : allByIsManageNodeAndUnitManagementId) {
            if (confUnitNode.getId().equals("0")) {
                i = 1;
            }
        }
        if (i == 1) { // 如果有,直接生成完整的树
            confUnitNodeTree = findDataUnitTree();
        } else { // 如果没有,只用第一个作为节点
            // 查询所有单位
            List<DataUnit> dataUnitList = dataUnitDao.findAll();
            ConfUnitNode confUnitNode = allByIsManageNodeAndUnitManagementId.get(0);
            // 查询节点下所有的节点包括它自己
            String sql = "from ConfUnitNode  where nodeRelationship like '%"+ confUnitNode.getId() +"%'";
            // 获取到所有叶子节点和当前节点
            List<ConfUnitNode> childrenList = entityManager.createQuery(sql).getResultList();

            // 匹配上的单位放这个list下
            List<DataUnit> newDataUnitList;
            // 所有匹配上的单位list
            List<DataUnit> allDataUnitList = new ArrayList<>();
            for (ConfUnitNode unitNode : childrenList) {
                if (unitNode.getUnitType().equals("全部")) {
                    newDataUnitList = dataUnitList.stream()
                            .filter(dataUnit -> dataUnit.getUnitArea().equals(unitNode.getUnitTerritoryId()))
                            .collect(Collectors.toList());
                } else {
                    newDataUnitList = dataUnitList.stream()
                            .filter(dataUnit -> dataUnit.getUnitArea().equals(unitNode.getUnitTerritoryId()) &&
                                    dataUnit.getUnitNature().equals(unitNode.getUnitType()))
                            .collect(Collectors.toList());
                }
                // 查询出所有匹配的单位并存入进去
                allDataUnitList.addAll(newDataUnitList);
            }
            List<ConfUnitNode> newConfUnitNodeList = new ArrayList<>();
            Map<String, List<DataUnit>> collect = allDataUnitList.stream().collect(Collectors.groupingBy(ConfClassifiedCountServiceImpl::fetchGroupKey));
            Map<String, List<DataUnit>> collect3 = allDataUnitList.stream().collect(Collectors.groupingBy(DataUnit::getUnitArea));
            ConfUnitNode dataUnitConfUnitNode;
            // 将所有单位变成单位节点树
            for (ConfUnitNode unitNode : childrenList) {
                if (unitNode.getIsUnitNode()) { // 是单位节点就查询单位
                    List<DataUnit> orDefault;
                    if (unitNode.getUnitType().equals("全部")) {
                        orDefault = collect3.getOrDefault(unitNode.getUnitTerritoryId(), new ArrayList<>());
                    } else {
                        orDefault = collect.getOrDefault(unitNode.getUnitTerritoryId() + "_" + unitNode.getUnitType(), new ArrayList<>());
                    }
                    for (DataUnit dataUnit : orDefault) {
                        dataUnitConfUnitNode = new ConfUnitNode();
                        dataUnitConfUnitNode.setId(dataUnit.getUnitId());
                        dataUnitConfUnitNode.setParentId(unitNode.getId());
                        dataUnitConfUnitNode.setNodeName(dataUnit.getUnitName());
                        dataUnitConfUnitNode.setNodeLevel("0");
                        newConfUnitNodeList.add(dataUnitConfUnitNode);
                    }
                }
            }
            childrenList.addAll(newConfUnitNodeList);
            //获取父节点
            List<ConfUnitNode> collect2 = childrenList.stream().filter(m -> confUnitNode.getId().equals(m.getParentId())).map(
                    (m) -> {
                        m.setChildNodes(getChildrenList(m, childrenList));
                        return m;
                    }
            ).collect(Collectors.toList());
            confUnitNode.setChildNodes(collect2);
            confUnitNodeTree.add(confUnitNode);
        }
        return confUnitNodeTree;
    }


//    @Override
//    public List<ConfUnitNode> getUnitTree() {
//        List<ConfUnitNode> confUnitNodeTree;
//        if (MyThreadLocal.get().getUnitIdTwo().equals(code)) { // 如果是最大,查询全部
//            confUnitNodeTree = findDataUnitTree();
//        } else { // 只查当前单位
//            confUnitNodeTree = findDataUnitTreeByUnit(MyThreadLocal.get().getUnitIdTwo());
//        }
//        return confUnitNodeTree;
//    }

    /**
     * 将所有节点和所有节点下的单位传进来拼成树
     * @param all
     * @param allByUnitArea
     * @return
     */
    private List<ConfUnitNode> findDataUnitTreeByConfUnitNode(List<ConfUnitNode> all,List<DataUnit> allByUnitArea) {
        List<ConfUnitNode> newTree = new ArrayList<>();
        List<ConfUnitNode> manageUnitCodeList = new ArrayList<>();
        // 按单位属地id分组
        Map<String, List<DataUnit>> collect2 = allByUnitArea.stream()
                .collect(Collectors.groupingBy(DataUnit::getUnitArea));
        // 按单位属地id+单位类型分组
        Map<String, List<DataUnit>> collect = allByUnitArea.stream()
                .collect(Collectors.groupingBy(ConfClassifiedCountServiceImpl::fetchGroupKey));
        ConfUnitNode newConfUnitNode;
        for (ConfUnitNode confUnitNode : all) {
            List<DataUnit> orDefault;
            if (confUnitNode.getUnitType().equals("全部")) {
                orDefault = collect2.getOrDefault(confUnitNode.getUnitTerritoryId(), new ArrayList<>());
            } else {
                orDefault = collect.getOrDefault(confUnitNode.getUnitTerritoryId()+"_"+confUnitNode.getUnitType(), new ArrayList<>());
            }
            // 节点匹配上单位,将单位转成节点
            if (orDefault.size() > 0) {
                for (DataUnit dataUnit : orDefault) {
                    newConfUnitNode = new ConfUnitNode();
                    newConfUnitNode.setId(dataUnit.getUnitId());
                    newConfUnitNode.setParentId(confUnitNode.getId());
                    newConfUnitNode.setNodeName(dataUnit.getUnitName());
                    newConfUnitNode.setNodeLevel("0");
                    manageUnitCodeList.add(newConfUnitNode);
                }
            }
        }
        all.addAll(manageUnitCodeList);
        // 获取父节点
        List<ConfUnitNode> collect4 = all.stream().filter(m -> unitFirstNode.equals(m.getParentId())).map(
                (m) -> {
                    m.setChildNodes(getChildrenList(m, manageUnitCodeList));
                    return m;
                }
        ).collect(Collectors.toList());
        newTree.addAll(collect4);
//        List<ConfUnitNode> manageUnitCodeList = new ArrayList<>();
//        // 查询所有单位节点树
//        List<ConfUnitNode> confUnitNodeList = confUnitNodeDao.findAll();
//
//        PredicateBuilder<DataUnit> predicateBuilder = Specifications.and();
//        predicateBuilder.eq("isClient",true);
//        predicateBuilder.eq("unitClientId",dataUnitByUnitId.getUnitId());
//
//        PredicateBuilder<DataUnit> predicateBuilder2 = Specifications.and();
//        predicateBuilder2.eq("unitId",dataUnitByUnitId.getUnitId());
//        // 查询出被委托的单位和自己单位
//        List<DataUnit> dataUnitList = dataUnitDao.findAll(predicateBuilder.build().or(predicateBuilder2.build()));
//
//        // 按单位属地id分组
//        Map<String, List<DataUnit>> collect2 = dataUnitList.stream()
//                .collect(Collectors.groupingBy(DataUnit::getUnitArea));
//        // 按单位属地id+单位类型分组
//        Map<String, List<DataUnit>> collect = dataUnitList.stream()
//                .collect(Collectors.groupingBy(ConfClassifiedCountServiceImpl::fetchGroupKey));
//        // 存放底层节点的list
//        List<ConfUnitNode> newConfUnitNodeList2 = new ArrayList<>();
//        ConfUnitNode newConfUnitNode;
//        for (ConfUnitNode confUnitNode : confUnitNodeList) {
//            List<DataUnit> orDefault;
//            if (confUnitNode.getUnitType().equals("全部")) {
//                orDefault = collect2.getOrDefault(confUnitNode.getUnitTerritoryId(), new ArrayList<>());
//            } else {
//                orDefault = collect.getOrDefault(confUnitNode.getUnitTerritoryId()+"_"+confUnitNode.getUnitType(), new ArrayList<>());
//            }
//            // 节点匹配上单位,将单位转成节点
//            if (orDefault.size() > 0) {
//                for (DataUnit dataUnit : orDefault) {
//                    newConfUnitNode = new ConfUnitNode();
//                    newConfUnitNode.setId(dataUnit.getUnitId());
//                    newConfUnitNode.setParentId(confUnitNode.getId());
//                    newConfUnitNode.setNodeName(dataUnit.getUnitName());
//                    newConfUnitNode.setNodeLevel("0");
//                    manageUnitCodeList.add(newConfUnitNode);
//                }
//                newConfUnitNodeList2.add(confUnitNode);
//            }
//        }
//        List<String> pathList = new ArrayList<>();
//        for (ConfUnitNode confUnitNode : newConfUnitNodeList2) {
//            // 节点路径
//            List<String> stringList = Arrays.asList(confUnitNode.getNodeRelationship().split("\\."));
//            pathList.addAll(stringList);
//        }
//        List<String> filterPathList = pathList.stream()
//                .distinct()
//                .collect(Collectors.toList());
//        // 根据节点id分组
//        Map<String, List<ConfUnitNode>> collect3 = confUnitNodeList.stream().collect(Collectors.groupingBy(ConfUnitNode::getId));
//        // 过滤出只有这个单位节点的对象
//        filterPathList.forEach(n -> {
//            // 包含这个节点
//            if (collect3.containsKey(n)) {
//                manageUnitCodeList.add(collect3.get(n).get(0));
//            }
//        });
//        //获取父节点
//        List<ConfUnitNode> collect4 = manageUnitCodeList.stream().filter(m -> unitFirstNode.equals(m.getParentId())).map(
//                (m) -> {
//                    m.setChildNodes(getChildrenList(m, manageUnitCodeList));
//                    return m;
//                }
//        ).collect(Collectors.toList());
//        // 获取顶级节点
//        List<ConfUnitNode> firstNode = confUnitNodeList.stream()
//                .filter(confUnitNode -> confUnitNode.getId().equals(unitFirstNode))
//                .collect(Collectors.toList());
//        if (firstNode.size() > 0) {
//            // 顶级节点
//            ConfUnitNode confFirstUnitNode = firstNode.get(0);
//            confFirstUnitNode.setChildNodes(collect4);
//            List<ConfUnitNode> newTree = new ArrayList<>();
//            newTree.add(confFirstUnitNode);
//            return newTree;
//        } else {
//            throw new BizException("顶级节点不存在!");
//        }
        return newTree;
    }

    // 根据节点id获取节点id下面所有的节点并得到所有单位
    private List<String> getUnitIdList(String nodeId) {
        List<String> unitIdList = new ArrayList<>();
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(nodeId)) {
            if (nodeId.equals("0")) { // 选杭州市
                if (MyThreadLocal.get().getUnitIdTwo().equals(code)) {
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    unitIdList = dataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitIdTwo());
                    return unitIdList;
                }
            } else {
                if (MyThreadLocal.get().getUnitIdTwo().equals(code)) {
                    String sql = "from ConfUnitNode  where nodeRelationship like '%"+ nodeId +"%'";
                    // 获取到所有叶子节点和当前节点
                    List<ConfUnitNode> all = entityManager.createQuery(sql).getResultList();
                    // 查询所有单位
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    List<ConfUnitNode> unitNodeList = new ArrayList<>();
                    List<DataUnit> newDataUnitList = new ArrayList<>();
                    List<DataUnit> allDataUnitList = new ArrayList<>();
                    for (ConfUnitNode confUnitNode : all) {
                        // 只要是单位节点,就去匹配所有单位
                        if (confUnitNode.getIsUnitNode()) {
                            if (confUnitNode.getUnitType().equals("全部")) {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()))
                                        .collect(Collectors.toList());
                            } else {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()) &&
                                                dataUnit.getUnitNature().equals(confUnitNode.getUnitType()))
                                        .collect(Collectors.toList());
                            }
                        }
                        // 查询出所有匹配的单位并存入进去
                        allDataUnitList.addAll(newDataUnitList);
                    }
                    unitIdList = allDataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    unitIdList = unitIdList.stream().distinct().collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitIdTwo());
                    return unitIdList;
                }
            }
        } else {
            throw new BizException("请选择节点!");
        }
    }

    // 获取所有单位未设定的信息
    private List<ScreenUnitCountVo> getIsHaveUnit() {
        //获取到所有的单位
        List<DataUnit> dataUnitList = dataUnitDao.findAll();

        List<ConfClassifiedPersonLiable> confClassifiedPersonLiableList = confClassifiedPersonLiableDao.findAll();
        Map<String, List<ConfClassifiedPersonLiable>> confClassifiedPersonLiableMap = confClassifiedPersonLiableList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedPersonLiable::getFillingUnitId));
        List<ConfClassifiedSystem> confClassifiedSystemList = confClassifiedSystemDao.findAll();
        Map<String, List<ConfClassifiedSystem>> confClassifiedSystemMap = confClassifiedSystemList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedSystem::getFillingUnitId));
        List<ConfClassifiedTraining> confClassifiedTrainingList = confClassifiedTrainingDao.findAll();
        Map<String, List<ConfClassifiedTraining>> confClassifiedTrainingMap = confClassifiedTrainingList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedTraining::getFillingUnitId));
        List<ScreenUnitCountVo> screenUnitCountVoList = new ArrayList<>();

        for (DataUnit dataUnit : dataUnitList) {
            ScreenUnitCountVo screenUnitCountVo = new ScreenUnitCountVo();
            screenUnitCountVo.setUnitId(dataUnit.getUnitId());
            screenUnitCountVo.setUnitName(dataUnit.getUnitName());
            Integer num = 0;
            List<ConfClassifiedPersonLiable> confClassifiedPersonLiableListHave = confClassifiedPersonLiableMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedPersonLiableListHave)) {
                screenUnitCountVo.setIsHaveZrr(1);
                num++;
            } else {
                screenUnitCountVo.setIsHaveZrr(2);
            }
            List<ConfClassifiedSystem> confClassifiedSystemListHave = confClassifiedSystemMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedSystemListHave)) {
                screenUnitCountVo.setIsHaveSystem(1);
                num++;
            } else {
                screenUnitCountVo.setIsHaveSystem(2);
            }
            List<ConfClassifiedTraining> confClassifiedTrainingListHave = confClassifiedTrainingMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedTrainingListHave)) {
                screenUnitCountVo.setIsHaveTraining(1);
                num++;
            } else {
                screenUnitCountVo.setIsHaveTraining(2);
            }
            screenUnitCountVo.setIsNoConfigNum(num);
            screenUnitCountVoList.add(screenUnitCountVo);
        }
        return screenUnitCountVoList;
    }

    private List<ConfUnitNode> findDataUnitTreeByUnit(DataUnit dataUnitByUnitId) {
        List<ConfUnitNode> newTree = new ArrayList<>();
        ConfUnitNode childrenConfUnitNode = new ConfUnitNode();
        childrenConfUnitNode.setId(dataUnitByUnitId.getUnitId());
        childrenConfUnitNode.setParentId("");
        childrenConfUnitNode.setNodeName(dataUnitByUnitId.getUnitName());
        // 当level为0时是个单位
        childrenConfUnitNode.setNodeLevel("0");
        childrenConfUnitNode.setChildNodes(null);
        newTree.add(childrenConfUnitNode);
//        List<ConfUnitNode> newTree = new ArrayList<>();
//        // 查询所有单位节点树
//        List<ConfUnitNode> confUnitNodeList = confUnitNodeDao.findAll();
//        // 查询出该单位
//        DataUnit dataUnitByUnitId = dataUnitDao.findDataUnitByUnitId(unitId);
//        PredicateBuilder<ConfUnitNode> predicateBuilder = Specifications.and();
//        predicateBuilder.eq("isUnitNode",true);
//        predicateBuilder.eq("unitTerritoryId",dataUnitByUnitId.getUnitArea());
//        predicateBuilder.eq("unitType",dataUnitByUnitId.getUnitNature());
//
//        PredicateBuilder<ConfUnitNode> predicateBuilder2 = Specifications.and();
//        predicateBuilder2.eq("isUnitNode",true);
//        predicateBuilder2.eq("unitTerritoryId",dataUnitByUnitId.getUnitArea());
//        predicateBuilder2.eq("unitType","全部");
//        // 查询所有有关的节点
//        List<ConfUnitNode> all = confUnitNodeDao.findAll(predicateBuilder.build().or(predicateBuilder2.build()));
//        if (all.size() > 0) { // 如果有节点,就生成树
//            List<String> pathList = new ArrayList<>();
//            List<ConfUnitNode> childrenConfUnitNodeList = new ArrayList<>();
//            ConfUnitNode childrenConfUnitNode;
//            for (ConfUnitNode confUnitNode : all) {
//                // 将所有单位放在最底层节点下
//                childrenConfUnitNode = new ConfUnitNode();
//                childrenConfUnitNode.setId(dataUnitByUnitId.getUnitId());
//                childrenConfUnitNode.setParentId(confUnitNode.getId());
//                childrenConfUnitNode.setNodeName(dataUnitByUnitId.getUnitName());
//                // 当level为0时是个单位
//                childrenConfUnitNode.setNodeLevel("0");
//                childrenConfUnitNodeList.add(childrenConfUnitNode);
//                // 节点路径
//                List<String> stringList = Arrays.asList(confUnitNode.getNodeRelationship().split("\\."));
//                pathList.addAll(stringList);
//            }
//            List<String> filterPathList = pathList.stream()
//                    .distinct()
//                    .collect(Collectors.toList());
//            // 根据节点id分组
//            Map<String, List<ConfUnitNode>> collect = confUnitNodeList.stream().collect(Collectors.groupingBy(ConfUnitNode::getId));
//            // 过滤出只有这个单位节点的对象
//            filterPathList.forEach(n -> {
//                // 包含这个节点
//                if (collect.containsKey(n)) {
//                    childrenConfUnitNodeList.add(collect.get(n).get(0));
//                }
//            });
//            //获取父节点
//            List<ConfUnitNode> collect2 = childrenConfUnitNodeList.stream().filter(m -> unitFirstNode.equals(m.getParentId())).map(
//                    (m) -> {
//                        m.setChildNodes(getChildrenList(m, childrenConfUnitNodeList));
//                        return m;
//                    }
//            ).collect(Collectors.toList());
//            // 获取顶级节点
//            List<ConfUnitNode> firstNode = confUnitNodeList.stream()
//                    .filter(confUnitNode2 -> confUnitNode2.getId().equals(unitFirstNode))
//                    .collect(Collectors.toList());
//            if (firstNode.size() > 0) {
//                // 顶级节点
//                ConfUnitNode confFirstUnitNode = firstNode.get(0);
//                confFirstUnitNode.setChildNodes(collect2);
//                newTree.add(confFirstUnitNode);
//                return newTree;
//            } else {
//                throw new BizException("顶级节点不存在!");
//            }
//        } else { // 如果没有节点,就杭州市最大节点下面
//            List<ConfUnitNode> childrenConfUnitNodeList = new ArrayList<>();
//            // 获取顶级节点
//            List<ConfUnitNode> firstNode = confUnitNodeList.stream()
//                    .filter(confUnitNode2 -> confUnitNode2.getId().equals(unitFirstNode))
//                    .collect(Collectors.toList());
//            ConfUnitNode confUnitNode = new ConfUnitNode();
//            confUnitNode.setId(dataUnitByUnitId.getUnitId());
//            confUnitNode.setParentId("0");
//            confUnitNode.setNodeName(dataUnitByUnitId.getUnitName());
//            childrenConfUnitNodeList.add(confUnitNode);
//            if (firstNode.size() > 0) {
//                // 顶级节点
//                ConfUnitNode confFirstUnitNode = firstNode.get(0);
//                confFirstUnitNode.setChildNodes(childrenConfUnitNodeList);
//                newTree.add(confFirstUnitNode);
//                return newTree;
//            } else {
//                throw new BizException("顶级节点不存在!");
//            }
//        }
        return newTree;
    }

    private List<ConfUnitNode> findDataUnitTree() {
        // 查询所有单位
        List<DataUnit> dataUnitList = dataUnitDao.findAll();
        // 查询所有单位节点树
        List<ConfUnitNode> confUnitNodeList = confUnitNodeDao.findAll();
        List<ConfUnitNode> newConfUnitNodeList = new ArrayList<>();
        Map<String, List<DataUnit>> collect = dataUnitList.stream().collect(Collectors.groupingBy(ConfClassifiedCountServiceImpl::fetchGroupKey));
        Map<String, List<DataUnit>> collect3 = dataUnitList.stream().collect(Collectors.groupingBy(DataUnit::getUnitArea));
        ConfUnitNode confUnitNode;
        // 将所有单位变成单位节点树
        for (ConfUnitNode unitNode : confUnitNodeList) {
            if (unitNode.getIsUnitNode()) { // 是单位节点就查询单位
                List<DataUnit> orDefault;
                if (unitNode.getUnitType().equals("全部")) {
                    orDefault = collect3.getOrDefault(unitNode.getUnitTerritoryId(), new ArrayList<>());
                } else {
                    orDefault = collect.getOrDefault(unitNode.getUnitTerritoryId() + "_" + unitNode.getUnitType(), new ArrayList<>());
                }
                for (DataUnit dataUnit : orDefault) {
                    confUnitNode = new ConfUnitNode();
                    confUnitNode.setId(dataUnit.getUnitId());
                    confUnitNode.setParentId(unitNode.getId());
                    confUnitNode.setNodeName(dataUnit.getUnitName());
                    confUnitNode.setNodeLevel("0");
                    newConfUnitNodeList.add(confUnitNode);
                }
            }
        }
        confUnitNodeList.addAll(newConfUnitNodeList);
        //获取父节点
        List<ConfUnitNode> collect2 = confUnitNodeList.stream().filter(m -> unitFirstNode.equals(m.getParentId())).map(
                (m) -> {
                    m.setChildNodes(getChildrenList(m, confUnitNodeList));
                    return m;
                }
        ).collect(Collectors.toList());

        // 获取顶级节点
        List<ConfUnitNode> firstNode = confUnitNodeList.stream()
                .filter(confUnitNode2 -> confUnitNode2.getId().equals(unitFirstNode))
                .collect(Collectors.toList());
        if (firstNode.size() > 0) {
            // 顶级节点
            ConfUnitNode confFirstUnitNode = firstNode.get(0);
            confFirstUnitNode.setChildNodes(collect2);
            List<ConfUnitNode> newTree = new ArrayList<>();
            newTree.add(confFirstUnitNode);
            return newTree;
        } else {
            throw new BizException("顶级节点不存在!");
        }
    }

    /**
     * 获取子节点列表
     *
     * @param tree
     * @param list
     * @return
     */
    public static List<ConfUnitNode> getChildrenList(ConfUnitNode tree, List<ConfUnitNode> list) {
        List<ConfUnitNode> children = list.stream().filter(item -> Objects.equals(item.getParentId(), tree.getId())).map(
                (item) -> {
                    item.setChildNodes(getChildrenList(item, list));
                    return item;
                }
        ).collect(Collectors.toList());
        return children;
    }

    // 拼接单位属地id+单位类型
    private static String fetchGroupKey(DataUnit confUnitNode) {
        return confUnitNode.getUnitArea() + "_" + confUnitNode.getUnitNature();
    }

    private ScreenAllProblemVo getScreenAllProblemVo() {

        //获取到所有的单位
        List<DataUnit> dataUnitList = dataUnitDao.findAll();


        List<ConfClassifiedPersonLiable> confClassifiedPersonLiableList = confClassifiedPersonLiableDao.findAll();
        Map<String, List<ConfClassifiedPersonLiable>> confClassifiedPersonLiableMap = confClassifiedPersonLiableList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedPersonLiable::getFillingUnitId));
        List<ConfClassifiedSystem> confClassifiedSystemList = confClassifiedSystemDao.findAll();
        Map<String, List<ConfClassifiedSystem>> confClassifiedSystemMap = confClassifiedSystemList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedSystem::getFillingUnitId));
        List<ConfClassifiedTraining> confClassifiedTrainingList = confClassifiedTrainingDao.findAll();
        Map<String, List<ConfClassifiedTraining>> confClassifiedTrainingMap = confClassifiedTrainingList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedTraining::getFillingUnitId));
        List<ScreenUnitCountVo> screenUnitCountVoList = new ArrayList<>();
        Long isHaveZrr = 0L;

        Long isHaveTraining = 0L;

        Long isHaveSystem = 0L;

        for (DataUnit dataUnit : dataUnitList) {
            ScreenUnitCountVo screenUnitCountVo = new ScreenUnitCountVo();
            screenUnitCountVo.setUnitId(dataUnit.getUnitId());
            screenUnitCountVo.setUnitName(dataUnit.getUnitName());
            Integer num = 0;
            List<ConfClassifiedPersonLiable> confClassifiedPersonLiableListHave = confClassifiedPersonLiableMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedPersonLiableListHave)) {
                screenUnitCountVo.setIsHaveZrr(1);
                num++;
                isHaveZrr++;
            } else {
                screenUnitCountVo.setIsHaveZrr(2);
            }
            List<ConfClassifiedSystem> confClassifiedSystemListHave = confClassifiedSystemMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedSystemListHave)) {
                screenUnitCountVo.setIsHaveSystem(1);
                isHaveSystem++;
                num++;
            } else {
                screenUnitCountVo.setIsHaveSystem(2);
            }
            List<ConfClassifiedTraining> confClassifiedTrainingListHave = confClassifiedTrainingMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedTrainingListHave)) {
                screenUnitCountVo.setIsHaveTraining(1);
                isHaveTraining++;
                num++;
            } else {
                screenUnitCountVo.setIsHaveTraining(2);
            }
            screenUnitCountVo.setIsNoConfigNum(num);
            screenUnitCountVoList.add(screenUnitCountVo);
        }

        ScreenAllProblemVo screenAllProblemVo = new ScreenAllProblemVo();
        screenAllProblemVo.setUnitNum(dataUnitList.size());

        screenAllProblemVo.setIsHaveZrr(isHaveZrr);
        screenAllProblemVo.setIsHaveTraining(isHaveTraining);
        screenAllProblemVo.setIsHaveSystem(isHaveSystem);

        List<ScreenUnitCountVo> screenUnitCountVo = screenUnitCountVoList.stream()
                .filter(screenUnitCountVoFind -> screenUnitCountVoFind.getIsNoConfigNum()!=0)
                .sorted(Comparator.comparing(ScreenUnitCountVo::getIsNoConfigNum).reversed())
                .limit(3)
                .collect(Collectors.toList());

        List<ScreenAllProblemUnitVo> screenAllProblemUnitVoList = new ArrayList<>();
        for (ScreenUnitCountVo unitCountVo : screenUnitCountVo) {
            ScreenAllProblemUnitVo screenAllProblemUnitVo = new ScreenAllProblemUnitVo();
            screenAllProblemUnitVo.setUnitId(unitCountVo.getUnitId());
            screenAllProblemUnitVo.setUnitName(unitCountVo.getUnitName());


            screenAllProblemUnitVoList.add(screenAllProblemUnitVo);
        }

        screenAllProblemVo.setScreenAllProblemUnitVos(screenAllProblemUnitVoList);


        return screenAllProblemVo;
    }

    private ScreenAllProblemVo getScreenAllProblemVo2(List<String> unitIdList) {

        //获取到所有的单位
        PredicateBuilder<DataUnit> predicateBuilder = Specifications.and();
        predicateBuilder.in("unitId",unitIdList);
        List<DataUnit> dataUnitList = dataUnitDao.findAll(predicateBuilder.build());

        PredicateBuilder<ConfClassifiedPersonLiable> predicateBuilder2 = Specifications.and();
        predicateBuilder2.in("fillingUnitId",unitIdList);
        List<ConfClassifiedPersonLiable> confClassifiedPersonLiableList = confClassifiedPersonLiableDao.findAll(predicateBuilder2.build());
        Map<String, List<ConfClassifiedPersonLiable>> confClassifiedPersonLiableMap = confClassifiedPersonLiableList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedPersonLiable::getFillingUnitId));

        PredicateBuilder<ConfClassifiedSystem> predicateBuilder3 = Specifications.and();
        predicateBuilder3.in("fillingUnitId",unitIdList);
        List<ConfClassifiedSystem> confClassifiedSystemList = confClassifiedSystemDao.findAll(predicateBuilder3.build());
        Map<String, List<ConfClassifiedSystem>> confClassifiedSystemMap = confClassifiedSystemList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedSystem::getFillingUnitId));

        PredicateBuilder<ConfClassifiedTraining> predicateBuilder4 = Specifications.and();
        predicateBuilder4.in("fillingUnitId",unitIdList);
        List<ConfClassifiedTraining> confClassifiedTrainingList = confClassifiedTrainingDao.findAll(predicateBuilder4.build());
        Map<String, List<ConfClassifiedTraining>> confClassifiedTrainingMap = confClassifiedTrainingList.stream()
                .collect(Collectors.groupingBy(ConfClassifiedTraining::getFillingUnitId));
        List<ScreenUnitCountVo> screenUnitCountVoList = new ArrayList<>();
        Long isHaveZrr = 0L;

        Long isHaveTraining = 0L;

        Long isHaveSystem = 0L;

        for (DataUnit dataUnit : dataUnitList) {
            ScreenUnitCountVo screenUnitCountVo = new ScreenUnitCountVo();
            screenUnitCountVo.setUnitId(dataUnit.getUnitId());
            screenUnitCountVo.setUnitName(dataUnit.getUnitName());
            Integer num = 0;
            List<ConfClassifiedPersonLiable> confClassifiedPersonLiableListHave = confClassifiedPersonLiableMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedPersonLiableListHave)) {
                screenUnitCountVo.setIsHaveZrr(1);
                num++;
                isHaveZrr++;
            } else {
                screenUnitCountVo.setIsHaveZrr(2);
            }
            List<ConfClassifiedSystem> confClassifiedSystemListHave = confClassifiedSystemMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedSystemListHave)) {
                screenUnitCountVo.setIsHaveSystem(1);
                isHaveSystem++;
                num++;
            } else {
                screenUnitCountVo.setIsHaveSystem(2);
            }
            List<ConfClassifiedTraining> confClassifiedTrainingListHave = confClassifiedTrainingMap.get(dataUnit.getUnitId());
            if (CollectionUtils.isEmpty(confClassifiedTrainingListHave)) {
                screenUnitCountVo.setIsHaveTraining(1);
                isHaveTraining++;
                num++;
            } else {
                screenUnitCountVo.setIsHaveTraining(2);
            }
            screenUnitCountVo.setIsNoConfigNum(num);
            screenUnitCountVoList.add(screenUnitCountVo);
        }

        ScreenAllProblemVo screenAllProblemVo = new ScreenAllProblemVo();
        screenAllProblemVo.setUnitNum(dataUnitList.size());

        screenAllProblemVo.setIsHaveZrr(isHaveZrr);
        screenAllProblemVo.setIsHaveTraining(isHaveTraining);
        screenAllProblemVo.setIsHaveSystem(isHaveSystem);

        List<ScreenUnitCountVo> screenUnitCountVo = screenUnitCountVoList.stream()
                .filter(screenUnitCountVoFind -> screenUnitCountVoFind.getIsNoConfigNum()!=0)
                .sorted(Comparator.comparing(ScreenUnitCountVo::getIsNoConfigNum).reversed())
                .limit(3)
                .collect(Collectors.toList());

        List<ScreenAllProblemUnitVo> screenAllProblemUnitVoList = new ArrayList<>();
        for (ScreenUnitCountVo unitCountVo : screenUnitCountVo) {
            ScreenAllProblemUnitVo screenAllProblemUnitVo = new ScreenAllProblemUnitVo();
            screenAllProblemUnitVo.setUnitId(unitCountVo.getUnitId());
            screenAllProblemUnitVo.setUnitName(unitCountVo.getUnitName());


            screenAllProblemUnitVoList.add(screenAllProblemUnitVo);
        }

        screenAllProblemVo.setScreenAllProblemUnitVos(screenAllProblemUnitVoList);
        return screenAllProblemVo;
    }

    private ScreenProblemVo getScreenProblemVo(ScreenCountVo screenCountVo) {

        ScreenProblemVo screenProblemVo = new ScreenProblemVo();
        //判断是否设置定密责任人
        ScreenChargeCountVo screenChargeCountVo = screenCountVo.getScreenChargeCountVo();
        if (screenChargeCountVo.getClassificationZrrNum2() == 0L
                && screenChargeCountVo.getClassificationZrrNum3() == 0L
                && screenChargeCountVo.getClassificationZrrNum4() == 0L) {
            screenProblemVo.setIsHaveZrr(1);
        } else {
            screenProblemVo.setIsHaveZrr(2);
        }

        //判断未记录定密培训是否为空
        ScreenTrainingCountVo screenTrainingCountVo = screenCountVo.getScreenTrainingCountVo();
        if (screenTrainingCountVo.getScreenTrainingNum() == 0L) {
            screenProblemVo.setIsHaveTraining(1);
        } else {
            screenProblemVo.setIsHaveTraining(2);
        }
        //判断定密制度是否为空
        ScreenSystemCountVo screenSystemCountVo = screenCountVo.getScreenSystemCountVo();
        if (screenSystemCountVo.getDmSystemNowNum() == 0L) {
            screenProblemVo.setIsHaveSystem(1);
        } else {
            screenProblemVo.setIsHaveSystem(2);
        }
        return screenProblemVo;
    }

    private ScreenWorkCountVo getScreenWorkCountVo(String unitId) {
        ScreenWorkCountVo screenWorkCountVo = new ScreenWorkCountVo();
        Long screenDetermineNum = 0L;
        Long screenYzNum = 0L;
        Long screenSzNum = 0L;
//        if (unitId.equals(code)) {
//            screenDetermineNum = confClassifiedDao.count();
//            screenYzNum = screenDetermineNum;
//            PredicateBuilder<ConfClassified> classifiedBuilder = Specifications.and();
//            classifiedBuilder.in("changeStatus", 2, 3, 4, 5, 6, 7, 8);
//            screenSzNum = confClassifiedDao.count(classifiedBuilder.build());
//        } else {
//            PredicateBuilder<ConfClassified> classifiedBuilder = Specifications.and();
//            classifiedBuilder.eq("operatorUnit", unitId);
//            screenDetermineNum = confClassifiedDao.count();
//            screenYzNum = screenDetermineNum;
//            classifiedBuilder.in("changeStatus", 2, 3, 4, 5, 6, 7, 8);
//            screenSzNum = confClassifiedDao.count(classifiedBuilder.build());
//
//        }
        PredicateBuilder<ConfClassified> classifiedBuilder = Specifications.and();
        classifiedBuilder.eq("operatorUnit", unitId);
        screenDetermineNum = confClassifiedDao.count();
        screenYzNum = screenDetermineNum;
        classifiedBuilder.in("changeStatus", 2, 3, 4, 5, 6, 7, 8);
        screenSzNum = confClassifiedDao.count(classifiedBuilder.build());
        screenWorkCountVo.setScreenDetermineNum(screenDetermineNum);
        screenWorkCountVo.setScreenYzNum(screenYzNum);
        screenWorkCountVo.setScreenSzNum(screenSzNum);

        return screenWorkCountVo;
    }

    private ScreenWorkCountVo getScreenWorkCountVo2(List<String> unitIdList) {
        ScreenWorkCountVo screenWorkCountVo = new ScreenWorkCountVo();
        Long screenDetermineNum = 0L;
        Long screenYzNum = 0L;
        Long screenSzNum = 0L;

        PredicateBuilder<ConfClassified> classifiedBuilder = Specifications.and();
        classifiedBuilder.in("operatorUnit", unitIdList);
        screenDetermineNum = confClassifiedDao.count();
        screenYzNum = screenDetermineNum;
        classifiedBuilder.in("changeStatus", 2, 3, 4, 5, 6, 7, 8);
        screenSzNum = confClassifiedDao.count(classifiedBuilder.build());

        screenWorkCountVo.setScreenDetermineNum(screenDetermineNum);
        screenWorkCountVo.setScreenYzNum(screenYzNum);
        screenWorkCountVo.setScreenSzNum(screenSzNum);

        return screenWorkCountVo;
    }

    private ScreenTrainingCountVo getScreenTrainingCountVo(String unitId) {
        List<ConfClassifiedTraining> confClassifiedTrainingList;
//        if (unitId.equals(code)) {
//            confClassifiedTrainingList = confClassifiedTrainingDao.findAll();
//        } else {
//            PredicateBuilder<ConfClassifiedTraining> classifiedTrainingBuilder = Specifications.and();
//            classifiedTrainingBuilder.eq("fillingUnitId", unitId);
//            confClassifiedTrainingList = confClassifiedTrainingDao.findAll(classifiedTrainingBuilder.build());
//        }
        PredicateBuilder<ConfClassifiedTraining> classifiedTrainingBuilder = Specifications.and();
        classifiedTrainingBuilder.eq("fillingUnitId", unitId);
        confClassifiedTrainingList = confClassifiedTrainingDao.findAll(classifiedTrainingBuilder.build());
        long unitSize = dataUnitDao.count();
        ScreenTrainingCountVo screenTrainingCountVo = new ScreenTrainingCountVo();
        screenTrainingCountVo.setCityNum(unitSize);
        Long screenTrainingNum = (long) confClassifiedTrainingList.size();

        Long screenTrainingTimeNum = 0L;

        Long screenTrainingPersonNum = 0L;
        for (ConfClassifiedTraining confClassifiedTraining : confClassifiedTrainingList) {

            screenTrainingTimeNum = screenTrainingTimeNum + Long.parseLong(confClassifiedTraining.getCreditHours());

            screenTrainingPersonNum = screenTrainingPersonNum + confClassifiedTraining.getTrainingPersonNum();
        }


        screenTrainingCountVo.setScreenTrainingNum(screenTrainingNum);
        screenTrainingCountVo.setScreenTrainingTimeNum(screenTrainingTimeNum);
        screenTrainingCountVo.setScreenTrainingPersonNum(screenTrainingPersonNum);

        return screenTrainingCountVo;
    }

    private ScreenTrainingCountVo getScreenTrainingCountVo2(List<String> unitIdList) {
        List<ConfClassifiedTraining> confClassifiedTrainingList;

        PredicateBuilder<ConfClassifiedTraining> classifiedTrainingBuilder = Specifications.and();
        classifiedTrainingBuilder.in("fillingUnitId", unitIdList);
        confClassifiedTrainingList = confClassifiedTrainingDao.findAll(classifiedTrainingBuilder.build());

        long unitSize = dataUnitDao.count();
        ScreenTrainingCountVo screenTrainingCountVo = new ScreenTrainingCountVo();
        screenTrainingCountVo.setCityNum(unitSize);
        Long screenTrainingNum = (long) confClassifiedTrainingList.size();

        Long screenTrainingTimeNum = 0L;

        Long screenTrainingPersonNum = 0L;
        for (ConfClassifiedTraining confClassifiedTraining : confClassifiedTrainingList) {

            screenTrainingTimeNum = screenTrainingTimeNum + Long.parseLong(confClassifiedTraining.getCreditHours());

            screenTrainingPersonNum = screenTrainingPersonNum + confClassifiedTraining.getTrainingPersonNum();
        }


        screenTrainingCountVo.setScreenTrainingNum(screenTrainingNum);
        screenTrainingCountVo.setScreenTrainingTimeNum(screenTrainingTimeNum);
        screenTrainingCountVo.setScreenTrainingPersonNum(screenTrainingPersonNum);

        return screenTrainingCountVo;
    }

    private ScreenSystemCountVo getScreenSystemCountVo(String unitId) {
        boolean isHighUnit = unitId.equals(code);
        Date thisYearFirstDate = getThisYearFirstDate();

        Long systemNowNum;
        Long systemYearNum;

//        if (isHighUnit) {
//            systemNowNum = confClassifiedSystemDao.count();
//            PredicateBuilder<ConfClassifiedSystem> classifiedSystemBuilder = Specifications.and();
//            classifiedSystemBuilder.ge("createTime", thisYearFirstDate);
//            systemYearNum = confClassifiedSystemDao.count(classifiedSystemBuilder.build());
//        } else {
//            PredicateBuilder<ConfClassifiedSystem> classifiedSystemBuilder = Specifications.and();
//            classifiedSystemBuilder.eq("fillingUnitId", unitId);
//            systemNowNum = confClassifiedSystemDao.count(classifiedSystemBuilder.build());
//            classifiedSystemBuilder.ge("createTime", thisYearFirstDate);
//            systemYearNum = confClassifiedSystemDao.count(classifiedSystemBuilder.build());
//        }
        PredicateBuilder<ConfClassifiedSystem> classifiedSystemBuilder = Specifications.and();
        classifiedSystemBuilder.eq("fillingUnitId", unitId);
        systemNowNum = confClassifiedSystemDao.count(classifiedSystemBuilder.build());
        classifiedSystemBuilder.ge("createTime", thisYearFirstDate);
        systemYearNum = confClassifiedSystemDao.count(classifiedSystemBuilder.build());
        ScreenSystemCountVo screenSystemCountVo = new ScreenSystemCountVo();
        screenSystemCountVo.setDmSystemNowNum(systemNowNum);
        screenSystemCountVo.setDmSystemYearNum(systemYearNum);

        return screenSystemCountVo;
    }

    private ScreenSystemCountVo getScreenSystemCountVo2(List<String> unitIdList) {
        Date thisYearFirstDate = getThisYearFirstDate();

        Long systemNowNum;
        Long systemYearNum;

        PredicateBuilder<ConfClassifiedSystem> classifiedSystemBuilder = Specifications.and();
        classifiedSystemBuilder.in("fillingUnitId", unitIdList);
        systemNowNum = confClassifiedSystemDao.count(classifiedSystemBuilder.build());
        classifiedSystemBuilder.ge("createTime", thisYearFirstDate);
        systemYearNum = confClassifiedSystemDao.count(classifiedSystemBuilder.build());

        ScreenSystemCountVo screenSystemCountVo = new ScreenSystemCountVo();
        screenSystemCountVo.setDmSystemNowNum(systemNowNum);
        screenSystemCountVo.setDmSystemYearNum(systemYearNum);

        return screenSystemCountVo;
    }

    private ScreenChargeCountVo getScreenChargeCountVo(String unitId) {
        List<ConfClassifiedPersonLiable> confClassifiedPersonLiableList;
//        if (unitId.equals(code)) {
//            confClassifiedPersonLiableList = confClassifiedPersonLiableDao.findAll();
//        } else {
//            PredicateBuilder<ConfClassifiedPersonLiable> classifiedPersonLiableBuilder = Specifications.and();
//            classifiedPersonLiableBuilder.eq("fillingUnitId", unitId);
//            confClassifiedPersonLiableList = confClassifiedPersonLiableDao.findAll(classifiedPersonLiableBuilder.build());
//        }
        PredicateBuilder<ConfClassifiedPersonLiable> classifiedPersonLiableBuilder = Specifications.and();
        classifiedPersonLiableBuilder.eq("fillingUnitId", unitId);
        confClassifiedPersonLiableList = confClassifiedPersonLiableDao.findAll(classifiedPersonLiableBuilder.build());
        ScreenChargeCountVo screenChargeCountVo = new ScreenChargeCountVo();
        Long classificationZrrNum2 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 2)
                .count();
        screenChargeCountVo.setClassificationZrrNum2(classificationZrrNum2);
        Long classificationZrrNum3 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 3)
                .count();
        screenChargeCountVo.setClassificationZrrNum3(classificationZrrNum3);
        Long classificationZrrFdNum2 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 2
                        && confClassifiedPersonLiable.getType() == 1)
                .count();

        screenChargeCountVo.setClassificationZrrFdNum2(classificationZrrFdNum2);
        Long classificationZrrFdNum3 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 3
                        && confClassifiedPersonLiable.getType() == 1)
                .count();

        screenChargeCountVo.setClassificationZrrFdNum3(classificationZrrFdNum3);
        Long classificationZrrZdNum2 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 2
                        && confClassifiedPersonLiable.getType() == 2)
                .count();

        screenChargeCountVo.setClassificationZrrAZdNum2(classificationZrrZdNum2);
        Long classificationZrrZdNum3 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 3
                        && confClassifiedPersonLiable.getType() == 2)
                .count();
        screenChargeCountVo.setClassificationZrrAZdNum3(classificationZrrZdNum3);

        return screenChargeCountVo;
    }

    private ScreenChargeCountVo getScreenChargeCountVo2(List<String> unitIdList) {
        List<ConfClassifiedPersonLiable> confClassifiedPersonLiableList;

        PredicateBuilder<ConfClassifiedPersonLiable> classifiedPersonLiableBuilder = Specifications.and();
        classifiedPersonLiableBuilder.in("fillingUnitId", unitIdList);
        confClassifiedPersonLiableList = confClassifiedPersonLiableDao.findAll(classifiedPersonLiableBuilder.build());

        ScreenChargeCountVo screenChargeCountVo = new ScreenChargeCountVo();
        Long classificationZrrNum2 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 2)
                .count();
        screenChargeCountVo.setClassificationZrrNum2(classificationZrrNum2);
        Long classificationZrrNum3 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 3)
                .count();
        screenChargeCountVo.setClassificationZrrNum3(classificationZrrNum3);
        Long classificationZrrFdNum2 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 2
                        && confClassifiedPersonLiable.getType() == 1)
                .count();

        screenChargeCountVo.setClassificationZrrFdNum2(classificationZrrFdNum2);
        Long classificationZrrFdNum3 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 3
                        && confClassifiedPersonLiable.getType() == 1)
                .count();

        screenChargeCountVo.setClassificationZrrFdNum3(classificationZrrFdNum3);
        Long classificationZrrZdNum2 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 2
                        && confClassifiedPersonLiable.getType() == 2)
                .count();

        screenChargeCountVo.setClassificationZrrAZdNum2(classificationZrrZdNum2);
        Long classificationZrrZdNum3 = confClassifiedPersonLiableList.stream()
                .filter(confClassifiedPersonLiable -> confClassifiedPersonLiable.getClassifiedAuthId() == 3
                        && confClassifiedPersonLiable.getType() == 2)
                .count();
        screenChargeCountVo.setClassificationZrrAZdNum3(classificationZrrZdNum3);

        return screenChargeCountVo;
    }


    private ScreenAuthCountVo getScreenAuthCountVo(String unitId) {

        ScreenAuthCountVo screenAuthCountVo = new ScreenAuthCountVo();


//        boolean isHighUnit = unitId.equals(code);

        List<ConfClassifiedAuth> confClassifiedAuthList;
//        if (isHighUnit) {
//            confClassifiedAuthList = confClassifiedAuthDao.findAll();
//        } else {
//            PredicateBuilder<ConfClassifiedAuth> classifiedAuthBuilder = Specifications.and();
//            classifiedAuthBuilder.eq("fillingUnitId", unitId);
//            confClassifiedAuthList = confClassifiedAuthDao.findAll(classifiedAuthBuilder.build());
//        }
        PredicateBuilder<ConfClassifiedAuth> classifiedAuthBuilder = Specifications.and();
        classifiedAuthBuilder.eq("fillingUnitId", unitId);
        confClassifiedAuthList = confClassifiedAuthDao.findAll(classifiedAuthBuilder.build());
        Long classificationNowNum2 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 2)
                .count();

        Long classificationNowNum3 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 3)
                .count();

        Date startTime = getThisYearFirstDate();
        Long classificationYearNum2 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 2
                        && confClassifiedAuth.getCreateTime().after(startTime))
                .count();
        Long classificationYearNum3 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 3
                        && confClassifiedAuth.getCreateTime().after(startTime))
                .count();
        screenAuthCountVo.setClassificationNowNum2(classificationNowNum2);
        screenAuthCountVo.setClassificationNowNum3(classificationNowNum3);
        screenAuthCountVo.setClassificationYearNum2(classificationYearNum2);
        screenAuthCountVo.setClassificationYearNum3(classificationYearNum3);
        return screenAuthCountVo;
    }

    private ScreenAuthCountVo getScreenAuthCountVo2(List<String> unitIdList) {

        ScreenAuthCountVo screenAuthCountVo = new ScreenAuthCountVo();



        List<ConfClassifiedAuth> confClassifiedAuthList;


        PredicateBuilder<ConfClassifiedAuth> classifiedAuthBuilder = Specifications.and();
        classifiedAuthBuilder.in("fillingUnitId", unitIdList);
        confClassifiedAuthList = confClassifiedAuthDao.findAll(classifiedAuthBuilder.build());

        Long classificationNowNum2 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 2)
                .count();

        Long classificationNowNum3 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 3)
                .count();

        Date startTime = getThisYearFirstDate();
        Long classificationYearNum2 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 2
                        && confClassifiedAuth.getCreateTime().after(startTime))
                .count();
        Long classificationYearNum3 = confClassifiedAuthList.stream()
                .filter(confClassifiedAuth -> confClassifiedAuth.getAuthId() == 3
                        && confClassifiedAuth.getCreateTime().after(startTime))
                .count();
        screenAuthCountVo.setClassificationNowNum2(classificationNowNum2);
        screenAuthCountVo.setClassificationNowNum3(classificationNowNum3);
        screenAuthCountVo.setClassificationYearNum2(classificationYearNum2);
        screenAuthCountVo.setClassificationYearNum3(classificationYearNum3);
        return screenAuthCountVo;
    }

    private ScreenCityCountVo getScreenCityCountVo(String unitId) {
//        boolean isHighUnit = unitId.equals(code);
        //查询到gjmm

        PredicateBuilder<ConfClassified> confClassifiedBuilder = Specifications.and();
        confClassifiedBuilder.eq("secretType", 3);
//        if (!isHighUnit) {
//            confClassifiedBuilder.eq("operatorUnit", unitId);
//        }
        confClassifiedBuilder.eq("operatorUnit", unitId);
        List<ConfClassified> confClassifiedList = confClassifiedDao.findAll(confClassifiedBuilder.build());
        //查询gjmm详情
        List<String> confClassifiedIdList = confClassifiedList.stream().map(ConfClassified::getId).collect(Collectors.toList());
        List<ConfClassifiedDetails> confClassifiedDetailsList = confClassifiedDetailsDao.findAllByClassifiedIdIn(confClassifiedIdList);
        Map<String, ConfClassifiedDetails> confClassifiedDetailsMap = confClassifiedDetailsList.stream()
                .collect(Collectors.toMap(ConfClassifiedDetails::getClassifiedId, confClassifiedDetails -> confClassifiedDetails));
        List<ConfClassifiedAndDetailsVo> confClassifiedAndDetailsVoList = confClassifiedList.stream().map(confClassified -> {
            ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo = new ConfClassifiedAndDetailsVo();
            ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsMap.get(confClassified.getId());
            BeanUtils.copyProperties(confClassified, confClassifiedAndDetailsVo);
            String classifiedContent = confClassifiedDetails.getClassifiedContent();
            ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(classifiedContent, ConfClassifiedDetailsVo.class);
            confClassifiedAndDetailsVo.setClassifiedBasisType(confClassifiedDetailsVo.getClassifiedBasisType());
            return confClassifiedAndDetailsVo;
        }).collect(Collectors.toList());

        ScreenCityCountVo screenCityCountVo = new ScreenCityCountVo();
        Long classificationNum1 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 1)
                .count();
        screenCityCountVo.setClassificationNum1(classificationNum1);

        Long classificationNum2 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 2)
                .count();
        screenCityCountVo.setClassificationNum2(classificationNum2);

        Long classificationNum3 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 3)
                .count();
        screenCityCountVo.setClassificationNum3(classificationNum3);

        Long classificationNum4 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 4)
                .count();
        screenCityCountVo.setClassificationNum4(classificationNum4);

        Long classificationYsNum1 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 1
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum1(classificationYsNum1);

        Long classificationYsNum2 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 2
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum2(classificationYsNum2);

        Long classificationYsNum3 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 3
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum3(classificationYsNum3);

        Long classificationYsNum4 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 4
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum4(classificationYsNum4);

        Long classificationPsNum1 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 1
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum1(classificationPsNum1);

        Long classificationPsNum2 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 2
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum2(classificationPsNum2);

        Long classificationPsNum3 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 3
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum3(classificationPsNum3);

        Long classificationPsNum4 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 4
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum4(classificationPsNum4);

        Date thisYearFirstDate = getThisYearFirstDate();
        long addNum = confClassifiedList.stream()
                .filter(confClassified -> confClassified.getCreateTime().after(thisYearFirstDate))
                .count();
        screenCityCountVo.setAddNum(addNum);

        PredicateBuilder<ConfOperationRecord> operationRecordBuilder = Specifications.and();
        operationRecordBuilder.ge("operationTime", thisYearFirstDate);
        operationRecordBuilder.eq("operationContent", "变更审核通过时间");
        Long changeNum = confOperationRecordDao.count(operationRecordBuilder.build());
        screenCityCountVo.setChangeNum(changeNum);

        PredicateBuilder<ConfClassifiedDecrypt> decryptPredicateBuilder = Specifications.and();
        decryptPredicateBuilder.eq("decryptAuditStatus", 1);
        decryptPredicateBuilder.eq("decryptExecutionStatus", 1);
        decryptPredicateBuilder.ge("createTime", thisYearFirstDate);
        long decryptionNum = confClassifiedDecryptDao.count(decryptPredicateBuilder.build());
        screenCityCountVo.setDecryptionNum(decryptionNum);
        return screenCityCountVo;
    }

    private ScreenCityCountVo getScreenCityCountVo2(List<String> unitIdList) {

        //查询到gjmm
        PredicateBuilder<ConfClassified> confClassifiedBuilder = Specifications.and();
        confClassifiedBuilder.eq("secretType", 3);
        confClassifiedBuilder.in("operatorUnit", unitIdList);

        List<ConfClassified> confClassifiedList = confClassifiedDao.findAll(confClassifiedBuilder.build());
        //查询gjmm详情
        List<String> confClassifiedIdList = confClassifiedList.stream().map(ConfClassified::getId).collect(Collectors.toList());
        List<ConfClassifiedDetails> confClassifiedDetailsList = confClassifiedDetailsDao.findAllByClassifiedIdIn(confClassifiedIdList);
        Map<String, ConfClassifiedDetails> confClassifiedDetailsMap = confClassifiedDetailsList.stream()
                .collect(Collectors.toMap(ConfClassifiedDetails::getClassifiedId, confClassifiedDetails -> confClassifiedDetails));
        List<ConfClassifiedAndDetailsVo> confClassifiedAndDetailsVoList = confClassifiedList.stream().map(confClassified -> {
            ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo = new ConfClassifiedAndDetailsVo();
            ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsMap.get(confClassified.getId());
            BeanUtils.copyProperties(confClassified, confClassifiedAndDetailsVo);
            String classifiedContent = confClassifiedDetails.getClassifiedContent();
            ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(classifiedContent, ConfClassifiedDetailsVo.class);
            confClassifiedAndDetailsVo.setClassifiedBasisType(confClassifiedDetailsVo.getClassifiedBasisType());
            return confClassifiedAndDetailsVo;
        }).collect(Collectors.toList());

        ScreenCityCountVo screenCityCountVo = new ScreenCityCountVo();
        Long classificationNum1 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 1)
                .count();
        screenCityCountVo.setClassificationNum1(classificationNum1);

        Long classificationNum2 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 2)
                .count();
        screenCityCountVo.setClassificationNum2(classificationNum2);

        Long classificationNum3 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 3)
                .count();
        screenCityCountVo.setClassificationNum3(classificationNum3);

        Long classificationNum4 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 4)
                .count();
        screenCityCountVo.setClassificationNum4(classificationNum4);

        Long classificationYsNum1 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 1
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum1(classificationYsNum1);

        Long classificationYsNum2 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 2
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum2(classificationYsNum2);

        Long classificationYsNum3 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 3
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum3(classificationYsNum3);

        Long classificationYsNum4 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 4
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 1)
                .count();
        screenCityCountVo.setClassificationYsNum4(classificationYsNum4);

        Long classificationPsNum1 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 1
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum1(classificationPsNum1);

        Long classificationPsNum2 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 2
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum2(classificationPsNum2);

        Long classificationPsNum3 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 3
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum3(classificationPsNum3);

        Long classificationPsNum4 = confClassifiedAndDetailsVoList.stream()
                .filter(confClassifiedAndDetailsVo -> Integer.parseInt(confClassifiedAndDetailsVo.getClassification()) == 4
                        && confClassifiedAndDetailsVo.getClassifiedBasisType() == 2)
                .count();
        screenCityCountVo.setClassificationPsNum4(classificationPsNum4);

        Date thisYearFirstDate = getThisYearFirstDate();
        long addNum = confClassifiedList.stream()
                .filter(confClassified -> confClassified.getCreateTime().after(thisYearFirstDate))
                .count();
        screenCityCountVo.setAddNum(addNum);

        PredicateBuilder<ConfOperationRecord> operationRecordBuilder = Specifications.and();
        operationRecordBuilder.ge("operationTime", thisYearFirstDate);
        operationRecordBuilder.eq("operationContent", "变更审核通过时间");
        Long changeNum = confOperationRecordDao.count(operationRecordBuilder.build());
        screenCityCountVo.setChangeNum(changeNum);

        PredicateBuilder<ConfClassifiedDecrypt> decryptPredicateBuilder = Specifications.and();
        decryptPredicateBuilder.eq("decryptAuditStatus", 1);
        decryptPredicateBuilder.eq("decryptExecutionStatus", 1);
        decryptPredicateBuilder.ge("createTime", thisYearFirstDate);
        long decryptionNum = confClassifiedDecryptDao.count(decryptPredicateBuilder.build());
        screenCityCountVo.setDecryptionNum(decryptionNum);
        return screenCityCountVo;
    }

    private Integer getIsClient(String unitId) {
        DataUnit dataUnitByUnitId = dataUnitDao.findDataUnitByUnitId(unitId);
        if (dataUnitByUnitId.getIsClient()) {
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(dataUnitByUnitId.getUnitClientId())) {
                if (MyThreadLocal.get().getUnitIdTwo().equals(MyThreadLocal.get().getUnitId())) { // 如果相同,就没有切换单位
                    if (dataUnitByUnitId.getUnitClientId().equals(MyThreadLocal.get().getUnitIdTwo())) {
                        return 1;
                    } else {
                        return 0;
                    }
                } else { // 不同表示已经切换单位了
                    if (dataUnitByUnitId.getUnitClientId().equals(MyThreadLocal.get().getUnitId())) {
                        return 1;
                    } else {
                        return 0;
                    }
                }
            } else {
                return 0;
            }
        } else {
            if (dataUnitByUnitId.getUnitId().equals(MyThreadLocal.get().getUnitIdTwo())) { // 如果是自己切换自己管理页面,就不跳转
                return 2;
            } else {
                return 0;
            }

        }
    }

    /**
     * 获取当年的第一天
     */
    private Date getThisYearFirstDate() {
        Calendar currCal = Calendar.getInstance();
        int year = currCal.get(Calendar.YEAR);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(Calendar.YEAR, year);
        return calendar.getTime();
    }
}
