package com.tykj.classified.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.*;
import com.tykj.classified.entity.db1.*;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedDecryptService;
import com.tykj.classified.utils.date.DateUtils;
import com.tykj.classified.utils.date.TimeUtils;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.log.LogUtils;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ConfClassifiedDecryptServiceImpl implements ConfClassifiedDecryptService {

    private final ConfClassifiedDao confClassifiedDao;

    private final ConfClassifiedDetailsDao confClassifiedDetailsDao;

    private final ConfClassifiedDecryptDao confClassifiedDecryptDao;

    private final ConfClassifiedPublicDao confClassifiedPublicDao;

    private final ConfOperationRecordDao confOperationRecordDao;

    private final ConfManageDetailDao confManageDetailDao;

    private final IdWorker idWorker;

    public ConfClassifiedDecryptServiceImpl(ConfClassifiedDao confClassifiedDao, ConfClassifiedDetailsDao confClassifiedDetailsDao, ConfClassifiedDecryptDao confClassifiedDecryptDao, ConfClassifiedPublicDao confClassifiedPublicDao, ConfOperationRecordDao confOperationRecordDao, ConfManageDetailDao confManageDetailDao, IdWorker idWorker) {
        this.confClassifiedDao = confClassifiedDao;
        this.confClassifiedDetailsDao = confClassifiedDetailsDao;
        this.confClassifiedDecryptDao = confClassifiedDecryptDao;
        this.confClassifiedPublicDao = confClassifiedPublicDao;
        this.confOperationRecordDao = confOperationRecordDao;
        this.confManageDetailDao = confManageDetailDao;
        this.idWorker = idWorker;
    }

    @Override
    public ConfClassifiedAndDecryptVo findClassifiedDecryptByClassifiedId(String classifiedId) {
        ConfClassified confClassified = confClassifiedDao.findConfClassifiedById(classifiedId);
        if (confClassified != null) {
            // 基本信息
            ConfClassifiedAndDecryptVo confClassifiedAndDecryptVo = new ConfClassifiedAndDecryptVo();
            ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsDao.findByClassifiedId(classifiedId);
            ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo = new ConfClassifiedAndDetailsVo();
            ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(confClassifiedDetails.getClassifiedContent(), ConfClassifiedDetailsVo.class);
            BeanUtils.copyProperties(confClassified, confClassifiedAndDetailsVo);
            BeanUtils.copyProperties(confClassifiedDetailsVo, confClassifiedAndDetailsVo);
            confClassifiedAndDetailsVo.setClassifiedId(confClassified.getId());
            confClassifiedAndDetailsVo.setClassifiedDetailsId(confClassifiedDetails.getId());
            confClassifiedAndDecryptVo.setConfClassifiedAndDetailsVo(confClassifiedAndDetailsVo);

            // 解密信息
            List<ConfClassifiedDecrypt> confClassifiedDecrypt = confClassifiedDecryptDao.findAllByClassifiedIdOrderByCreateTimeDesc(classifiedId);
            List<ConfClassifiedDecryptVo> confClassifiedDecryptVoList = new ArrayList<>();
            for (ConfClassifiedDecrypt classifiedDecrypt : confClassifiedDecrypt) {
                ConfClassifiedDecryptVo confClassifiedDecryptVo = new ConfClassifiedDecryptVo();
                BeanUtils.copyProperties(classifiedDecrypt,confClassifiedDecryptVo);
                confClassifiedDecryptVoList.add(confClassifiedDecryptVo);
            }
            confClassifiedAndDecryptVo.setConfClassifiedDecryptVoList(confClassifiedDecryptVoList);
            return confClassifiedAndDecryptVo;
        } else {
            throw new BizException("定密信息不存在");
        }
    }

    @Override
    public void decryptNewOperations(String classifiedId) {
        // 根据定MID查询待审核或者未执行的解M信息
        PredicateBuilder<ConfClassifiedDecrypt> pb = Specifications.and();
        pb.eq("classifiedId", classifiedId);

        PredicateBuilder<ConfClassifiedDecrypt> pb2 = Specifications.or();
        pb2.eq("decryptAuditStatus", 0);
        pb2.eq("decryptExecutionStatus", 0);
        // 如果有待审核或者未执行的解M信息，不能新增新的解M信息并抛出异常
        List<ConfClassifiedDecrypt> confClassifiedDecryptList = confClassifiedDecryptDao.findAll(pb.build().and(pb2.build()));
        // 如果是已公开的事项也不能新增新的解M信息并抛出异常
        ConfClassified confClassifiedById = confClassifiedDao.findConfClassifiedById(classifiedId);
        if (confClassifiedDecryptList.size() > 0) {
            throw new BizException("已有待审核或还未执行的解密操作,不能再新增待审核的解密操作");
        }
        if (confClassifiedById != null && confClassifiedById.getChangeStatus() == 5) {
            throw new BizException("已公开的事项,不能再新增待审核的解密操作");
        }
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void addClassifiedDecrypt(ConfClassifiedDecryptVo confClassifiedDecryptVo) {
        if (confClassifiedDecryptVo != null) {
            Date date = new Date();
            ConfManageDetail confManageDetailByManageId = new ConfManageDetail();
            if (confClassifiedDecryptVo.getAfterClassification() != null) {
                confManageDetailByManageId = confManageDetailDao.findConfManageDetailById(confClassifiedDecryptVo.getAfterClassification());
            }
            ConfClassified confClassifiedById = confClassifiedDao.findConfClassifiedById(confClassifiedDecryptVo.getClassifiedId());
            confClassifiedById.setUpdateTime(date);
            // 保存解密信息状态改为解密中
            confClassifiedById.setChangeStatus(7);
            // 修改
            if (StringUtils.isNotEmpty(confClassifiedDecryptVo.getId())) {
                Optional<ConfClassifiedDecrypt> confClassifiedDecryptOptional = confClassifiedDecryptDao.findConfClassifiedDecryptById(confClassifiedDecryptVo.getId());
                if (!confClassifiedDecryptOptional.isPresent()){
                    throw new BizException("找不到数据，无法修改");
                }
                ConfClassifiedDecrypt confClassifiedDecrypt = confClassifiedDecryptOptional.get();
                BeanUtils.copyProperties(confClassifiedDecryptVo, confClassifiedDecrypt);
                if (confClassifiedDecryptVo.getDecryptType() == 1) { // 维持原定m决定的解密时间是当前时间
                    confClassifiedDecrypt.setDecryptTime(date);
                }
                confClassifiedDecrypt.setOperatorId(MyThreadLocal.get().getId());
                confClassifiedDecrypt.setOperatorUnit(MyThreadLocal.get().getUnitIdTwo());
                confClassifiedDecrypt.setUpdateTime(date);
                if (confClassifiedDecryptVo.getDecryptType() == 2 && confManageDetailByManageId != null && confManageDetailByManageId.getSortNum() != null) {
                    confClassifiedDecrypt.setAfterClassificationSortNum(confManageDetailByManageId.getSortNum());
                }
                confClassifiedDecryptDao.save(confClassifiedDecrypt);
            } else { // 新增
                ConfClassifiedDecrypt confClassifiedDecrypt = new ConfClassifiedDecrypt();
                BeanUtils.copyProperties(confClassifiedDecryptVo, confClassifiedDecrypt);
                if (confClassifiedDecryptVo.getDecryptType() == 1) { // 维持原定m决定的解密时间是当前时间
                    confClassifiedDecrypt.setDecryptTime(date);
                }
                confClassifiedDecrypt.setId(idWorker.nextId() + "");
                confClassifiedDecrypt.setDecryptAuditStatus(0);
                confClassifiedDecrypt.setDecryptExecutionStatus(0);
                confClassifiedDecrypt.setOperatorId(MyThreadLocal.get().getId());
                confClassifiedDecrypt.setOperatorUnit(MyThreadLocal.get().getUnitIdTwo());
                confClassifiedDecrypt.setCreateTime(date);
                confClassifiedDecrypt.setUpdateTime(date);
                if (confClassifiedDecryptVo.getDecryptType() == 2 && confManageDetailByManageId != null && confManageDetailByManageId.getSortNum() != null) {
                    confClassifiedDecrypt.setAfterClassificationSortNum(confManageDetailByManageId.getSortNum());
                }
                confClassifiedDecryptDao.save(confClassifiedDecrypt);
                // 操作记录
                if (confClassifiedDecryptVo.getDecryptType() == 1) {
                    LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "维持原定密决定", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                } else if (confClassifiedDecryptVo.getDecryptType() == 2) {
                    LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "变更", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                } else {
                    if (confClassifiedDecryptVo.getDecryptMethod() == 1) {
                        LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "解密并公开", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                    } else if (confClassifiedDecryptVo.getDecryptMethod() == 2) {
                        LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "解密后内部使用", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                    } else {
                        LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "部分解密", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                    }
                }
            }
            confClassifiedDao.save(confClassifiedById);
        } else {
            throw new BizException("解密信息不存在");
        }
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void decryptAuditPass(ConfClassifiedDecryptVo confClassifiedDecryptVo) {
        if (confClassifiedDecryptVo != null) {
            Date date = new Date();
            ConfManageDetail confManageDetailByManageId;
            if (StringUtils.isNotEmpty(confClassifiedDecryptVo.getAfterClassification())) {
                confManageDetailByManageId = confManageDetailDao.findConfManageDetailById(confClassifiedDecryptVo.getAfterClassification());
            } else {
                confManageDetailByManageId = confManageDetailDao.findConfManageDetailById(confClassifiedDecryptVo.getBeforeClassification());
            }

            // 定密信息
            ConfClassified confClassified = confClassifiedDao.findConfClassifiedById(confClassifiedDecryptVo.getClassifiedId());
            ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsDao.findByClassifiedId(confClassifiedDecryptVo.getClassifiedId());

            ConfClassifiedDecrypt confClassifiedDecrypt = new ConfClassifiedDecrypt();
            // 解密记录
            BeanUtils.copyProperties(confClassifiedDecryptVo, confClassifiedDecrypt);
            if (confClassifiedDecryptVo.getDecryptType() == 1) { // 维持原定m决定的解密时间是当前时间
                confClassifiedDecrypt.setDecryptTime(date);
            }
            if (StringUtils.isEmpty(confClassifiedDecryptVo.getId())) {
                confClassifiedDecrypt.setId(idWorker.nextId() + "");
            }
            confClassifiedDecrypt.setDecryptAuditStatus(1);
            if (confClassifiedDecryptVo.getDecryptType() == 2) {
                confClassifiedDecrypt.setAfterClassificationSortNum(confManageDetailByManageId.getSortNum());
            }
            // 操作记录
            if (confClassifiedDecryptVo.getDecryptType() == 1) {
                confClassifiedDecrypt.setDecryptExecutionStatus(1);
                LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "维持原定密决定审核通过时间", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
            } else if (confClassifiedDecryptVo.getDecryptType() == 2) {
                LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "变更审核通过时间", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
            } else {
                if (confClassifiedDecryptVo.getDecryptMethod() == 1) {
                    LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "解密并公开审核通过时间", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                } else if (confClassifiedDecryptVo.getDecryptMethod() == 2) {
                    LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "解密后内部使用审核通过时间", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                } else {
                    LogUtils.addOperationRecord(confClassifiedDecryptVo.getClassifiedId(), "部分解密审核通过时间", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                }
            }

            // 定M更新时间更新 先判断是不是1->维持原定M决定，如果是只改变解M执行状态。如果不是，再判断建议解M时间是否小于当前日期
            confClassified.setUpdateTime(date);
            // 审核通过状态先改为解密中
            confClassified.setChangeStatus(7);
            if (confClassifiedDecryptVo.getDecryptType() != 1) {
                if (confClassifiedDecryptVo.getDecryptTime().getTime() <= date.getTime()) {
                    confClassifiedDecrypt.setDecryptExecutionStatus(1);
                    List<ConfClassified> newConfClassifiedList = new ArrayList<>();
                    List<ConfClassifiedDetails> newConfClassifiedDetailsList = new ArrayList<>();
                    if (confClassifiedDecryptVo.getDecryptType() == 2) { // 变更
                        decryptOfChange(confClassifiedDetails,confClassified,confClassifiedDecrypt,newConfClassifiedList,newConfClassifiedDetailsList);
                    } else if (confClassifiedDecryptVo.getDecryptType() == 3) { // 解密
                        decryptOfDecrypt(confClassifiedDecrypt,confClassified,newConfClassifiedList);
                    }
                    confClassifiedDao.saveAll(newConfClassifiedList);
                    confClassifiedDetailsDao.saveAll(newConfClassifiedDetailsList);
                }
            } else {
                confClassifiedDecrypt.setDecryptExecutionStatus(1);
                confClassified.setChangeStatus(2);
                confClassifiedDao.save(confClassified);
            }
            confClassifiedDecrypt.setCreateTime(date);
            confClassifiedDecrypt.setUpdateTime(date);
            confClassifiedDecryptDao.save(confClassifiedDecrypt);
        } else {
            throw new BizException("解密信息不存在");
        }
    }

    @Override
    public void decryptBatchOperations(ConfClassifiedDecryptBatchVo confClassifiedDecryptBatchVo) {
        // 批量解M中如果有状态是待审核、工作MM或者已公开的事项，就不能新增新的解M信息并抛出异常
        for (Integer i : confClassifiedDecryptBatchVo.getClassifiedChangeStatusList()) {
            if (i == 5 || i == 1 || i == 4) {
                throw new BizException("工作秘密或者已公开的事项无法解密");
            }
        }

        PredicateBuilder<ConfClassifiedDecrypt> pb = Specifications.or();
        pb.eq("decryptAuditStatus", 0);
        pb.eq("decryptExecutionStatus", 0);
        List<ConfClassifiedDecrypt> confClassifiedDecryptList = confClassifiedDecryptDao.findAll(pb.build());
        List<ConfClassifiedDecrypt> collect = confClassifiedDecryptList.stream()
                .filter(confClassifiedDecrypt -> confClassifiedDecryptBatchVo.getClassifiedIdList().contains(confClassifiedDecrypt.getClassifiedId()))
                .collect(Collectors.toList());
        if (collect.size() > 0) {
            throw new BizException("选中的定密信息中已有待审核的解密操作,不能批量解密操作");
        }
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void batchDecrypt(ConfClassifiedIdListAndDecryptVo confClassifiedIdListAndDecryptVo) {
        Date date = new Date();
        List<ConfClassifiedDecrypt> confClassifiedDecryptList = new ArrayList<>();
        List<ConfOperationRecord> confOperationRecordList = new ArrayList<>();
        List<ConfClassified> confClassifiedList = confClassifiedDao.findAllByChangeStatus(2);
        List<ConfClassified> newConfClassifiedList = new ArrayList<>();
        for (String classifiedId : confClassifiedIdListAndDecryptVo.getClassifiedIdList()) {
            List<ConfClassified> confClassifieds = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getId().equals(classifiedId))
                    .collect(Collectors.toList());
            if (confClassifieds.size() > 0) {
                ConfClassified confClassified = confClassifieds.get(0);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

                // 解M记录
                ConfClassifiedDecrypt confClassifiedDecrypt = new ConfClassifiedDecrypt();
                BeanUtils.copyProperties(confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo(), confClassifiedDecrypt);
                confClassifiedDecrypt.setId(idWorker.nextId() + "");
                confClassifiedDecrypt.setClassifiedId(classifiedId);
                confClassifiedDecrypt.setDecryptAuditStatus(1);
                confClassifiedDecrypt.setClassifiedPerson(confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getClassifiedPerson());
                confClassifiedDecrypt.setClassifiedPersonName(confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getClassifiedPersonName());
                confClassifiedDecrypt.setUndertaker(confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getUndertaker());
                confClassifiedDecrypt.setUndertakerName(confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getUndertakerName());
                confClassifiedDecrypt.setDecryptExecutionStatus(0);
                confClassifiedDecrypt.setOperatorId(MyThreadLocal.get().getId());
                confClassifiedDecrypt.setOperatorUnit(MyThreadLocal.get().getUnitIdTwo());
                confClassifiedDecrypt.setCreateTime(date);
                confClassifiedDecrypt.setUpdateTime(date);
                confClassifiedDecryptList.add(confClassifiedDecrypt);

                // 定M更新时间
                confClassified.setUpdateTime(date);
                // 解密把状态先改为解密中
                confClassified.setChangeStatus(7);
                // 如果是立刻解M就执行
                if (confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getDecryptType() == 3) {
                    if (confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getDecryptTime().getTime() <= date.getTime()) { // 解密就修改定密信息
                        confClassifiedDecrypt.setDecryptExecutionStatus(1);
                        decryptOfDecrypt(confClassifiedDecrypt,confClassified,newConfClassifiedList);
                    } else { // 否则只修改定M更新时间
                        newConfClassifiedList.add(confClassified);
                    }
                } else { // 维持原定密决定只修改定M更新时间
                    confClassifiedDecrypt.setDecryptTime(date);
                    confClassifiedDecrypt.setDecryptExecutionStatus(1);
                    newConfClassifiedList.add(confClassified);
                }

                // 操作记录
                ConfOperationRecord confOperationRecord = new ConfOperationRecord();
                confOperationRecord.setId(idWorker.nextId() + "");
                confOperationRecord.setOperatorId(MyThreadLocal.get().getId());
                confOperationRecord.setOperatorName(MyThreadLocal.get().getUserName());
                confOperationRecord.setOperatorUnit(MyThreadLocal.get().getUnitNameTwo());
                confOperationRecord.setClassifiedId(classifiedId);
                if (confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getDecryptType() == 1) {
                    confOperationRecord.setOperationContent("维持原定密决定审核通过时间");
                } else {
                    if (confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getDecryptMethod() == 1) {
                        confOperationRecord.setOperationContent("解密并公开审核通过时间");
                    } else if (confClassifiedIdListAndDecryptVo.getConfClassifiedDecryptVo().getDecryptMethod() == 2) {
                        confOperationRecord.setOperationContent("解密后内部使用审核通过时间");
                    } else {
                        confOperationRecord.setOperationContent("部分解密审核通过时间");
                    }
                }
                confOperationRecord.setOperationTime(date);
                confOperationRecordList.add(confOperationRecord);
            }
        }
        confClassifiedDao.saveAll(newConfClassifiedList);
        confClassifiedDecryptDao.saveAll(confClassifiedDecryptList);
        confOperationRecordDao.saveAll(confOperationRecordList);
    }

    @Override
    @Scheduled(cron = "0 0 4 * * ?")
    @Transactional(rollbackOn = Exception.class)
    public void decryptActuator() {
        Date date = new Date();
        List<ConfClassifiedDecrypt> confClassifiedDecryptList = confClassifiedDecryptDao.findAllByDecryptAuditStatusAndDecryptExecutionStatusAndDecryptTime(1, 0, date);
        List<ConfClassified> confClassifiedList = confClassifiedDao.findAll();
        List<ConfClassifiedDetails> confClassifiedDetailsList = confClassifiedDetailsDao.findAll();
        List<ConfClassifiedDecrypt> newConfClassifiedDecryptList = new ArrayList<>();
        List<ConfClassified> newConfClassifiedList = new ArrayList<>();
        List<ConfClassifiedDetails> newConfClassifiedDetailsList = new ArrayList<>();
        if (confClassifiedDecryptList != null && confClassifiedDecryptList.size() > 0) {
            for (ConfClassifiedDecrypt confClassifiedDecrypt : confClassifiedDecryptList) {
                confClassifiedDecrypt.setDecryptExecutionStatus(1);
                List<ConfClassified> findConfClassified = confClassifiedList.stream()
                        .filter(confClassified1 -> confClassified1.getId().equals(confClassifiedDecrypt.getClassifiedId()))
                        .collect(Collectors.toList());
                List<ConfClassifiedDetails> findConfClassifiedDetails = confClassifiedDetailsList.stream()
                        .filter(confClassifiedDetails1 -> confClassifiedDetails1.getClassifiedId().equals(confClassifiedDecrypt.getClassifiedId()))
                        .collect(Collectors.toList());
                if (findConfClassified.size() > 0 && findConfClassifiedDetails.size() > 0) {
                    ConfClassified confClassified = findConfClassified.get(0);
                    ConfClassifiedDetails confClassifiedDetails = findConfClassifiedDetails.get(0);
                    if (confClassifiedDecrypt.getDecryptType() == 2) { // 变更
                        // 变更调用方法
                        decryptOfChange(confClassifiedDetails,confClassified,confClassifiedDecrypt,newConfClassifiedList,newConfClassifiedDetailsList);
                    } else if (confClassifiedDecrypt.getDecryptType() == 3) { // 解密
                        // 解密调用方法
                        decryptOfDecrypt(confClassifiedDecrypt,confClassified,newConfClassifiedList);

                    }
                    newConfClassifiedDecryptList.add(confClassifiedDecrypt);
                }
            }
            for (ConfClassified confClassified : newConfClassifiedList) {
                confClassified.setUpdateTime(date);
            }
            confClassifiedDao.saveAll(newConfClassifiedList);
            confClassifiedDetailsDao.saveAll(newConfClassifiedDetailsList);
            confClassifiedDecryptDao.saveAll(newConfClassifiedDecryptList);
        }
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void addClassifiedPublic(ConfClassifiedPublicVo confClassifiedPublicVo) {
        if (confClassifiedPublicVo != null) {
            Date date = new Date();
            ConfClassified confClassifiedById = confClassifiedDao.findConfClassifiedById(confClassifiedPublicVo.getClassifiedId());
            confClassifiedById.setUpdateTime(date);
            // 公开保存把状态改为公开中
            confClassifiedById.setChangeStatus(8);
            if (StringUtils.isNotEmpty(confClassifiedPublicVo.getId())) { // 修改
                ConfClassifiedPublic confClassifiedPublic = confClassifiedPublicDao.findConfClassifiedPublicByClassifiedIdAndPublicAuditStatus(confClassifiedPublicVo.getClassifiedId(),0);
                if (confClassifiedPublic != null) {
                    BeanUtils.copyProperties(confClassifiedPublicVo,confClassifiedPublic);
                } else {
                    throw new BizException("公开信息不存在");
                }
                confClassifiedPublicDao.save(confClassifiedPublic);
            } else { // 新增
                ConfClassifiedPublic confClassifiedPublic = new ConfClassifiedPublic();
                // 解密记录
                BeanUtils.copyProperties(confClassifiedPublicVo, confClassifiedPublic);
                confClassifiedPublic.setId(idWorker.nextId() + "");
                confClassifiedPublic.setPublicAuditStatus(0);
                confClassifiedPublic.setPublicExecutionStatus(0);
                confClassifiedPublic.setCreateTime(date);
                // 操作记录
                LogUtils.addOperationRecord(confClassifiedPublicVo.getClassifiedId(), "解密并公开", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());
                confClassifiedPublicDao.save(confClassifiedPublic);
            }
            confClassifiedDao.save(confClassifiedById);
        } else {
            throw new BizException("公开信息不存在");
        }
    }

    @Override
    public ConfClassifiedPublicVo findClassifiedPublicByClassifiedId(String classifiedId) {
        ConfClassifiedPublicVo confClassifiedPublicVo = new ConfClassifiedPublicVo();
        ConfClassifiedPublic confClassifiedPublic = confClassifiedPublicDao.findConfClassifiedPublicByClassifiedIdAndPublicAuditStatus(classifiedId,0);
        if (confClassifiedPublic != null) { // 有公开信息
            BeanUtils.copyProperties(confClassifiedPublic,confClassifiedPublicVo);
        }
        return confClassifiedPublicVo;
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void publicAuditPass(ConfClassifiedPublicVo confClassifiedPublicVo) {
        if (confClassifiedPublicVo != null) {
            Date date = new Date();
            // 定M信息
            ConfClassified confClassified = confClassifiedDao.findConfClassifiedById(confClassifiedPublicVo.getClassifiedId());

            ConfClassifiedPublic confClassifiedPublic = new ConfClassifiedPublic();
            // 公开记录
            BeanUtils.copyProperties(confClassifiedPublicVo, confClassifiedPublic);
            if (StringUtils.isEmpty(confClassifiedPublicVo.getId())) {
                confClassifiedPublic.setId(idWorker.nextId() + "");
            }
            confClassifiedPublic.setClassifiedId(confClassifiedPublicVo.getClassifiedId());
            confClassifiedPublic.setPublicAuditStatus(1);
            confClassifiedPublic.setPublicExecutionStatus(0);

            // 定M更新时间更新
            confClassified.setUpdateTime(date);
            // 审核先把状态改为公开中
            confClassified.setChangeStatus(8);
            if (confClassifiedPublicVo.getPublicTime().getTime() <= date.getTime()) {
                confClassified.setChangeStatus(5);
//                confClassified.setSecretType(1);
                confClassifiedPublic.setPublicExecutionStatus(1);
            }

            // 操作记录
            LogUtils.addOperationRecord(confClassifiedPublicVo.getClassifiedId(), "解密并公开审核通过时间", date, MyThreadLocal.get().getId(), MyThreadLocal.get().getUserName(), MyThreadLocal.get().getUnitNameTwo());

            confClassifiedPublicDao.save(confClassifiedPublic);
            confClassifiedDao.save(confClassified);
        } else {
            throw new BizException("公开信息不存在");
        }
    }

    @Override
    @Scheduled(cron = "0 0 4 * * ?")
    @Transactional(rollbackOn = Exception.class)
    public void publicActuator() {
        Date date = new Date();
        List<ConfClassified> confClassifiedList = confClassifiedDao.findAllBySecretType(2);
        List<ConfClassifiedPublic> confClassifiedPublicList = confClassifiedPublicDao.findAllByPublicAuditStatusAndPublicExecutionStatus(1, 0);
        List<ConfClassifiedPublic> newConfClassifiedPublicList = new ArrayList<>();
        List<ConfClassified> newConfClassifiedList = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ConfClassifiedPublic confClassifiedPublic : confClassifiedPublicList) {
            if (sdf.format(confClassifiedPublic.getPublicTime()).equals(sdf.format(date))) {
                List<ConfClassified> findConfClassified = confClassifiedList.stream()
                        .filter(confClassified -> confClassified.getId().equals(confClassifiedPublic.getClassifiedId()))
                        .collect(Collectors.toList());
                if (findConfClassified.size() > 0) {
                    ConfClassified confClassified = findConfClassified.get(0);
                    confClassified.setUpdateTime(date);
                    confClassified.setChangeStatus(5);
                    confClassifiedPublic.setPublicExecutionStatus(1);
                    newConfClassifiedList.add(confClassified);
                    newConfClassifiedPublicList.add(confClassifiedPublic);
                }
            }
        }
        confClassifiedDao.saveAll(newConfClassifiedList);
        confClassifiedPublicDao.saveAll(newConfClassifiedPublicList);
    }


    //=================================================== 以下为私有方法 ========================================================

    private void decryptOfChange(ConfClassifiedDetails confClassifiedDetails,ConfClassified confClassified,ConfClassifiedDecrypt confClassifiedDecrypt,List<ConfClassified> newConfClassifiedList,List<ConfClassifiedDetails> newConfClassifiedDetailsList) {
        ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(confClassifiedDetails.getClassifiedContent(), ConfClassifiedDetailsVo.class);
        if (StringUtils.isNotEmpty(confClassifiedDecrypt.getAfterClassification())) {
            confClassified.setClassification(confClassifiedDecrypt.getAfterClassification());
            confClassified.setClassificationSortNum(confClassifiedDecrypt.getAfterClassificationSortNum());
        }
        if (confClassifiedDecrypt.getAfterSecrecyTermType() != null) {
            confClassified.setSecrecyTermType(confClassifiedDecrypt.getAfterSecrecyTermType());
            confClassified.setSecrecyTermContent(confClassifiedDecrypt.getAfterSecrecyTermContent());
            // 计算定密到期时间
            if (confClassifiedDecrypt.getAfterSecrecyTermType() != null && StringUtils.isNotEmpty(confClassifiedDecrypt.getAfterSecrecyTermContent())) {
                if (confClassifiedDecrypt.getAfterSecrecyTermType() != 3) {
                    if (confClassified.getClassifiedExpire() != null) {
                        Date date1 = DateUtils.addYearOrMonth(confClassified.getClassifiedExpire(), confClassifiedDecrypt.getAfterSecrecyTermType(), Integer.parseInt(confClassifiedDecrypt.getAfterSecrecyTermContent()));
                        confClassified.setClassifiedExpire(date1);
                    }
                } else {
                    boolean b = TimeUtils.validDateEffecitive(confClassifiedDecrypt.getAfterSecrecyTermContent());
                    if (b) {
                        Date date1 = TimeUtils.stringToDate(confClassifiedDecrypt.getAfterSecrecyTermContent());
                        confClassified.setClassifiedExpire(date1);
                    }
                }
            }
        }
        if (confClassifiedDecrypt.getAfterRange() != null) {
            confClassifiedDetailsVo.setRange(confClassifiedDecrypt.getAfterRange());
        }
        // 变更还原状态到保密中
        confClassified.setChangeStatus(2);
        confClassifiedDetails.setClassifiedContent(JSONObject.toJSONString(confClassifiedDetailsVo));
        newConfClassifiedList.add(confClassified);
        newConfClassifiedDetailsList.add(confClassifiedDetails);
    }

    private void decryptOfDecrypt(ConfClassifiedDecrypt confClassifiedDecrypt,ConfClassified confClassified,List<ConfClassified> newConfClassifiedList) {
        if (confClassifiedDecrypt.getDecryptMethod() == 1) { // 解密并公开
            confClassified.setChangeStatus(5);
        } else if (confClassifiedDecrypt.getDecryptMethod() == 2) { // 解密后内部使用
            confClassified.setChangeStatus(4);
        } else { // 部分秘密
            confClassified.setChangeStatus(2);
        }
        newConfClassifiedList.add(confClassified);
    }
}
