package com.tykj.classified.service.impl;

import com.tykj.classified.dao.db1.ConfClassifiedDetailsDao;
import com.tykj.classified.entity.db1.ConfClassifiedDetails;
import com.tykj.classified.service.ConfClassifiedDetailsService;
import com.tykj.classified.utils.idwork.IdWorker;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class ConfClassifiedDetailsServiceImpl implements ConfClassifiedDetailsService {

    private final ConfClassifiedDetailsDao confClassifiedDetailsDao;

    private final IdWorker idWorker;

    public ConfClassifiedDetailsServiceImpl(ConfClassifiedDetailsDao confClassifiedDetailsDao, IdWorker idWorker) {
        this.confClassifiedDetailsDao = confClassifiedDetailsDao;
        this.idWorker = idWorker;
    }

    @Override
    public ConfClassifiedDetails save(ConfClassifiedDetails confClassifiedDetails) {
        String uuid = idWorker.nextId() + "";
        confClassifiedDetails.setId(uuid);
        return confClassifiedDetailsDao.save(confClassifiedDetails);
    }
}
