package com.tykj.classified.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfClassifiedPersonLiableDao;
import com.tykj.classified.dao.db1.DataUnitDao;
import com.tykj.classified.dao.db1.EmployeeDao;
import com.tykj.classified.entity.db1.*;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedPersonLiableService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ConfClassifiedPersonLiableServiceImpl implements ConfClassifiedPersonLiableService {

    private final ConfClassifiedPersonLiableDao confClassifiedPersonLiableDao;

    private final DataUnitDao dataUnitDao;

    private final EmployeeDao employeeDao;

    private final IdWorker idWorker;

    EntityManager entityManager;

    final ApplicationContext applicationContext;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    public ConfClassifiedPersonLiableServiceImpl(ConfClassifiedPersonLiableDao confClassifiedPersonLiableDao, DataUnitDao dataUnitDao, EmployeeDao employeeDao, IdWorker idWorker, ApplicationContext applicationContext) {
        this.confClassifiedPersonLiableDao = confClassifiedPersonLiableDao;
        this.dataUnitDao = dataUnitDao;
        this.employeeDao = employeeDao;
        this.idWorker = idWorker;
        this.applicationContext = applicationContext;
        Map<String, EntityManager> beansOfType = this.applicationContext.getBeansOfType(EntityManager.class);
        for (String s : beansOfType.keySet()) {
            EntityManager entityManagerIndex = beansOfType.get(s);
            String persistenceUnitName = entityManagerIndex.getEntityManagerFactory().getProperties().get("hibernate.ejb.persistenceUnitName").toString();
            if (persistenceUnitName.equals("mysqlPersistenceUnit")) {
                entityManager = entityManagerIndex;
            }
        }
    }

    @Override
    public ConfClassifiedPersonLiableVo findAllClassifiedPersonLiablePaging(ConfClassifiedPersonLiablePageVo confClassifiedPersonLiablePageVo) {
        ConfClassifiedPersonLiableVo confClassifiedPersonLiableVo = new ConfClassifiedPersonLiableVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedPersonLiable> confClassifiedPersonLiablePredicateBuilder = Specifications.and();
        confClassifiedPersonLiablePredicateBuilder.eq("fillingUnitId",MyThreadLocal.get().getUnitIdTwo());
        confClassifiedPersonLiablePredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedPersonLiablePageVo.getCurrentPage() - 1, confClassifiedPersonLiablePageVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedPersonLiable> confClassifiedPersonLiablePage = confClassifiedPersonLiableDao.findAll(confClassifiedPersonLiablePredicateBuilder.build(), pageRequest);
        confClassifiedPersonLiableVo.setConfClassifiedPersonLiableList(confClassifiedPersonLiablePage.getContent());
        confClassifiedPersonLiableVo.setTotalPage(confClassifiedPersonLiablePage.getTotalElements());
        return confClassifiedPersonLiableVo;

    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void addConfClassifiedPersonLiable(ConfClassifiedPersonLiableAddVo confClassifiedPersonLiableAddVo) {
        Date date = new Date();
        ConfClassifiedPersonLiable confClassifiedPersonLiable = new ConfClassifiedPersonLiable();
        if (StringUtils.isNotEmpty(confClassifiedPersonLiableAddVo.getId())) { // 修改
            Optional<ConfClassifiedPersonLiable> byId = confClassifiedPersonLiableDao.findById(confClassifiedPersonLiableAddVo.getId());
            if (!byId.isPresent()) {
                throw new BizException("dm责任人名单信息不存在");
            }
            Employee employee = employeeDao.findEmployeeByPersonId(confClassifiedPersonLiableAddVo.getPersonId());
            if (confClassifiedPersonLiableAddVo.getType() == 1) { // 法定
                employee.setLegalClassifiedResponsible(1);
            } else { // 指定
                employee.setSpecifyClassifiedResponsible(1);
            }
            employee.setSecretRelateLevel(confClassifiedPersonLiableAddVo.getClassifiedAuth());
            employee.setUnitDepartment(confClassifiedPersonLiableAddVo.getUnitDepartment());
            employee.setOfficialCpacity(confClassifiedPersonLiableAddVo.getPost());
            confClassifiedPersonLiable = byId.get();
            confClassifiedPersonLiable.setAuthUnitId(confClassifiedPersonLiableAddVo.getAuthUnitId());
            confClassifiedPersonLiable.setAuthUnit(confClassifiedPersonLiableAddVo.getAuthUnit());
            confClassifiedPersonLiable.setPersonId(confClassifiedPersonLiableAddVo.getPersonId());
            confClassifiedPersonLiable.setPersonName(confClassifiedPersonLiableAddVo.getPersonName());
            confClassifiedPersonLiable.setPost(confClassifiedPersonLiableAddVo.getPost());
            confClassifiedPersonLiable.setUnitDepartment(confClassifiedPersonLiableAddVo.getUnitDepartment());
            confClassifiedPersonLiable.setClassifiedAuthId(confClassifiedPersonLiableAddVo.getClassifiedAuthId());
            confClassifiedPersonLiable.setClassifiedAuth(confClassifiedPersonLiableAddVo.getClassifiedAuth());
            confClassifiedPersonLiable.setClassifiedMatters(confClassifiedPersonLiableAddVo.getClassifiedMatters());
            confClassifiedPersonLiable.setType(confClassifiedPersonLiableAddVo.getType());
            confClassifiedPersonLiable.setSureTime(confClassifiedPersonLiableAddVo.getSureTime());
            confClassifiedPersonLiable.setDes(confClassifiedPersonLiableAddVo.getDes());
            confClassifiedPersonLiable.setUpdateTime(date);
            confClassifiedPersonLiable.setDeleteStatus(0);
            confClassifiedPersonLiableDao.save(confClassifiedPersonLiable);
            employeeDao.save(employee);
        } else { // 新增
            Employee employeeByPersonId = employeeDao.findEmployeeByPersonId(confClassifiedPersonLiableAddVo.getPersonId());
            if (employeeByPersonId == null) {
                throw new BizException("查无此人，无法新增");
            }
            if (confClassifiedPersonLiableAddVo.getType() == 1) { // 法定
                employeeByPersonId.setLegalClassifiedResponsible(1);
            } else { // 指定
                employeeByPersonId.setSpecifyClassifiedResponsible(1);
            }
            employeeByPersonId.setSecretRelateLevel(confClassifiedPersonLiableAddVo.getClassifiedAuth());
            employeeByPersonId.setOfficialCpacity(confClassifiedPersonLiableAddVo.getPost());
            employeeByPersonId.setUnitDepartment(confClassifiedPersonLiableAddVo.getUnitDepartment());
            BeanUtils.copyProperties(confClassifiedPersonLiableAddVo,confClassifiedPersonLiable);
            confClassifiedPersonLiable.setId(idWorker.nextId() + "");
            confClassifiedPersonLiable.setFillingPersonId(MyThreadLocal.get().getId());
            confClassifiedPersonLiable.setFillingPerson(MyThreadLocal.get().getUserName());
            confClassifiedPersonLiable.setFillingTime(date);
            confClassifiedPersonLiable.setFillingUnitId(MyThreadLocal.get().getUnitIdTwo());
            confClassifiedPersonLiable.setFillingUnit(MyThreadLocal.get().getUnitNameTwo());
            confClassifiedPersonLiable.setCreateTime(date);
            confClassifiedPersonLiable.setUpdateTime(date);
            confClassifiedPersonLiable.setDeleteStatus(0);
            confClassifiedPersonLiableDao.save(confClassifiedPersonLiable);
            employeeDao.save(employeeByPersonId);
        }
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void deleteConfClassifiedPersonLiable(String id) {
        if (StringUtils.isNotEmpty(id)) {
            Optional<ConfClassifiedPersonLiable> byId = confClassifiedPersonLiableDao.findById(id);
            if (!byId.isPresent()) {
                throw new BizException("dm责任人名单信息不存在");
            }
            ConfClassifiedPersonLiable confClassifiedPersonLiable = byId.get();
            Employee employeeByPersonId = employeeDao.findEmployeeByPersonId(confClassifiedPersonLiable.getPersonId());
            if (confClassifiedPersonLiable.getType() == 1) { // 法定
                employeeByPersonId.setLegalClassifiedResponsible(0);
            } else { // 指定
                employeeByPersonId.setSpecifyClassifiedResponsible(0);
            }
            confClassifiedPersonLiable.setDeleteStatus(1);
            confClassifiedPersonLiableDao.save(confClassifiedPersonLiable);
            employeeDao.save(employeeByPersonId);
        } else {
            throw new BizException("dm责任人名单信息不存在");
        }
    }

    // 获取单位树
    @Override
    public List<TreeVo> getTree() {
        List<TreeVo> treeFirstVoList = new ArrayList<>();

        List<DataUnit> dateUnitByDaoList = dataUnitDao.findAllByUnitNatureNot("企业事业单位");
        Map<String, List<DataUnit>> mapByUnit = dateUnitByDaoList.stream()
                .collect(Collectors.groupingBy(DataUnit::getUnitId));

        // 市可以看所有，区只能看自己
        //第一层
        TreeVo treeFirstVo = new TreeVo();
        treeFirstVoList.add(treeFirstVo);
        treeFirstVo.setUnitId("11330100002489006R");
        treeFirstVo.setUnitName("市辖区");
        treeFirstVo.setIsEnd(false);
        //第二层

        String secondTree =  "上城区-113301023112491457#拱墅区-113301055773183711";
        List<TreeVo> treeSecondVoList = new ArrayList<>();
        //转换为List
        String[] unitTreeList = secondTree.split("#");
        for (String unitTree : unitTreeList) {
            TreeVo treeSecondVo = new TreeVo();
            treeSecondVo.setUnitId(unitTree.split("-")[1]);
            treeSecondVo.setUnitName(unitTree.split("-")[0]);
            List<DataUnit> dataUnitList = mapByUnit.get(unitTree.split("-")[1]);
            if (CollectionUtils.isEmpty(dataUnitList)){
                treeSecondVo.setIsEnd(true);
            }else {
                treeSecondVo.setIsEnd(false);
                List<TreeVo> treeThreeVoList = new ArrayList<>();
                for (DataUnit dataUnit : dataUnitList) {
                    TreeVo treeThreeVo = new TreeVo();
                    treeThreeVo.setUnitId(dataUnit.getUnitId());
                    treeThreeVo.setUnitName(dataUnit.getUnitName());
                    treeThreeVo.setTreeChildVoList(null);
                    treeThreeVo.setIsEnd(true);
                    treeThreeVoList.add(treeThreeVo);
                }
                treeSecondVo.setTreeChildVoList(treeThreeVoList);
            }
            treeSecondVoList.add(treeSecondVo);
        }
        treeFirstVo.setTreeChildVoList(treeSecondVoList);
        System.out.println(JSONObject.toJSONString(treeFirstVoList));
        return treeFirstVoList;
    }

    @Override
    public ConfClassifiedPersonLiableVo findAllClassifiedPersonLiablePagingByDpNodeId(ConfClassifiedPersonLiablePageTwoVo confClassifiedPersonLiablePageTwoVo) {
        List<String> unitIdList = getUnitIdList(confClassifiedPersonLiablePageTwoVo.getNodeId());
        ConfClassifiedPersonLiableVo confClassifiedPersonLiableVo = new ConfClassifiedPersonLiableVo();

        //创建查询条件
        PredicateBuilder<ConfClassifiedPersonLiable> confClassifiedPersonLiablePredicateBuilder = Specifications.and();
        if (!MyThreadLocal.get().getUnitId().equals(code)) {
            confClassifiedPersonLiablePredicateBuilder.in("fillingUnitId",unitIdList);
        }
        confClassifiedPersonLiablePredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedPersonLiablePageTwoVo.getCurrentPage() - 1, confClassifiedPersonLiablePageTwoVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedPersonLiable> confClassifiedPersonLiablePage = confClassifiedPersonLiableDao.findAll(confClassifiedPersonLiablePredicateBuilder.build(), pageRequest);
        confClassifiedPersonLiableVo.setConfClassifiedPersonLiableList(confClassifiedPersonLiablePage.getContent());
        confClassifiedPersonLiableVo.setTotalPage(confClassifiedPersonLiablePage.getTotalElements());
        return confClassifiedPersonLiableVo;

    }

    @Override
    public ConfClassifiedPersonLiableVo findAllClassifiedPersonLiablePagingByDpUnitId(ConfClassifiedPersonLiablePageThreeVo confClassifiedPersonLiablePageThreeVo) {
        ConfClassifiedPersonLiableVo confClassifiedPersonLiableVo = new ConfClassifiedPersonLiableVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedPersonLiable> confClassifiedPersonLiablePredicateBuilder = Specifications.and();
        if (StringUtils.isEmpty(confClassifiedPersonLiablePageThreeVo.getUnitId())) {
            confClassifiedPersonLiablePageThreeVo.setUnitId(MyThreadLocal.get().getUnitId());
        }
        confClassifiedPersonLiablePredicateBuilder.eq("fillingUnitId",confClassifiedPersonLiablePageThreeVo.getUnitId());

        confClassifiedPersonLiablePredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedPersonLiablePageThreeVo.getCurrentPage() - 1, confClassifiedPersonLiablePageThreeVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedPersonLiable> confClassifiedPersonLiablePage = confClassifiedPersonLiableDao.findAll(confClassifiedPersonLiablePredicateBuilder.build(), pageRequest);
        confClassifiedPersonLiableVo.setConfClassifiedPersonLiableList(confClassifiedPersonLiablePage.getContent());
        confClassifiedPersonLiableVo.setTotalPage(confClassifiedPersonLiablePage.getTotalElements());
        return confClassifiedPersonLiableVo;

    }

    // 根据节点id获取节点id下面所有的节点并得到所有单位
    private List<String> getUnitIdList(String nodeId) {
        List<String> unitIdList = new ArrayList<>();
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(nodeId)) {
            if (nodeId.equals("0")) { // 选杭州市
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    unitIdList = dataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            } else {
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    String sql = "from ConfUnitNode  where nodeRelationship like '%"+ nodeId +"%'";
                    // 获取到所有叶子节点和当前节点
                    List<ConfUnitNode> all = entityManager.createQuery(sql).getResultList();
                    // 查询所有单位
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    List<DataUnit> newDataUnitList = new ArrayList<>();
                    List<DataUnit> allDataUnitList = new ArrayList<>();
                    for (ConfUnitNode confUnitNode : all) {
                        // 只要是单位节点,就去匹配所有单位
                        if (confUnitNode.getIsUnitNode()) {
                            if (confUnitNode.getUnitType().equals("全部")) {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()))
                                        .collect(Collectors.toList());
                            } else {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()) &&
                                                dataUnit.getUnitNature().equals(confUnitNode.getUnitType()))
                                        .collect(Collectors.toList());
                            }
                        }
                        // 查询出所有匹配的单位并存入进去
                        allDataUnitList.addAll(newDataUnitList);
                    }
                    unitIdList = allDataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    unitIdList = unitIdList.stream().distinct().collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            }
        } else {
            throw new BizException("请选择节点!");
        }
    }
}
