package com.tykj.classified.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.*;
import com.tykj.classified.entity.db1.*;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.count.ClassifiedCountVo;
import com.tykj.classified.entity.vo.count.ClassifiedSum;
import com.tykj.classified.entity.vo.count.ColumnChartVo;
import com.tykj.classified.entity.vo.count.PieChartVo;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedService;
import com.tykj.classified.utils.date.DateUtils;
import com.tykj.classified.utils.date.TimeUtils;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.log.LogUtils;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import javax.persistence.criteria.*;
import javax.transaction.Transactional;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ConfClassifiedServiceImpl implements ConfClassifiedService {

    private final ConfClassifiedDao confClassifiedDao;

    private final ConfClassifiedDetailsDao confClassifiedDetailsDao;

    private final ConfClassifiedDecryptDao confClassifiedDecryptDao;

    private final ConfOperationRecordDao confOperationRecordDao;

    private final ConfClassifiedBasisDao confClassifiedBasisDao;

    private final ConfManageDao confManageDao;

    private final ConfManageDetailDao confManageDetailDao;

    private final EmployeeDao employeeDao;

    private final IdWorker idWorker;

    private final UnitBasisDao unitBasisDao;

    EntityManager entityManager;

    private final ApplicationContext applicationContext;

    private final DataUnitDao dataUnitDao;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    public ConfClassifiedServiceImpl(ConfClassifiedDao confClassifiedDao, ConfClassifiedDetailsDao confClassifiedDetailsDao, ConfClassifiedDecryptDao confClassifiedDecryptDao, ConfOperationRecordDao confOperationRecordDao, ConfClassifiedBasisDao confClassifiedBasisDao, ConfManageDao confManageDao, ConfManageDetailDao confManageDetailDao, EmployeeDao employeeDao, IdWorker idWorker, UnitBasisDao unitBasisDao, ApplicationContext applicationContext, DataUnitDao dataUnitDao) {
        this.confClassifiedDao = confClassifiedDao;
        this.confClassifiedDetailsDao = confClassifiedDetailsDao;
        this.confClassifiedDecryptDao = confClassifiedDecryptDao;
        this.confOperationRecordDao = confOperationRecordDao;
        this.confClassifiedBasisDao = confClassifiedBasisDao;
        this.confManageDao = confManageDao;
        this.confManageDetailDao = confManageDetailDao;
        this.employeeDao = employeeDao;
        this.idWorker = idWorker;
        this.unitBasisDao = unitBasisDao;
        this.applicationContext = applicationContext;
        this.dataUnitDao = dataUnitDao;
        Map<String, EntityManager> beansOfType = this.applicationContext.getBeansOfType(EntityManager.class);
        for (String s : beansOfType.keySet()) {
            EntityManager entityManagerIndex = beansOfType.get(s);
            String persistenceUnitName = entityManagerIndex.getEntityManagerFactory().getProperties().get("hibernate.ejb.persistenceUnitName").toString();
            if (persistenceUnitName.equals("mysqlPersistenceUnit")) {
                entityManager = entityManagerIndex;
            }
        }
    }

    @Override
    public ConfClassifiedVo findAllClassifiedPaging(ConfClassifiedPageVo confClassifiedPageVo) {
        PredicateBuilder<ConfClassified> confClassifiedBuilder = Specifications.and();
        ConfManage confManage = confManageDao.findConfManageByManageName("密级");
        List<ConfManageDetail> confManageDetailList = new ArrayList<>();
        if (confManage != null) {
            confManageDetailList = confManageDetailDao.findAllByManageIdOrderBySortNum(confManage.getId());
        }
        if (Optional.ofNullable(confClassifiedPageVo.getSpecifiedTimeType()).isPresent()) {
            Date date = new Date();
            if (confClassifiedPageVo.getSpecifiedTimeType() == 1) { // 6月内到期
                Date date1 = DateUtils.addMonth(date, Integer.parseInt(confClassifiedPageVo.getMonth()));
                confClassifiedBuilder.ge("classifiedExpire",date);
                confClassifiedBuilder.le("classifiedExpire", date1);
                confClassifiedBuilder.eq("changeStatus",2);
            } else if (confClassifiedPageVo.getSpecifiedTimeType() == 2) { // 2年内到期
                Date date2 = DateUtils.addMonth(date, Integer.parseInt(confClassifiedPageVo.getMonth()));
                Date date1 = DateUtils.addYear(date, Integer.parseInt(confClassifiedPageVo.getYear()));
                confClassifiedBuilder.gt("classifiedExpire", date2);
                confClassifiedBuilder.le("classifiedExpire", date1);
                confClassifiedBuilder.eq("changeStatus",2);
            }
        }
        confClassifiedBuilder.eq(confClassifiedPageVo.getChangeStatus() != null,"changeStatus",confClassifiedPageVo.getChangeStatus());
        if (MyThreadLocal.get().getClassification() == 3) {
            confClassifiedBuilder.le("classificationSortNum", 4);
        } else if (MyThreadLocal.get().getClassification() == 2) {
            confClassifiedBuilder.le("classificationSortNum", 3);
        } else if (MyThreadLocal.get().getClassification() == 1) {
            confClassifiedBuilder.le("classificationSortNum", 2);
        } else {
            return new ConfClassifiedVo();
        }
        confClassifiedBuilder.eq(confClassifiedPageVo.getSecretType() != null, "secretType", confClassifiedPageVo.getSecretType());
        if (confClassifiedPageVo.getSelectType() != null) {
            if (confClassifiedPageVo.getSelectType() == 1) { // 确定列表
                confClassifiedBuilder.eq( "changeStatus", 1);
            } else if (confClassifiedPageVo.getSelectType() == 2) { // 变更列表
                confClassifiedBuilder.in( "changeStatus", 2,6);
            } else if (confClassifiedPageVo.getSelectType() == 3){ // 解除列表
                confClassifiedBuilder.in( "changeStatus", 2,4,5,7,8);
            } else {
                throw new BizException("没有该类型，请重新操作");
            }
        }
        confClassifiedBuilder.like(StringUtils.isNotEmpty(confClassifiedPageVo.getItemName()), "itemName", "%" + confClassifiedPageVo.getItemName() + "%");
        confClassifiedBuilder.eq(confClassifiedPageVo.getType() != null, "type", confClassifiedPageVo.getType());
        confClassifiedBuilder.eq(StringUtils.isNotEmpty(confClassifiedPageVo.getClassification()), "classification", confClassifiedPageVo.getClassification());
        confClassifiedBuilder.eq("operatorUnit", MyThreadLocal.get().getUnitIdTwo());
        Sort sort = Sort.by(Sort.Direction.DESC, "updateTime");
        if (Optional.ofNullable(confClassifiedPageVo.getUpdateTime()).isPresent()) {
            if (confClassifiedPageVo.getClassifiedTime() == 1) { // 降序
                sort = Sort.by(Sort.Direction.DESC, "updateTime");
            } else { // 升序
                sort = Sort.by(Sort.Direction.ASC, "updateTime");
            }
        }
        if (Optional.ofNullable(confClassifiedPageVo.getClassifiedTime()).isPresent()) {
            if (confClassifiedPageVo.getClassifiedTime() == 1) { // 降序
                sort = Sort.by(Sort.Direction.DESC, "classifiedExpire");
            } else { // 升序
                sort = Sort.by(Sort.Direction.ASC, "classifiedExpire");
            }
        }
        PageRequest pageRequest = PageRequest.of(confClassifiedPageVo.getCurrentPage() - 1, confClassifiedPageVo.getPageSize(), sort);
        Page<ConfClassified> confClassifiedPage = confClassifiedDao.findAll(confClassifiedBuilder.build(), pageRequest);
        List<ConfClassified> confClassifiedList = new ArrayList<>(confClassifiedPage.getContent());
        if (Optional.ofNullable(confClassifiedPageVo.getIsType()).isPresent()) {
            Map<Integer, List<ConfClassified>> collect = confClassifiedList.stream()
                    .collect(Collectors.groupingBy(ConfClassified::getType));
            confClassifiedList.clear();
            // 分组
            if (confClassifiedPageVo.getIsType() == 0) { // 升序
                for (int i = 1; i <= 4; i++) {
                    if (collect.get(i) != null) {
                        confClassifiedList.addAll(collect.get(i));
                    }
                }
            } else { // 降序
                for (int i = 4; i >= 1; i--) {
                    if (collect.get(i) != null) {
                        confClassifiedList.addAll(collect.get(i));
                    }
                }
            }
        }
        if (Optional.ofNullable(confClassifiedPageVo.getIsClassified()).isPresent()) {
            Map<String, List<ConfClassified>> collect = confClassifiedList.stream()
                    .collect(Collectors.groupingBy(ConfClassified::getClassification));
            confClassifiedList.clear();
            // 分组
            if (confClassifiedPageVo.getIsClassified() == 0) { // 升序
                confManageDetailList.sort(Comparator.comparing(ConfManageDetail::getSortNum));
            } else { // 降序
                confManageDetailList.sort(Comparator.comparing(ConfManageDetail::getSortNum).reversed());
            }
            for (ConfManageDetail confManageDetail : confManageDetailList) {
                if (collect.get(confManageDetail.getId()) != null) {
                    confClassifiedList.addAll(collect.get(confManageDetail.getId()));
                }
            }
        }
        if (Optional.ofNullable(confClassifiedPageVo.getIsStatus()).isPresent()) {
            Map<Integer, List<ConfClassified>> collect = confClassifiedList.stream()
                    .collect(Collectors.groupingBy(ConfClassified::getChangeStatus));
            confClassifiedList.clear();
            // 分组1-待定密,2-保密中,3-部分解密,4-工作秘密,5-已公开
            if (confClassifiedPageVo.getIsStatus() == 0) { // 升序
                for (int i = 1; i <= 5; i++) {
                    if (collect.get(i) != null) {
                        confClassifiedList.addAll(collect.get(i));
                    }
                }
            } else { // 降序
                for (int i = 5; i >= 1; i--) {
                    if (collect.get(i) != null) {
                        confClassifiedList.addAll(collect.get(i));
                    }
                }
            }
        }
        ConfClassifiedVo confClassifiedVo = new ConfClassifiedVo();
        confClassifiedVo.setConfClassifiedList(confClassifiedList);
        confClassifiedVo.setTotalPage(confClassifiedPage.getTotalElements());
        return confClassifiedVo;
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void addClassified(ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo, Integer secretType) {
        if (confClassifiedAndDetailsVo != null) {
            Date date = new Date();
            ConfClassified confClassified = new ConfClassified();
            ConfClassifiedDetails confClassifiedDetails = new ConfClassifiedDetails();
            ConfManageDetail confManageDetailByManageId = confManageDetailDao.findConfManageDetailById(confClassifiedAndDetailsVo.getClassification());
            // 修改
            if (StringUtils.isNotEmpty(confClassifiedAndDetailsVo.getClassifiedId())) {
                confClassified = confClassifiedDao.findConfClassifiedById(confClassifiedAndDetailsVo.getClassifiedId());
                BeanUtils.copyProperties(confClassifiedAndDetailsVo, confClassified);
                confClassified.setId(confClassifiedAndDetailsVo.getClassifiedId());
                confClassified.setChangeStatus(confClassifiedAndDetailsVo.getChangeStatus());
                confClassified.setUpdateTime(date);
                confClassified.setIsUpdate("否");
                // 如果是工m，密级默认是内部
                if (secretType == 2) {
                    confClassified.setClassificationSortNum(1);
                } else {
                    confClassified.setClassificationSortNum(confManageDetailByManageId.getSortNum());
                }

                // 子表
                ConfClassifiedDetailsVo confClassifiedDetailsVo = new ConfClassifiedDetailsVo();
                BeanUtils.copyProperties(confClassifiedAndDetailsVo, confClassifiedDetailsVo);
                confClassifiedDetails.setId(confClassifiedAndDetailsVo.getClassifiedDetailsId());
                confClassifiedDetails.setClassifiedId(confClassifiedAndDetailsVo.getClassifiedId());
                confClassifiedDetails.setClassifiedContent(JSONObject.toJSONString(confClassifiedDetailsVo));
            } else { // 新增
                String classifiedId = idWorker.nextId() + "";
                // 主表
                BeanUtils.copyProperties(confClassifiedAndDetailsVo, confClassified);
                confClassified.setId(classifiedId);
                confClassified.setSecretType(secretType);
                // 如果是工m，密级默认是内部
                if (secretType == 2) {
                    confClassified.setClassification("1");
                    confClassified.setClassificationSortNum(1);
                } else {
                    confClassified.setClassificationSortNum(confManageDetailByManageId.getSortNum());
                }
                confClassified.setChangeStatus(1);
                confClassified.setCreateTime(date);
                confClassified.setUpdateTime(date);
                confClassified.setOperatorId(MyThreadLocal.get().getId());
                confClassified.setOperatorUnit(MyThreadLocal.get().getUnitIdTwo());
                confClassified.setOperatorUnitName(MyThreadLocal.get().getUnitNameTwo());
                confClassified.setIsUpdate("否");

                // 子表
                ConfClassifiedDetailsVo confClassifiedDetailsVo = new ConfClassifiedDetailsVo();
                BeanUtils.copyProperties(confClassifiedAndDetailsVo, confClassifiedDetailsVo);
                confClassifiedDetails.setId(idWorker.nextId() + "");
                confClassifiedDetails.setClassifiedId(classifiedId);
                confClassifiedDetails.setClassifiedContent(JSONObject.toJSONString(confClassifiedDetailsVo));
                // 操作记录
                LogUtils.addOperationRecord(classifiedId,"新增定密",date, MyThreadLocal.get().getId(),MyThreadLocal.get().getUserName(),MyThreadLocal.get().getUnitNameTwo());
            }
            confClassifiedDao.save(confClassified);
            confClassifiedDetailsDao.save(confClassifiedDetails);
        } else {
            throw new BizException("传入的数据为空");
        }
    }

    @Override
    public ConfClassifiedAndDetailsVo findClassifiedInfo(String classifiedId) {
        ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo = new ConfClassifiedAndDetailsVo();
        Optional<ConfClassified> byId = confClassifiedDao.findById(classifiedId);
        if (byId.isPresent()) {
            ConfClassified confClassified = byId.get();
            ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsDao.findByClassifiedId(classifiedId);
            ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(confClassifiedDetails.getClassifiedContent(), ConfClassifiedDetailsVo.class);
            BeanUtils.copyProperties(confClassified, confClassifiedAndDetailsVo);
            BeanUtils.copyProperties(confClassifiedDetailsVo, confClassifiedAndDetailsVo);
            confClassifiedAndDetailsVo.setClassifiedId(confClassified.getId());
            confClassifiedAndDetailsVo.setType(confClassified.getType());
            confClassifiedAndDetailsVo.setClassifiedDetailsId(confClassifiedDetails.getId());
        } else {
            throw new BizException("定密信息不存在");
        }
        return confClassifiedAndDetailsVo;
    }

    @Override
    public ConfClassifiedInfoVo findClassifiedAllInfo(String classifiedId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日hh:mm");
        Optional<ConfClassified> byId = confClassifiedDao.findById(classifiedId);
        if (byId.isPresent()) {
            ConfClassifiedInfoVo confClassifiedInfoVo = new ConfClassifiedInfoVo();
            // 基本信息
            ConfClassified confClassified = byId.get();
            ConfClassifiedDetails confClassifiedDetails = confClassifiedDetailsDao.findByClassifiedId(classifiedId);
            ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(confClassifiedDetails.getClassifiedContent(), ConfClassifiedDetailsVo.class);
            ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo = new ConfClassifiedAndDetailsVo();
            BeanUtils.copyProperties(confClassified, confClassifiedAndDetailsVo);
            BeanUtils.copyProperties(confClassifiedDetailsVo, confClassifiedAndDetailsVo);
            confClassifiedAndDetailsVo.setClassifiedId(confClassified.getId());
            confClassifiedAndDetailsVo.setClassifiedDetailsId(confClassifiedDetails.getId());
            confClassifiedInfoVo.setConfClassifiedAndDetailsVo(confClassifiedAndDetailsVo);
            // 事项解密
            List<ConfClassifiedDecryptVo> confClassifiedDecryptVoList = new ArrayList<>();
            List<ConfClassifiedDecrypt> confClassifiedDecryptList = confClassifiedDecryptDao.findAllByClassifiedIdOrderByCreateTimeDesc(classifiedId);
            for (ConfClassifiedDecrypt confClassifiedDecrypt : confClassifiedDecryptList) {
                ConfClassifiedDecryptVo confClassifiedDecryptVo = new ConfClassifiedDecryptVo();
                BeanUtils.copyProperties(confClassifiedDecrypt, confClassifiedDecryptVo);
                confClassifiedDecryptVoList.add(confClassifiedDecryptVo);
            }
            confClassifiedInfoVo.setConfClassifiedDecryptVoList(confClassifiedDecryptVoList);
            // 操作记录
            List<ConfOperationRecordVo> confOperationRecordVoList = new ArrayList<>();
            PredicateBuilder<ConfOperationRecord> confOperationRecordBuilder = Specifications.and();
            confOperationRecordBuilder.eq("classifiedId", classifiedId);
            PageRequest pageRequest = PageRequest.of(0, 10, Sort.by(Sort.Direction.ASC, "operationTime"));
            Page<ConfOperationRecord> confOperationRecordPage = confOperationRecordDao.findAll(confOperationRecordBuilder.build(), pageRequest);
            for (ConfOperationRecord confOperationRecord : confOperationRecordPage.getContent()) {
                ConfOperationRecordVo confOperationRecordVo = new ConfOperationRecordVo();
                BeanUtils.copyProperties(confOperationRecord, confOperationRecordVo);
                if (confOperationRecord.getOperationTime() != null) {
                    confOperationRecordVo.setOperationTime(sdf.format(confOperationRecord.getOperationTime()));
                }
                confOperationRecordVoList.add(confOperationRecordVo);
            }
            confClassifiedInfoVo.setTotalPage(confOperationRecordPage.getTotalElements());
            confClassifiedInfoVo.setConfOperationRecordVoList(confOperationRecordVoList);
            return confClassifiedInfoVo;
        } else {
            throw new BizException("定密信息不存在");
        }
    }

    @Override
    public ClassifiedCountVo classifiedCount() {
        ClassifiedCountVo classifiedCountVo = new ClassifiedCountVo();
        List<ConfClassified> confClassifiedList;
        if (MyThreadLocal.get().getUnitIdTwo().equals(code)) {
            confClassifiedList = confClassifiedDao.findAll();
        } else {
            confClassifiedList = confClassifiedDao.findAllByOperatorUnit(MyThreadLocal.get().getUnitIdTwo());
        }
        Date date = new Date();
        Date date2 = DateUtils.addYear(date, -1);

        ConfManage confManage = confManageDao.findConfManageByManageName("密级");
        List<ConfManageDetail> confManageDetailList = new ArrayList<>();
        if (confManage != null) {
            confManageDetailList = confManageDetailDao.findAllByManageIdOrderBySortNum(confManage.getId());
        }

        if (MyThreadLocal.get().getClassification() == 3) { // 核心
            confClassifiedList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getClassificationSortNum() == 4 ||
                            confClassified.getClassificationSortNum() == 3 ||
                            confClassified.getClassificationSortNum() == 2 ||
                            confClassified.getClassificationSortNum() == 1)
                    .collect(Collectors.toList());
            confManageDetailList = confManageDetailList.stream().filter(confManageDetail -> confManageDetail.getId().equals("4") ||
                    confManageDetail.getId().equals("3") ||
                    confManageDetail.getId().equals("2") ||
                    confManageDetail.getId().equals("1"))
                    .collect(Collectors.toList());
        } else if (MyThreadLocal.get().getClassification() == 2) { // 重要
            confClassifiedList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getClassificationSortNum() == 3 ||
                            confClassified.getClassificationSortNum() == 2 ||
                            confClassified.getClassificationSortNum() == 1)
                    .collect(Collectors.toList());
            confManageDetailList = confManageDetailList.stream().filter(confManageDetail -> confManageDetail.getId().equals("3") ||
                    confManageDetail.getId().equals("2") ||
                    confManageDetail.getId().equals("1"))
                    .collect(Collectors.toList());
        } else if (MyThreadLocal.get().getClassification() == 1){ // 一般
            confClassifiedList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getClassificationSortNum() == 2 ||
                            confClassified.getClassificationSortNum() == 1)
                    .collect(Collectors.toList());
            confManageDetailList = confManageDetailList.stream().filter(confManageDetail -> confManageDetail.getId().equals("2") ||
                    confManageDetail.getId().equals("1"))
                    .collect(Collectors.toList());
        } else {
            confClassifiedList = new ArrayList<>();
            confManageDetailList = new ArrayList<>();
        }
        // 定密汇总
        ClassifiedSum classifiedSum = new ClassifiedSum();
        if (MyThreadLocal.get().getUnitIdTwo().equals(code)) {
            // 定密总数
            classifiedSum.setClassifiedNum(confClassifiedList.size());
            // gjmm
            List<ConfClassified> gjmmList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getSecretType() == 3)
                    .collect(Collectors.toList());
            classifiedSum.setStateSecretNum(gjmmList.size());
            // gzmm
            List<ConfClassified> gzmmList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getSecretType() == 2)
                    .collect(Collectors.toList());
            classifiedSum.setWorkSecretNum(gzmmList.size());
            // 已公开
            List<ConfClassified> publicList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getChangeStatus() == 5)
                    .collect(Collectors.toList());
            classifiedSum.setPublicNum(publicList.size());
            classifiedCountVo.setClassifiedSum(classifiedSum);

            // 饼图
            List<PieChartVo> pieChartVoList = new ArrayList<>();
            int sum = 0;
            for (ConfManageDetail confManageDetail : confManageDetailList) {
                PieChartVo pieChartVo = new PieChartVo();
                List<ConfClassified> mjNum = confClassifiedList.stream()
                        .filter(confClassified -> confClassified.getClassification() != null && confClassified.getClassification().equals(confManageDetail.getId()))
                        .collect(Collectors.toList());
                pieChartVo.setType(confManageDetail.getManageOptions());
                pieChartVo.setNum(mjNum.size());
                pieChartVoList.add(pieChartVo);
                sum += mjNum.size();
            }
            classifiedCountVo.setPieChartVoList(pieChartVoList);
            classifiedCountVo.setPieChartVoNum(sum);

            // 柱形图
            List<ColumnChartVo> columnChartVoList = new ArrayList<>();
            Specification<ConfClassified> specification = createSpecification(date2,date,MyThreadLocal.get().getUnitIdTwo(),MyThreadLocal.get().getClassification());
            List<ConfClassified> confClassifiedList1 = confClassifiedDao.findAll(specification);
            List<String> confClassifiedIdList = confClassifiedList1.stream()
                    .map(ConfClassified::getId)
                    .collect(Collectors.toList());
            Specification<ConfClassifiedDecrypt> specification2 = createSpecification2(date2,date,confClassifiedIdList,MyThreadLocal.get().getUnitIdTwo(),MyThreadLocal.get().getClassification());
            List<ConfClassifiedDecrypt> confClassifiedDecryptList = confClassifiedDecryptDao.findAll(specification2);
            Map<String, List<ConfClassified>> confClassifiedMap = confClassifiedList1.stream()
                    .collect(Collectors.groupingBy(t -> TimeUtils.getDate(t.getIssueDate()).format(DateTimeFormatter.ofPattern("yyyy年M月"))));
            Map<String, List<ConfClassifiedDecrypt>> ConfClassifiedDecryptMap = confClassifiedDecryptList.stream()
                    .collect(Collectors.groupingBy(t -> TimeUtils.getDate(t.getDecryptTime()).format(DateTimeFormatter.ofPattern("yyyy年M月"))));
            int j = -11;
            for (int i = 1; i <= 12; i++) {
                ColumnChartVo columnChartVo = new ColumnChartVo();
                Date date1 = DateUtils.addMonth(date, j);
                String queryTime = TimeUtils.getDate(date1).format(DateTimeFormatter.ofPattern("yyyy年M月"));
                columnChartVo.setClassifiedDate(queryTime);
                columnChartVo.setNum(0);
                if (confClassifiedMap.get(queryTime) != null) {
                    columnChartVo.setNum(columnChartVo.getNum() + confClassifiedMap.get(queryTime).size());
                }
                if (ConfClassifiedDecryptMap.get(queryTime) != null) {
                    columnChartVo.setNum(columnChartVo.getNum() + ConfClassifiedDecryptMap.get(queryTime).size());
                }
                columnChartVoList.add(columnChartVo);
                j++;
            }
            classifiedCountVo.setColumnChartVoList(columnChartVoList);
        } else {
            // 定密总数
            classifiedSum.setClassifiedNum(confClassifiedList.size());
            // gjmm
            List<ConfClassified> gjmmList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getSecretType() == 3)
                    .collect(Collectors.toList());
            classifiedSum.setStateSecretNum(gjmmList.size());
            // gzmm
            List<ConfClassified> gzmmList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getSecretType() == 2)
                    .collect(Collectors.toList());
            classifiedSum.setWorkSecretNum(gzmmList.size());
            // 已公开
            List<ConfClassified> publicList = confClassifiedList.stream()
                    .filter(confClassified -> confClassified.getChangeStatus() == 5)
                    .collect(Collectors.toList());
            classifiedSum.setPublicNum(publicList.size());
            classifiedCountVo.setClassifiedSum(classifiedSum);

            // 饼图
            List<PieChartVo> pieChartVoList = new ArrayList<>();
            int sum = 0;
            for (ConfManageDetail confManageDetail : confManageDetailList) {
                PieChartVo pieChartVo = new PieChartVo();
                List<ConfClassified> mjNum = confClassifiedList.stream()
                        .filter(confClassified -> confClassified.getClassification() != null && confClassified.getClassification().equals(confManageDetail.getId()))
                        .collect(Collectors.toList());
                pieChartVo.setType(confManageDetail.getManageOptions());
                pieChartVo.setNum(mjNum.size());
                pieChartVoList.add(pieChartVo);
                sum += mjNum.size();
            }
            classifiedCountVo.setPieChartVoList(pieChartVoList);
            classifiedCountVo.setPieChartVoNum(sum);

            // 柱形图
            List<ColumnChartVo> columnChartVoList = new ArrayList<>();
            Specification<ConfClassified> specification = createSpecification(date2,date,MyThreadLocal.get().getUnitIdTwo(),MyThreadLocal.get().getClassification());
            List<ConfClassified> confClassifiedList1 = confClassifiedDao.findAll(specification);
            List<String> confClassifiedIdList = confClassifiedList1.stream()
                    .map(ConfClassified::getId)
                    .collect(Collectors.toList());
            Specification<ConfClassifiedDecrypt> specification2 = createSpecification2(date2,date,confClassifiedIdList,MyThreadLocal.get().getUnitIdTwo(),MyThreadLocal.get().getClassification());
            List<ConfClassifiedDecrypt> confClassifiedDecryptList = confClassifiedDecryptDao.findAll(specification2);
            Map<String, List<ConfClassified>> confClassifiedMap = confClassifiedList1.stream()
                    .collect(Collectors.groupingBy(t -> TimeUtils.getDate(t.getIssueDate()).format(DateTimeFormatter.ofPattern("yyyy年M月"))));
            Map<String, List<ConfClassifiedDecrypt>> ConfClassifiedDecryptMap = confClassifiedDecryptList.stream()
                    .collect(Collectors.groupingBy(t -> TimeUtils.getDate(t.getDecryptTime()).format(DateTimeFormatter.ofPattern("yyyy年M月"))));
            int j = -11;
            for (int i = 1; i <= 12; i++) {
                ColumnChartVo columnChartVo = new ColumnChartVo();
                Date date1 = DateUtils.addMonth(date, j);
                String queryTime = TimeUtils.getDate(date1).format(DateTimeFormatter.ofPattern("yyyy年M月"));
                columnChartVo.setClassifiedDate(queryTime);
                columnChartVo.setNum(0);
                if (confClassifiedMap.get(queryTime) != null) {
                    columnChartVo.setNum(columnChartVo.getNum() + confClassifiedMap.get(queryTime).size());
                }
                if (ConfClassifiedDecryptMap.get(queryTime) != null) {
                    columnChartVo.setNum(columnChartVo.getNum() + ConfClassifiedDecryptMap.get(queryTime).size());
                }
                columnChartVoList.add(columnChartVo);
                j++;
            }
            classifiedCountVo.setColumnChartVoList(columnChartVoList);
        }
        return classifiedCountVo;
    }

    @Override
    public EmployeeAndOtherOfGmVo findEmployeeAndOtherInfoOfGM(DownListVo downListVo) {
        EmployeeAndOtherOfGmVo employeeAndOtherOfGmVo = new EmployeeAndOtherOfGmVo();
        // 参数配置（密级、缓急程度、采购单位）
        List<ConfManage> confManageList = confManageDao.findAll();
        List<ConfManageDetail> confManageDetailList = confManageDetailDao.findAll();
        List<ConfManageDetail> newClassificationList = new ArrayList<>();
        List<ConfManageDetail> newUrgencyList = new ArrayList<>();
        List<ConfManageDetail> newPurchasingUnitList = new ArrayList<>();
        List<ConfManage> classificationList = confManageList.stream()
                .filter(confManage -> confManage.getManageName().equals("密级"))
                .collect(Collectors.toList());
        List<ConfManage> urgencyList = confManageList.stream()
                .filter(confManage -> confManage.getManageName().equals("缓急程度"))
                .collect(Collectors.toList());
        List<ConfManage> purchasingUnitList = confManageList.stream()
                .filter(confManage -> confManage.getManageName().equals("采购单位"))
                .collect(Collectors.toList());
        if (classificationList.size() > 0) {
            ConfManage confManage = classificationList.get(0);
            if (MyThreadLocal.get().getClassification() == 3 || MyThreadLocal.get().getClassification() == 2) { // 核心或重要
                newClassificationList = confManageDetailList.stream()
                        .filter(confManageDetail -> confManageDetail.getManageId().equals(confManage.getId()) &&
                                confManageDetail.getSortNum() <= 3)
                        .sorted(Comparator.comparingInt(ConfManageDetail::getSortNum))
                        .collect(Collectors.toList());
            } else if (MyThreadLocal.get().getClassification() == 1) { // 一般
                newClassificationList = confManageDetailList.stream()
                        .filter(confManageDetail -> confManageDetail.getManageId().equals(confManage.getId()) &&
                                confManageDetail.getSortNum() <= 2)
                        .sorted(Comparator.comparingInt(ConfManageDetail::getSortNum))
                        .collect(Collectors.toList());
            } else {
                newClassificationList = new ArrayList<>();
            }
        }
        if (urgencyList.size() > 0) {
            ConfManage confManage = urgencyList.get(0);
            newUrgencyList = confManageDetailList.stream()
                    .filter(confManageDetail -> confManageDetail.getManageId().equals(confManage.getId()))
                    .sorted(Comparator.comparingInt(ConfManageDetail::getSortNum))
                    .collect(Collectors.toList());
        }
        if (purchasingUnitList.size() > 0) {
            ConfManage confManage = purchasingUnitList.get(0);
            newPurchasingUnitList = confManageDetailList.stream()
                    .filter(confManageDetail -> confManageDetail.getManageId().equals(confManage.getId()))
                    .sorted(Comparator.comparingInt(ConfManageDetail::getSortNum))
                    .collect(Collectors.toList());
        }
        // 定密依据
        PredicateBuilder<UnitBasis> unitBasisPredicateBuilder = Specifications.and();
        unitBasisPredicateBuilder.eq("unitId",MyThreadLocal.get().getUnitIdTwo());
        unitBasisPredicateBuilder.eq("isCheck",1);// 已选中
        List<UnitBasis> all = unitBasisDao.findAll(unitBasisPredicateBuilder.build());
        List<String> basisIdList = all.stream().map(UnitBasis::getBasisId).collect(Collectors.toList());

        if (basisIdList.size() > 0) {
            List<ConfClassifiedBasis> confClassifiedBasisList;
            PredicateBuilder<ConfClassifiedBasis> predicateBuilder = Specifications.and();
            predicateBuilder.in("id",basisIdList);

//        if (StringUtils.isNotEmpty(downListVo.getEditUnitId()) && !downListVo.getEditUnitId().equals("null")) { // 有操作人
//            // 选择依据的时候只能选自己单位下的依据
//            predicateBuilder.eq("operatorUnit",downListVo.getEditUnitId());
//        } else { // 没有操作人（在查看依据列表或新增时没有操作人）
//            // 查看依据列表时市可以看所有，区县只能看自己
//            if (downListVo.getType() == 1) { // 依据列表
//                if (!MyThreadLocal.get().getUnitId().equals(code)) {
//                    predicateBuilder.eq("operatorUnit",MyThreadLocal.get().getUnitId());
//                }
//            } else { // 新增
//                predicateBuilder.eq("operatorUnit",MyThreadLocal.get().getUnitId());
//            }
//        }

            // 能看到的M级
            if (MyThreadLocal.get().getClassification() == 3 || MyThreadLocal.get().getClassification() == 2) { // 核心或重要
                predicateBuilder.in("classificationSortNum",3,2,1);
            }  else if (MyThreadLocal.get().getClassification() == 1) { // 一般
                predicateBuilder.in("classificationSortNum",2,1);
            } else {
                throw new BizException("非M人员无法查看");
            }
            // 适用类型
            if (downListVo.getSecretType() == 2) { // 工作MM
                predicateBuilder.eq("suitableType",2);
                confClassifiedBasisList = confClassifiedBasisDao.findAll(predicateBuilder.build());
            } else if (downListVo.getSecretType() == 3){ // 国家MM
                predicateBuilder.eq("suitableType",3);
                confClassifiedBasisList = confClassifiedBasisDao.findAll(predicateBuilder.build());
            } else {
                predicateBuilder.eq("operatorUnit",MyThreadLocal.get().getUnitIdTwo());
                confClassifiedBasisList = confClassifiedBasisDao.findAll(predicateBuilder.build());
            }
//            confClassifiedBasisList = confClassifiedBasisDao.findAll(predicateBuilder.build());
            employeeAndOtherOfGmVo.setConfClassifiedBasisList(confClassifiedBasisList);
        }
        employeeAndOtherOfGmVo.setClassificationList(newClassificationList);
        employeeAndOtherOfGmVo.setUrgencyList(newUrgencyList);
        employeeAndOtherOfGmVo.setNewPurchasingUnitList(newPurchasingUnitList);
        return employeeAndOtherOfGmVo;
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void classifiedApproved(ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo) {
        if (confClassifiedAndDetailsVo != null) {
            Date date = new Date();
            ConfClassified confClassified = confClassifiedDao.findConfClassifiedById(confClassifiedAndDetailsVo.getClassifiedId());
            if (confClassified != null) {
                // 主表
                BeanUtils.copyProperties(confClassifiedAndDetailsVo,confClassified);
                confClassified.setChangeStatus(2);
                confClassified.setIssueDate(confClassifiedAndDetailsVo.getIssueDate());
                confClassified.setUpdateTime(date);
                confClassified.setIsUpdate("否");
                // 子表
                ConfClassifiedDetails confClassifiedDetails1 = confClassifiedDetailsDao.findByClassifiedId(confClassifiedAndDetailsVo.getClassifiedId());
                ConfClassifiedDetailsVo confClassifiedDetailsVo = JSONObject.parseObject(confClassifiedDetails1.getClassifiedContent(), ConfClassifiedDetailsVo.class);
                BeanUtils.copyProperties(confClassifiedAndDetailsVo,confClassifiedDetailsVo);

                ConfClassifiedAndDetailsVo confClassifiedAndDetailsVo2 = new ConfClassifiedAndDetailsVo();
                BeanUtils.copyProperties(confClassified, confClassifiedAndDetailsVo2);
                BeanUtils.copyProperties(confClassifiedDetailsVo, confClassifiedAndDetailsVo2);
                confClassifiedAndDetailsVo2.setClassifiedId(confClassifiedAndDetailsVo.getClassifiedId());
                confClassifiedAndDetailsVo2.setClassifiedDetailsId(confClassifiedDetails1.getId());
                if (confClassified.getSecrecyTermType() == 1 ||
                        confClassified.getSecrecyTermType() == 2 ||
                        confClassified.getSecrecyTermType() == 3) {
                    Date date1 = DateUtils.addYearOrMonth(confClassified.getIssueDate(), confClassified.getSecrecyTermType(), Integer.parseInt(confClassified.getSecrecyTermContent()));
                    confClassified.setClassifiedExpire(date1);
                } else if (confClassified.getSecrecyTermType() == 6){
                    boolean b = TimeUtils.validDateEffecitive(confClassified.getSecrecyTermContent());
                    if (b) {
                        Date date1 = TimeUtils.stringToDate(confClassified.getSecrecyTermContent());
                        confClassified.setClassifiedExpire(date1);
                    }
                }
                // 子表(如果是采购，需要传备案信息)
                confClassifiedDetailsVo.setPurchaseItemName(confClassifiedAndDetailsVo.getPurchaseItemName());
                confClassifiedDetailsVo.setPurchasingUnit(confClassifiedAndDetailsVo.getPurchasingUnit());
                confClassifiedDetailsVo.setProjectContent(confClassifiedAndDetailsVo.getProjectContent());
                confClassifiedDetailsVo.setLeaderOpinion(confClassifiedAndDetailsVo.getLeaderOpinion());
                ConfClassifiedDetails confClassifiedDetails = new ConfClassifiedDetails();
                confClassifiedDetails.setId(confClassifiedAndDetailsVo2.getClassifiedDetailsId());
                confClassifiedDetails.setClassifiedId(confClassifiedAndDetailsVo2.getClassifiedId());
                confClassifiedDetails.setClassifiedContent(JSONObject.toJSONString(confClassifiedDetailsVo));

                // 操作记录
                LogUtils.addOperationRecord(confClassified.getId(),"定密审核通过时间",date,MyThreadLocal.get().getId(),MyThreadLocal.get().getUserName(),MyThreadLocal.get().getUnitNameTwo());
                confClassifiedDao.save(confClassified);
                confClassifiedDetailsDao.save(confClassifiedDetails);
            } else {
                throw new BizException("定密信息不存在");
            }
        } else {
            throw new BizException("定密信息不存在");
        }
    }

    @Override
    @Scheduled(cron = "0 0 4 * * ?")
    @Transactional(rollbackOn = Exception.class)
    public void classifiedActuator() {
        Date date = new Date();
        List<ConfClassified> confClassifiedList = confClassifiedDao.findAllByChangeStatus(1);
        List<ConfClassified> newConfClassifiedList = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ConfClassified confClassified : confClassifiedList) {
            if (sdf.format(confClassified.getIssueDate()).equals(sdf.format(date))) {
                if (confClassified.getSecrecyTermType() != 3) {
                    Date date1 = DateUtils.addYearOrMonth(confClassified.getIssueDate(), confClassified.getSecrecyTermType(), Integer.parseInt(confClassified.getSecrecyTermContent()));
                    confClassified.setClassifiedExpire(date1);
                } else {
                    boolean b = TimeUtils.validDateEffecitive(confClassified.getSecrecyTermContent());
                    if (b) {
                        Date date1 = TimeUtils.stringToDate(confClassified.getSecrecyTermContent());
                        confClassified.setClassifiedExpire(date1);
                    }
                }
                confClassified.setChangeStatus(2);
                newConfClassifiedList.add(confClassified);
            }
        }
        confClassifiedDao.saveAll(newConfClassifiedList);
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void initManage() {
        Date date = new Date();
        // 新增参数配置
        List<ConfManage> confManageList = new ArrayList<>();
        ConfManage confManage = new ConfManage("1","密级",date);
        ConfManage confManage2 = new ConfManage("2","缓急程度",date);
        ConfManage confManage3 = new ConfManage("3","采购单位",date);
        ConfManage confManage4 = new ConfManage("4","提醒期限（月）",date);
        ConfManage confManage5 = new ConfManage("5","提醒期限（年）",date);
        confManageList.add(confManage);
        confManageList.add(confManage2);
        confManageList.add(confManage3);
        confManageList.add(confManage4);
        confManageList.add(confManage5);

        // 新增参数配置详情
        List<ConfManageDetail> confManageDetailList = new ArrayList<>();
        ConfManageDetail confManageDetail = new ConfManageDetail("1","1","内部",1);
        ConfManageDetail confManageDetail2 = new ConfManageDetail("2","1","秘密",2);
        ConfManageDetail confManageDetail3 = new ConfManageDetail("3","1","机密",3);
        ConfManageDetail confManageDetail4 = new ConfManageDetail("4","1","绝密",4);
        ConfManageDetail confManageDetail5 = new ConfManageDetail("5","2","无需加急",1);
        ConfManageDetail confManageDetail6 = new ConfManageDetail("6","2","加急",2);
        ConfManageDetail confManageDetail7 = new ConfManageDetail("7","2","特急",3);
        ConfManageDetail confManageDetail8 = new ConfManageDetail("8","3","单位1",1);
        ConfManageDetail confManageDetail9 = new ConfManageDetail("9","3","单位2",2);
        ConfManageDetail confManageDetail10 = new ConfManageDetail("10","4","6",1);
        ConfManageDetail confManageDetail11 = new ConfManageDetail("11","5","2",1);
        confManageDetailList.add(confManageDetail);
        confManageDetailList.add(confManageDetail2);
        confManageDetailList.add(confManageDetail3);
        confManageDetailList.add(confManageDetail4);
        confManageDetailList.add(confManageDetail5);
        confManageDetailList.add(confManageDetail6);
        confManageDetailList.add(confManageDetail7);
        confManageDetailList.add(confManageDetail8);
        confManageDetailList.add(confManageDetail9);
        confManageDetailList.add(confManageDetail10);
        confManageDetailList.add(confManageDetail11);

        confManageDao.saveAll(confManageList);
        confManageDetailDao.saveAll(confManageDetailList);
    }

    @Override
    public ConfClassifiedOptionsVo findOption() {
        ConfClassifiedOptionsVo confClassifiedOptionsVo = new ConfClassifiedOptionsVo();
        // 查询所有常用语
        List<ConfManageDetail> all = confManageDetailDao.findAll();
        // 按配置主表id分组
        Map<String, List<ConfManageDetail>> collect = all.stream().collect(Collectors.groupingBy(ConfManageDetail::getManageId));
        confClassifiedOptionsVo.setSprList(collect.getOrDefault("7",new ArrayList<>()));
        confClassifiedOptionsVo.setZxfwList(collect.getOrDefault("8",new ArrayList<>()));
        confClassifiedOptionsVo.setFgldList(collect.getOrDefault("9",new ArrayList<>()));
        confClassifiedOptionsVo.setDwbmhxzList(collect.getOrDefault("10",new ArrayList<>()));
        confClassifiedOptionsVo.setDmzrrList(collect.getOrDefault("11",new ArrayList<>()));
        confClassifiedOptionsVo.setBmshList(collect.getOrDefault("12",new ArrayList<>()));
        confClassifiedOptionsVo.setCbrList(collect.getOrDefault("13",new ArrayList<>()));
        return confClassifiedOptionsVo;

    }

    @Override
    public ConfClassifiedVo findAllClassifiedPagingByDpNodeId(ConfClassifiedPageTwoVo confClassifiedPageTwoVo) {
        List<String> unitIdList = getUnitIdList(confClassifiedPageTwoVo.getNodeId());
        PredicateBuilder<ConfClassified> confClassifiedBuilder = Specifications.and();
        confClassifiedBuilder.eq("secretType", 3);
        confClassifiedBuilder.in("operatorUnit", unitIdList);
        Sort sort = Sort.by(Sort.Direction.DESC, "updateTime");
        PageRequest pageRequest = PageRequest.of(confClassifiedPageTwoVo.getCurrentPage() - 1, confClassifiedPageTwoVo.getPageSize(), sort);
        Page<ConfClassified> confClassifiedPage = confClassifiedDao.findAll(confClassifiedBuilder.build(), pageRequest);
        List<ConfClassified> confClassifiedList = new ArrayList<>(confClassifiedPage.getContent());
        ConfClassifiedVo confClassifiedVo = new ConfClassifiedVo();
        confClassifiedVo.setConfClassifiedList(confClassifiedList);
        confClassifiedVo.setTotalPage(confClassifiedPage.getTotalElements());
        return confClassifiedVo;
    }

    @Override
    public ConfClassifiedVo findAllClassifiedPagingByDpUnitId(ConfClassifiedPageThreeVo confClassifiedPageThreeVo) {
        PredicateBuilder<ConfClassified> confClassifiedBuilder = Specifications.and();
        confClassifiedBuilder.eq("secretType", 3);
        if (StringUtils.isEmpty(confClassifiedPageThreeVo.getUnitId())) {
            confClassifiedPageThreeVo.setUnitId(MyThreadLocal.get().getUnitId());
        }
        confClassifiedBuilder.eq("operatorUnit", confClassifiedPageThreeVo.getUnitId());
        Sort sort = Sort.by(Sort.Direction.DESC, "updateTime");
        PageRequest pageRequest = PageRequest.of(confClassifiedPageThreeVo.getCurrentPage() - 1, confClassifiedPageThreeVo.getPageSize(), sort);
        Page<ConfClassified> confClassifiedPage = confClassifiedDao.findAll(confClassifiedBuilder.build(), pageRequest);
        List<ConfClassified> confClassifiedList = new ArrayList<>(confClassifiedPage.getContent());
        ConfClassifiedVo confClassifiedVo = new ConfClassifiedVo();
        confClassifiedVo.setConfClassifiedList(confClassifiedList);
        confClassifiedVo.setTotalPage(confClassifiedPage.getTotalElements());
        return confClassifiedVo;
    }

    // ================================================= 以下为私有方法调用 =================================================

    // 根据节点id获取节点id下面所有的节点并得到所有单位
    private List<String> getUnitIdList(String nodeId) {
        List<String> unitIdList = new ArrayList<>();
        if (StringUtils.isNotEmpty(nodeId)) {
            if (nodeId.equals("0")) { // 选杭州市
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    unitIdList = dataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            } else {
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    String sql = "from ConfUnitNode  where nodeRelationship like '%"+ nodeId +"%'";
                    // 获取到所有叶子节点和当前节点
                    List<ConfUnitNode> all = entityManager.createQuery(sql).getResultList();
                    // 查询所有单位
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    List<ConfUnitNode> unitNodeList = new ArrayList<>();
                    List<DataUnit> newDataUnitList = new ArrayList<>();
                    List<DataUnit> allDataUnitList = new ArrayList<>();
                    for (ConfUnitNode confUnitNode : all) {
                        // 只要是单位节点,就去匹配所有单位
                        if (confUnitNode.getIsUnitNode()) {
                            if (confUnitNode.getUnitType().equals("全部")) {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()))
                                        .collect(Collectors.toList());
                            } else {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()) &&
                                                dataUnit.getUnitNature().equals(confUnitNode.getUnitType()))
                                        .collect(Collectors.toList());
                            }
                        }
                        // 查询出所有匹配的单位并存入进去
                        allDataUnitList.addAll(newDataUnitList);
                    }
                    unitIdList = allDataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    unitIdList = unitIdList.stream().distinct().collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            }
        } else {
            throw new BizException("请选择节点!");
        }
    }

    /**
     * 动态条件构建
     */
    private Specification<ConfClassified> createSpecification(Date date,Date date2,String unitId,Integer sm) {
        return new Specification<ConfClassified>() {
            @Override
            public Predicate toPredicate(Root<ConfClassified> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                List<Predicate> predicateList = new ArrayList<Predicate>();
                List<Integer> list;
                Expression<Integer> exp = root.<Integer>get("classificationSortNum");
                predicateList.add(cb.between(root.get("issueDate").as(Date.class),date ,date2));
                if (!unitId.equals(code)) {
                    predicateList.add(cb.equal(root.get("operatorUnit").as(String.class),unitId));
                }
                if (sm == 3) {
                    list = Arrays.asList(1, 2, 3,4);
                } else if (sm == 2) {
                    list = Arrays.asList(1, 2, 3);
                } else if (sm == 1) {
                    list = Arrays.asList(1, 2);
                } else {
                    list = Arrays.asList();
                }
                predicateList.add(exp.in(list)); // 往in中添加所有id 实现in 查询
                if (predicateList.size() != 0) {
                    Predicate[] p = new Predicate[predicateList.size()];
                    return cb.and(predicateList.toArray(p));
                } else {
                    return null;
                }
            }
        };
    }

    /**
     * 动态条件构建
     */
    private Specification<ConfClassifiedDecrypt> createSpecification2(Date date,Date date2,List<String> classifiedIdList,String unitId,Integer sm) {
        return new Specification<ConfClassifiedDecrypt>() {
            @Override
            public Predicate toPredicate(Root<ConfClassifiedDecrypt> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                List<Predicate> predicateList = new ArrayList<Predicate>();
//                List<Integer> list;
//                Expression<Integer> exp = root.<Integer>get("afterClassificationSortNum");
                Expression<Integer> exp = root.<Integer>get("classifiedId");
                predicateList.add(cb.between(root.get("decryptTime").as(Date.class),date ,date2));
                if (!unitId.equals(code)) {
                    predicateList.add(cb.equal(root.get("operatorUnit").as(String.class),unitId));
                }
                if (classifiedIdList.size() > 0) {
                    predicateList.add(exp.in(classifiedIdList)); // 往in中添加所有id 实现in 查询
                }
//                if (sm == 3) {
//                    list = Arrays.asList(1, 2, 3,4);
//                } else if (sm == 2) {
//                    list = Arrays.asList(1, 2, 3);
//                } else if (sm == 1) {
//                    list = Arrays.asList(1, 2);
//                } else {
//                    list = Arrays.asList();
//                }
//                predicateList.add(exp.in(list)); // 往in中添加所有id 实现in 查询

                if (predicateList.size() != 0) {
                    Predicate[] p = new Predicate[predicateList.size()];
                    return cb.and(predicateList.toArray(p));
                } else {
                    return null;
                }
            }
        };
    }
}
