package com.tykj.classified.service.impl;


import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfClassifiedSystemDao;
import com.tykj.classified.dao.db1.DataUnitDao;
import com.tykj.classified.entity.db1.ConfClassifiedSystem;
import com.tykj.classified.entity.db1.ConfUnitNode;
import com.tykj.classified.entity.db1.DataUnit;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedSystemService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ConfClassifiedSystemServiceImpl implements ConfClassifiedSystemService {

    private final ConfClassifiedSystemDao confClassifiedSystemDao;

    private final IdWorker idWorker;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    EntityManager entityManager;

    private final ApplicationContext applicationContext;

    private final DataUnitDao dataUnitDao;

    public ConfClassifiedSystemServiceImpl(ApplicationContext applicationContext, DataUnitDao dataUnitDao, ConfClassifiedSystemDao confClassifiedSystemDao, IdWorker idWorker) {
        this.applicationContext = applicationContext;
        this.dataUnitDao = dataUnitDao;
        this.confClassifiedSystemDao = confClassifiedSystemDao;
        this.idWorker = idWorker;
        Map<String, EntityManager> beansOfType = this.applicationContext.getBeansOfType(EntityManager.class);
        for (String s : beansOfType.keySet()) {
            EntityManager entityManagerIndex = beansOfType.get(s);
            String persistenceUnitName = entityManagerIndex.getEntityManagerFactory().getProperties().get("hibernate.ejb.persistenceUnitName").toString();
            if (persistenceUnitName.equals("mysqlPersistenceUnit")) {
                entityManager = entityManagerIndex;
            }
        }
    }

    @Override
    public ConfClassifiedSystemVo findAllClassifiedSystemPaging(ConfClassifiedSystemPageVo confClassifiedSystemPageVo) {
        ConfClassifiedSystemVo confClassifiedSystemVo = new ConfClassifiedSystemVo();

        //创建查询条件
        PredicateBuilder<ConfClassifiedSystem> confClassifiedSystemPredicateBuilder = Specifications.and();
//        if (!MyThreadLocal.get().getUnitId().equals(code)) {
//            confClassifiedSystemPredicateBuilder.eq("fillingUnitId",MyThreadLocal.get().getUnitId());
//        }
        confClassifiedSystemPredicateBuilder.eq("fillingUnitId",MyThreadLocal.get().getUnitIdTwo());
        confClassifiedSystemPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedSystemPageVo.getCurrentPage() - 1, confClassifiedSystemPageVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedSystem> confClassifiedSystemPage = confClassifiedSystemDao.findAll(confClassifiedSystemPredicateBuilder.build(), pageRequest);
        confClassifiedSystemVo.setConfClassifiedSystemList(confClassifiedSystemPage.getContent());
        confClassifiedSystemVo.setTotalPage(confClassifiedSystemPage.getTotalElements());
        return confClassifiedSystemVo;
    }

    @Override
    public void addConfClassifiedSystem(ConfClassifiedSystemAddVo confClassifiedSystemAddVo) {
        Date date = new Date();
        ConfClassifiedSystem confClassifiedSystem = new ConfClassifiedSystem();
        if (StringUtils.isNotEmpty(confClassifiedSystemAddVo.getId())) { // 修改
            Optional<ConfClassifiedSystem> byId = confClassifiedSystemDao.findById(confClassifiedSystemAddVo.getId());
            if (!byId.isPresent()) {
                throw new BizException("dm制度信息不存在");
            }
            confClassifiedSystem = byId.get();
            confClassifiedSystem.setAuthUnitId(confClassifiedSystemAddVo.getAuthUnitId());
            confClassifiedSystem.setAuthUnit(confClassifiedSystemAddVo.getAuthUnit());
            confClassifiedSystem.setFileName(confClassifiedSystemAddVo.getFileName());
            confClassifiedSystem.setDocumentNo(confClassifiedSystemAddVo.getDocumentNo());
            confClassifiedSystem.setIssueTime(confClassifiedSystemAddVo.getIssueTime());
            confClassifiedSystem.setImplementationTime(confClassifiedSystemAddVo.getImplementationTime());
            confClassifiedSystem.setDes(confClassifiedSystemAddVo.getDes());
            confClassifiedSystem.setUpdateTime(date);
            confClassifiedSystem.setDeleteStatus(0);
            confClassifiedSystemDao.save(confClassifiedSystem);
        } else { // 新增
            BeanUtils.copyProperties(confClassifiedSystemAddVo,confClassifiedSystem);
            confClassifiedSystem.setId(idWorker.nextId() + "");
            confClassifiedSystem.setFillingPersonId(MyThreadLocal.get().getId());
            confClassifiedSystem.setFillingPerson(MyThreadLocal.get().getUserName());
            confClassifiedSystem.setFillingTime(date);
            confClassifiedSystem.setFillingUnitId(MyThreadLocal.get().getUnitIdTwo());
            confClassifiedSystem.setFillingUnit(MyThreadLocal.get().getUnitNameTwo());
            confClassifiedSystem.setCreateTime(date);
            confClassifiedSystem.setUpdateTime(date);
            confClassifiedSystem.setDeleteStatus(0);
            confClassifiedSystemDao.save(confClassifiedSystem);
        }
    }

    @Override
    public void deleteConfClassifiedSystem(String id) {
        if (StringUtils.isNotEmpty(id)) {
            Optional<ConfClassifiedSystem> byId = confClassifiedSystemDao.findById(id);
            if (!byId.isPresent()) {
                throw new BizException("dm制度信息不存在");
            }
            ConfClassifiedSystem confClassifiedSystem = byId.get();
            confClassifiedSystem.setDeleteStatus(1);
            confClassifiedSystemDao.save(confClassifiedSystem);
        } else {
            throw new BizException("dm制度信息不存在");
        }
    }

    @Override
    public ConfClassifiedSystemVo findAllClassifiedSystemPagingByDpNodeId(ConfClassifiedSystemPageTwoVo confClassifiedSystemPageTwoVo) {
        List<String> unitIdList = getUnitIdList(confClassifiedSystemPageTwoVo.getNodeId());
        ConfClassifiedSystemVo confClassifiedSystemVo = new ConfClassifiedSystemVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedSystem> confClassifiedSystemPredicateBuilder = Specifications.and();

        confClassifiedSystemPredicateBuilder.in("fillingUnitId",unitIdList);

        confClassifiedSystemPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedSystemPageTwoVo.getCurrentPage() - 1, confClassifiedSystemPageTwoVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedSystem> confClassifiedSystemPage = confClassifiedSystemDao.findAll(confClassifiedSystemPredicateBuilder.build(), pageRequest);
        confClassifiedSystemVo.setConfClassifiedSystemList(confClassifiedSystemPage.getContent());
        confClassifiedSystemVo.setTotalPage(confClassifiedSystemPage.getTotalElements());
        return confClassifiedSystemVo;

    }

    @Override
    public ConfClassifiedSystemVo findAllClassifiedSystemPagingByDpUnitId(ConfClassifiedSystemPageThreeVo confClassifiedSystemPageThreeVo) {
        ConfClassifiedSystemVo confClassifiedSystemVo = new ConfClassifiedSystemVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedSystem> confClassifiedSystemPredicateBuilder = Specifications.and();
        if (StringUtils.isEmpty(confClassifiedSystemPageThreeVo.getUnitId())) {
            confClassifiedSystemPageThreeVo.setUnitId(MyThreadLocal.get().getUnitId());
        }
        confClassifiedSystemPredicateBuilder.eq("fillingUnitId",confClassifiedSystemPageThreeVo.getUnitId());
        confClassifiedSystemPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedSystemPageThreeVo.getCurrentPage() - 1, confClassifiedSystemPageThreeVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedSystem> confClassifiedSystemPage = confClassifiedSystemDao.findAll(confClassifiedSystemPredicateBuilder.build(), pageRequest);
        confClassifiedSystemVo.setConfClassifiedSystemList(confClassifiedSystemPage.getContent());
        confClassifiedSystemVo.setTotalPage(confClassifiedSystemPage.getTotalElements());
        return confClassifiedSystemVo;
    }

    // 根据节点id获取节点id下面所有的节点并得到所有单位
    private List<String> getUnitIdList(String nodeId) {
        List<String> unitIdList = new ArrayList<>();
        if (StringUtils.isNotEmpty(nodeId)) {
            if (nodeId.equals("0")) { // 选杭州市
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    unitIdList = dataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            } else {
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    String sql = "from ConfUnitNode  where nodeRelationship like '%"+ nodeId +"%'";
                    // 获取到所有叶子节点和当前节点
                    List<ConfUnitNode> all = entityManager.createQuery(sql).getResultList();
                    // 查询所有单位
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    List<ConfUnitNode> unitNodeList = new ArrayList<>();
                    List<DataUnit> newDataUnitList = new ArrayList<>();
                    List<DataUnit> allDataUnitList = new ArrayList<>();
                    for (ConfUnitNode confUnitNode : all) {
                        // 只要是单位节点,就去匹配所有单位
                        if (confUnitNode.getIsUnitNode()) {
                            if (confUnitNode.getUnitType().equals("全部")) {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()))
                                        .collect(Collectors.toList());
                            } else {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()) &&
                                                dataUnit.getUnitNature().equals(confUnitNode.getUnitType()))
                                        .collect(Collectors.toList());
                            }
                        }
                        // 查询出所有匹配的单位并存入进去
                        allDataUnitList.addAll(newDataUnitList);
                    }
                    unitIdList = allDataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    unitIdList = unitIdList.stream().distinct().collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            }
        } else {
            throw new BizException("请选择节点!");
        }
    }
}
