package com.tykj.classified.service.impl;


import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfClassifiedTrainingDao;
import com.tykj.classified.dao.db1.DataUnitDao;
import com.tykj.classified.entity.db1.ConfClassifiedTraining;
import com.tykj.classified.entity.db1.ConfUnitNode;
import com.tykj.classified.entity.db1.DataUnit;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedTrainingService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ConfClassifiedTrainingServiceImpl implements ConfClassifiedTrainingService {

    private final ConfClassifiedTrainingDao confClassifiedTrainingDao;

    private final IdWorker idWorker;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    EntityManager entityManager;

    private final ApplicationContext applicationContext;

    private final DataUnitDao dataUnitDao;

    public ConfClassifiedTrainingServiceImpl(ConfClassifiedTrainingDao confClassifiedTrainingDao, IdWorker idWorker, ApplicationContext applicationContext, DataUnitDao dataUnitDao) {
        this.confClassifiedTrainingDao = confClassifiedTrainingDao;
        this.idWorker = idWorker;
        this.applicationContext = applicationContext;
        this.dataUnitDao = dataUnitDao;
        Map<String, EntityManager> beansOfType = this.applicationContext.getBeansOfType(EntityManager.class);
        for (String s : beansOfType.keySet()) {
            EntityManager entityManagerIndex = beansOfType.get(s);
            String persistenceUnitName = entityManagerIndex.getEntityManagerFactory().getProperties().get("hibernate.ejb.persistenceUnitName").toString();
            if (persistenceUnitName.equals("mysqlPersistenceUnit")) {
                entityManager = entityManagerIndex;
            }
        }
    }

    @Override
    public ConfClassifiedTrainingVo findAllClassifiedTrainingPaging(ConfClassifiedTrainingPageVo confClassifiedTrainingPageVo) {
        ConfClassifiedTrainingVo confClassifiedTrainingVo = new ConfClassifiedTrainingVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedTraining> confClassifiedTrainingPredicateBuilder = Specifications.and();
//        if (!MyThreadLocal.get().getUnitId().equals(code)) {
//            confClassifiedTrainingPredicateBuilder.eq("fillingUnitId",MyThreadLocal.get().getUnitId());
//        }
        confClassifiedTrainingPredicateBuilder.eq("fillingUnitId",MyThreadLocal.get().getUnitIdTwo());
        confClassifiedTrainingPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedTrainingPageVo.getCurrentPage() - 1, confClassifiedTrainingPageVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedTraining> confClassifiedTrainingPage = confClassifiedTrainingDao.findAll(confClassifiedTrainingPredicateBuilder.build(), pageRequest);
        confClassifiedTrainingVo.setConfClassifiedTrainingList(confClassifiedTrainingPage.getContent());
        confClassifiedTrainingVo.setTotalPage(confClassifiedTrainingPage.getTotalElements());
        return confClassifiedTrainingVo;

    }

    @Override
    public void addConfClassifiedTraining(ConfClassifiedTrainingAddVo confClassifiedTrainingAddVo) {
        Date date = new Date();
        ConfClassifiedTraining confClassifiedTraining = new ConfClassifiedTraining();
        if (StringUtils.isNotEmpty(confClassifiedTrainingAddVo.getId())) { // 修改
            Optional<ConfClassifiedTraining> byId = confClassifiedTrainingDao.findById(confClassifiedTrainingAddVo.getId());
            if (!byId.isPresent()) {
                throw new BizException("dm制度信息不存在");
            }
            confClassifiedTraining = byId.get();
            confClassifiedTraining.setAuthUnitId(confClassifiedTrainingAddVo.getAuthUnitId());
            confClassifiedTraining.setAuthUnit(confClassifiedTrainingAddVo.getAuthUnit());
            confClassifiedTraining.setTrainingTime(confClassifiedTrainingAddVo.getTrainingTime());
            confClassifiedTraining.setCreditHours(confClassifiedTrainingAddVo.getCreditHours());
            confClassifiedTraining.setTrainingPersonNum(confClassifiedTrainingAddVo.getTrainingPersonNum());
            confClassifiedTraining.setTrainingObjectId(confClassifiedTrainingAddVo.getTrainingObjectId());
            confClassifiedTraining.setTrainingObject(confClassifiedTrainingAddVo.getTrainingObject());
            confClassifiedTraining.setDes(confClassifiedTrainingAddVo.getDes());
            confClassifiedTraining.setUpdateTime(date);
            confClassifiedTraining.setDeleteStatus(0);
            confClassifiedTrainingDao.save(confClassifiedTraining);
        } else { // 新增
            BeanUtils.copyProperties(confClassifiedTrainingAddVo,confClassifiedTraining);
            confClassifiedTraining.setId(idWorker.nextId() + "");
            confClassifiedTraining.setFillingPersonId(MyThreadLocal.get().getId());
            confClassifiedTraining.setFillingPerson(MyThreadLocal.get().getUserName());
            confClassifiedTraining.setFillingTime(date);
            confClassifiedTraining.setFillingUnitId(MyThreadLocal.get().getUnitIdTwo());
            confClassifiedTraining.setFillingUnit(MyThreadLocal.get().getUnitNameTwo());
            confClassifiedTraining.setCreateTime(date);
            confClassifiedTraining.setUpdateTime(date);
            confClassifiedTraining.setDeleteStatus(0);
            confClassifiedTrainingDao.save(confClassifiedTraining);
        }
    }

    @Override
    public void deleteConfClassifiedTraining(String id) {
        if (StringUtils.isNotEmpty(id)) {
            Optional<ConfClassifiedTraining> byId = confClassifiedTrainingDao.findById(id);
            if (!byId.isPresent()) {
                throw new BizException("dm制度信息不存在");
            }
            ConfClassifiedTraining confClassifiedTraining = byId.get();
            confClassifiedTraining.setDeleteStatus(1);
            confClassifiedTrainingDao.save(confClassifiedTraining);
        } else {
            throw new BizException("dm制度信息不存在");
        }
    }

    @Override
    public ConfClassifiedTrainingVo findAllClassifiedTrainingPagingByDpNodeId(ConfClassifiedTrainingPageTwoVo confClassifiedTrainingPageTwoVo) {
        List<String> unitIdList = getUnitIdList(confClassifiedTrainingPageTwoVo.getNodeId());
        ConfClassifiedTrainingVo confClassifiedTrainingVo = new ConfClassifiedTrainingVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedTraining> confClassifiedTrainingPredicateBuilder = Specifications.and();
        confClassifiedTrainingPredicateBuilder.in("fillingUnitId",unitIdList);
        confClassifiedTrainingPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");
        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedTrainingPageTwoVo.getCurrentPage() - 1, confClassifiedTrainingPageTwoVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedTraining> confClassifiedTrainingPage = confClassifiedTrainingDao.findAll(confClassifiedTrainingPredicateBuilder.build(), pageRequest);
        confClassifiedTrainingVo.setConfClassifiedTrainingList(confClassifiedTrainingPage.getContent());
        confClassifiedTrainingVo.setTotalPage(confClassifiedTrainingPage.getTotalElements());
        return confClassifiedTrainingVo;
    }

    @Override
    public ConfClassifiedTrainingVo findAllClassifiedTrainingPagingByDpUnitId(ConfClassifiedTrainingPageThreeVo confClassifiedTrainingPageThreeVo) {
        ConfClassifiedTrainingVo confClassifiedTrainingVo = new ConfClassifiedTrainingVo();

        //创建查询条件 市看所有，区看自己单位下的
        PredicateBuilder<ConfClassifiedTraining> confClassifiedTrainingPredicateBuilder = Specifications.and();
        if (StringUtils.isEmpty(confClassifiedTrainingPageThreeVo.getUnitId())) {
            confClassifiedTrainingPageThreeVo.setUnitId(MyThreadLocal.get().getUnitId());
        }
        confClassifiedTrainingPredicateBuilder.eq("fillingUnitId",confClassifiedTrainingPageThreeVo.getUnitId());
        confClassifiedTrainingPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedTrainingPageThreeVo.getCurrentPage() - 1, confClassifiedTrainingPageThreeVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedTraining> confClassifiedTrainingPage = confClassifiedTrainingDao.findAll(confClassifiedTrainingPredicateBuilder.build(), pageRequest);
        confClassifiedTrainingVo.setConfClassifiedTrainingList(confClassifiedTrainingPage.getContent());
        confClassifiedTrainingVo.setTotalPage(confClassifiedTrainingPage.getTotalElements());
        return confClassifiedTrainingVo;
    }

    // 根据节点id获取节点id下面所有的节点并得到所有单位
    private List<String> getUnitIdList(String nodeId) {
        List<String> unitIdList = new ArrayList<>();
        if (StringUtils.isNotEmpty(nodeId)) {
            if (nodeId.equals("0")) { // 选杭州市
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    unitIdList = dataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            } else {
                if (MyThreadLocal.get().getUnitId().equals(code)) {
                    String sql = "from ConfUnitNode  where nodeRelationship like '%"+ nodeId +"%'";
                    // 获取到所有叶子节点和当前节点
                    List<ConfUnitNode> all = entityManager.createQuery(sql).getResultList();
                    // 查询所有单位
                    List<DataUnit> dataUnitList = dataUnitDao.findAll();
                    List<ConfUnitNode> unitNodeList = new ArrayList<>();
                    List<DataUnit> newDataUnitList = new ArrayList<>();
                    List<DataUnit> allDataUnitList = new ArrayList<>();
                    for (ConfUnitNode confUnitNode : all) {
                        // 只要是单位节点,就去匹配所有单位
                        if (confUnitNode.getIsUnitNode()) {
                            if (confUnitNode.getUnitType().equals("全部")) {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()))
                                        .collect(Collectors.toList());
                            } else {
                                newDataUnitList = dataUnitList.stream()
                                        .filter(dataUnit -> dataUnit.getUnitArea().equals(confUnitNode.getUnitTerritoryId()) &&
                                                dataUnit.getUnitNature().equals(confUnitNode.getUnitType()))
                                        .collect(Collectors.toList());
                            }
                        }
                        // 查询出所有匹配的单位并存入进去
                        allDataUnitList.addAll(newDataUnitList);
                    }
                    unitIdList = allDataUnitList.stream().map(DataUnit::getUnitId).collect(Collectors.toList());
                    unitIdList = unitIdList.stream().distinct().collect(Collectors.toList());
                    return unitIdList;
                } else {
                    unitIdList.add(MyThreadLocal.get().getUnitId());
                    return unitIdList;
                }
            }
        } else {
            throw new BizException("请选择节点!");
        }
    }
}
