package com.tykj.classified.service.impl;


import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfClassifiedUnclearMattersDao;
import com.tykj.classified.entity.db1.ConfClassifiedUnclearMatters;
import com.tykj.classified.entity.vo.ConfClassifiedUnclearMattersAddVo;
import com.tykj.classified.entity.vo.ConfClassifiedUnclearMattersPageVo;
import com.tykj.classified.entity.vo.ConfClassifiedUnclearMattersVo;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfClassifiedUnclearMattersService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Optional;

@Slf4j
@Service
public class ConfClassifiedUnclearMattersServiceImpl implements ConfClassifiedUnclearMattersService {

    @Autowired
    private ConfClassifiedUnclearMattersDao confClassifiedUnclearMattersDao;

    @Autowired
    private IdWorker idWorker;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    @Override
    public ConfClassifiedUnclearMattersVo findAllClassifiedUnclearMattersPaging(ConfClassifiedUnclearMattersPageVo confClassifiedUnclearMattersPageVo) {
        ConfClassifiedUnclearMattersVo confClassifiedUnclearMattersVo = new ConfClassifiedUnclearMattersVo();

        //创建查询条件
        PredicateBuilder<ConfClassifiedUnclearMatters> confClassifiedUnclearMattersPredicateBuilder = Specifications.and();
//        if (!MyThreadLocal.get().getUnitId().equals(code)) {
//            confClassifiedUnclearMattersPredicateBuilder.eq("fillingUnitId", MyThreadLocal.get().getUnitId());
//        }
        confClassifiedUnclearMattersPredicateBuilder.eq("fillingUnitId", MyThreadLocal.get().getUnitIdTwo());
        confClassifiedUnclearMattersPredicateBuilder.eq("deleteStatus",0);
        //创建查询顺序(默认为按照更新时间顺序)
        Sort sort = Sort.by(Sort.Direction.DESC, "fillingTime");

        //创建查询页码
        PageRequest pageRequest = PageRequest.of(confClassifiedUnclearMattersPageVo.getCurrentPage() - 1, confClassifiedUnclearMattersPageVo.getPageSize(), sort);

        //进行查询并转换为返回的类型
        Page<ConfClassifiedUnclearMatters> confClassifiedUnclearMattersPage = confClassifiedUnclearMattersDao.findAll(confClassifiedUnclearMattersPredicateBuilder.build(), pageRequest);
        confClassifiedUnclearMattersVo.setConfClassifiedUnclearMattersList(confClassifiedUnclearMattersPage.getContent());
        confClassifiedUnclearMattersVo.setTotalPage(confClassifiedUnclearMattersPage.getTotalElements());
        return confClassifiedUnclearMattersVo;
    }

    @Override
    public void addConfClassifiedUnclearMatters(ConfClassifiedUnclearMattersAddVo confClassifiedUnclearMattersAddVo) {
        Date date = new Date();
        ConfClassifiedUnclearMatters confClassifiedUnclearMatters = new ConfClassifiedUnclearMatters();
        if (StringUtils.isNotEmpty(confClassifiedUnclearMattersAddVo.getId())) { // 修改
            Optional<ConfClassifiedUnclearMatters> byId = confClassifiedUnclearMattersDao.findById(confClassifiedUnclearMattersAddVo.getId());
            if (!byId.isPresent()) {
                throw new BizException("不明确事项确定情况不存在");
            }
            confClassifiedUnclearMatters = byId.get();
            confClassifiedUnclearMatters.setAuthUnitId(confClassifiedUnclearMattersAddVo.getAuthUnitId());
            confClassifiedUnclearMatters.setAuthUnit(confClassifiedUnclearMattersAddVo.getAuthUnit());
            confClassifiedUnclearMatters.setItemName(confClassifiedUnclearMattersAddVo.getItemName());
            confClassifiedUnclearMatters.setClassificationId(confClassifiedUnclearMattersAddVo.getClassificationId());
            confClassifiedUnclearMatters.setClassification(confClassifiedUnclearMattersAddVo.getClassification());
            confClassifiedUnclearMatters.setSecrecyTermContent(confClassifiedUnclearMattersAddVo.getSecrecyTermContent());
            confClassifiedUnclearMatters.setSureTime(confClassifiedUnclearMattersAddVo.getSureTime());
            confClassifiedUnclearMatters.setSureReason(confClassifiedUnclearMattersAddVo.getSureReason());
            confClassifiedUnclearMatters.setDes(confClassifiedUnclearMattersAddVo.getDes());
            confClassifiedUnclearMatters.setUpdateTime(date);
            confClassifiedUnclearMatters.setDeleteStatus(0);
            confClassifiedUnclearMattersDao.save(confClassifiedUnclearMatters);
        } else { // 新增
            BeanUtils.copyProperties(confClassifiedUnclearMattersAddVo, confClassifiedUnclearMatters);
            confClassifiedUnclearMatters.setId(idWorker.nextId() + "");
            confClassifiedUnclearMatters.setFillingPersonId(MyThreadLocal.get().getId());
            confClassifiedUnclearMatters.setFillingPerson(MyThreadLocal.get().getUserName());
            confClassifiedUnclearMatters.setFillingTime(date);
            confClassifiedUnclearMatters.setFillingUnitId(MyThreadLocal.get().getUnitIdTwo());
            confClassifiedUnclearMatters.setFillingUnit(MyThreadLocal.get().getUnitNameTwo());
            confClassifiedUnclearMatters.setCreateTime(date);
            confClassifiedUnclearMatters.setUpdateTime(date);
            confClassifiedUnclearMatters.setDeleteStatus(0);
            confClassifiedUnclearMattersDao.save(confClassifiedUnclearMatters);
        }
    }

    @Override
    public void deleteConfClassifiedUnclearMatters(String id) {
        if (StringUtils.isNotEmpty(id)) {
            Optional<ConfClassifiedUnclearMatters> byId = confClassifiedUnclearMattersDao.findById(id);
            if (!byId.isPresent()) {
                throw new BizException("不明确事项确定情况不存在");
            }
            ConfClassifiedUnclearMatters confClassifiedUnclearMatters = byId.get();
            confClassifiedUnclearMatters.setDeleteStatus(1);
            confClassifiedUnclearMattersDao.save(confClassifiedUnclearMatters);
        } else {
            throw new BizException("不明确事项确定情况不存在");
        }
    }
}
