package com.tykj.classified.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfManageDao;
import com.tykj.classified.dao.db1.ConfManageDetailDao;
import com.tykj.classified.entity.db1.ConfManage;
import com.tykj.classified.entity.db1.ConfManageDetail;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.service.ConfManageService;
import com.tykj.classified.utils.idwork.IdWorker;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@Slf4j
@Service
public class ConfManageServiceImpl implements ConfManageService {

    private final ConfManageDao confManageDao;

    private final ConfManageDetailDao confManageDetailDao;

    private final IdWorker idWorker;

    public ConfManageServiceImpl(ConfManageDao confManageDao, ConfManageDetailDao confManageDetailDao, IdWorker idWorker) {
        this.confManageDao = confManageDao;
        this.confManageDetailDao = confManageDetailDao;
        this.idWorker = idWorker;
    }

    @Override
    public ConfManageVo findManagePaging(ConfManagePageVo confManagePageVo) {
        ConfManageVo confManageVo = new ConfManageVo();
        PredicateBuilder<ConfManage> confManagePredicateBuilder = Specifications.and();
        confManagePredicateBuilder.ne("manageName","密级");
        confManagePredicateBuilder.like(confManagePageVo != null && confManagePageVo.getManageName() != null,"manageName","%" + confManagePageVo.getManageName() + "%");
        Sort sort = Sort.by(Sort.Direction.ASC, "updateTime");
        PageRequest pageRequest = PageRequest.of(confManagePageVo.getCurrentPage() - 1, confManagePageVo.getPageSize(), sort);
        Page<ConfManage> confManagePage = confManageDao.findAll(confManagePredicateBuilder.build(), pageRequest);
        confManageVo.setConfManageList(confManagePage.getContent());
        confManageVo.setTotalPage(confManagePage.getTotalElements());
        return confManageVo;
    }

    @Override
    public ConfManageDetailVo findManageDetail(String manageId) {
        ConfManage confManage = confManageDao.findConfManageById(manageId);
        if (confManage != null) {
            ConfManageDetailVo confManageDetailVo = new ConfManageDetailVo();
            List<ConfManageDetail> confManageDetailList = confManageDetailDao.findAllByManageIdOrderBySortNum(manageId);
            if (manageId.equals("4") || manageId.equals("5")) {
                if (confManageDetailList != null && confManageDetailList.size() > 0) {
                    List<ConfManageDetail> newConfManageDetailList = new ArrayList<>();
                    confManageDetailVo.setManageId(manageId);
                    confManageDetailVo.setManageName(confManage.getManageName());
                    newConfManageDetailList.add(confManageDetailList.get(0));
                    confManageDetailVo.setConfManageDetailList(newConfManageDetailList);
                } else {
                    ConfManageDetail confManageDetail = new ConfManageDetail();
                    confManageDetail.setId(idWorker.nextId() + "");
                    confManageDetail.setManageId(manageId);
                    if (manageId.equals("4")) {
                        confManageDetail.setManageOptions("6");
                    } else {
                        confManageDetail.setManageOptions("2");
                    }
                    confManageDetail.setSortNum(1);
                    List<ConfManageDetail> newConfManageDetailList = new ArrayList<>();
                    newConfManageDetailList.add(confManageDetail);
                    confManageDetailVo.setManageId(manageId);
                    confManageDetailVo.setManageName(confManage.getManageName());
                    confManageDetailVo.setConfManageDetailList(newConfManageDetailList);
                }
            } else {
                confManageDetailVo.setManageId(manageId);
                confManageDetailVo.setManageName(confManage.getManageName());
                confManageDetailVo.setConfManageDetailList(confManageDetailList);
            }
            return confManageDetailVo;
        } else {
            throw new BizException("该参数配置不存在");
        }
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void editManage(ConfManageEditVo confManageEditVo) {
        Date date = new Date();
        Optional<ConfManage> byId = confManageDao.findById(confManageEditVo.getManageId());
        if (!byId.isPresent()) {
            throw new BizException("参数不存在!");
        }
        ConfManage confManage = byId.get();
        confManage.setUpdateTime(date);
        confManageDetailDao.deleteByManageId(confManageEditVo.getManageId());
        List<ConfManageDetail> confManageDetailList = new ArrayList<>();
        ConfManageDetail confManageDetail;
        int sortNum = 1;
        for (ConfManageDetail manageDetail : confManageEditVo.getManageOptions()) {
            confManageDetail = new ConfManageDetail();
            confManageDetail.setId(idWorker.nextId() + "");
            confManageDetail.setManageId(confManageEditVo.getManageId());
            confManageDetail.setSortNum(sortNum);
            confManageDetail.setManageOptions(manageDetail.getManageOptions());
            confManageDetailList.add(confManageDetail);
            sortNum++;
        }
        confManageDetailDao.saveAll(confManageDetailList);
        confManageDao.save(confManage);
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public ConfRemindVo findRemind() {
        ConfRemindVo confRemindVo = new ConfRemindVo();
        List<ConfManageDetail> allByManageIdOrderBySortNum = confManageDetailDao.findAllByManageIdOrderBySortNum("4");
        List<ConfManageDetail> allByManageIdOrderBySortNum2 = confManageDetailDao.findAllByManageIdOrderBySortNum("5");
        if (allByManageIdOrderBySortNum != null && allByManageIdOrderBySortNum.size() > 0) {
            confRemindVo.setMonth(allByManageIdOrderBySortNum.get(0).getManageOptions());
        } else {
            confRemindVo.setMonth("6");
        }
        if (allByManageIdOrderBySortNum2 != null && allByManageIdOrderBySortNum2.size() > 0) {
            confRemindVo.setYear(allByManageIdOrderBySortNum2.get(0).getManageOptions());
        } else {
            confRemindVo.setYear("2");
        }
        return confRemindVo;
    }
}
