package com.tykj.classified.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.dao.db1.ConfOperationRecordDao;
import com.tykj.classified.entity.db1.ConfClassified;
import com.tykj.classified.entity.db1.ConfOperationRecord;
import com.tykj.classified.entity.vo.ConfOperationRecordListVo;
import com.tykj.classified.entity.vo.ConfOperationRecordPageVo;
import com.tykj.classified.entity.vo.ConfOperationRecordVo;
import com.tykj.classified.service.ConfOperationRecordService;
import com.tykj.classified.utils.idwork.IdWorker;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class ConfOperationRecordServiceImpl implements ConfOperationRecordService {

    private final ConfOperationRecordDao confOperationRecordDao;

    private final IdWorker idWorker;

    public ConfOperationRecordServiceImpl(ConfOperationRecordDao confOperationRecordDao, IdWorker idWorker) {
        this.confOperationRecordDao = confOperationRecordDao;
        this.idWorker = idWorker;
    }

    @Override
    public void save(ConfOperationRecord confOperationRecord) {
        confOperationRecord.setId(idWorker.nextId() + "");
        confOperationRecordDao.save(confOperationRecord);
    }

    @Override
    public ConfOperationRecordListVo findAllOperationRecordPaging(ConfOperationRecordPageVo confOperationRecordPageVo) {
        ConfOperationRecordListVo confOperationRecordListVo = new ConfOperationRecordListVo();
        List<ConfOperationRecordVo> confOperationRecordVoList = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日hh:dd");
        PredicateBuilder<ConfOperationRecord> confOperationRecordBuilder = Specifications.and();
        confOperationRecordBuilder.eq("classifiedId",confOperationRecordPageVo.getClassifiedId());
        Sort sort = Sort.by(Sort.Direction.DESC, "operationTime");
        PageRequest pageRequest = PageRequest.of(confOperationRecordPageVo.getCurrentPage() - 1, confOperationRecordPageVo.getPageSize(), sort);
        Page<ConfOperationRecord> confClassifiedPage = confOperationRecordDao.findAll(confOperationRecordBuilder.build(), pageRequest);
        for (ConfOperationRecord confOperationRecord : confClassifiedPage) {
            ConfOperationRecordVo confOperationRecordVo = new ConfOperationRecordVo();
            BeanUtils.copyProperties(confOperationRecord,confOperationRecordVo);
            if (confOperationRecord.getOperationTime() != null) {
                confOperationRecordVo.setOperationTime(sdf.format(confOperationRecord.getOperationTime()));
            }
            confOperationRecordVoList.add(confOperationRecordVo);
        }
        confOperationRecordListVo.setConfOperationRecordVoList(confOperationRecordVoList);
        confOperationRecordListVo.setTotalPage(confClassifiedPage.getTotalElements());
        return confOperationRecordListVo;
    }
}
