package com.tykj.classified.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.ConfManageDao;
import com.tykj.classified.dao.db1.ConfManageDetailDao;
import com.tykj.classified.dao.db1.ConfUnitNodeDao;
import com.tykj.classified.dao.db1.DataUnitDao;
import com.tykj.classified.dao.db2.RegionDao;
import com.tykj.classified.entity.db1.ConfManage;
import com.tykj.classified.entity.db1.ConfManageDetail;
import com.tykj.classified.entity.db1.ConfUnitNode;
import com.tykj.classified.entity.db1.DataUnit;
import com.tykj.classified.entity.db2.Region;
import com.tykj.classified.entity.vo.ConfUnitNodeAddVo;
import com.tykj.classified.entity.vo.UnitInfoVo;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.service.ConfUnitNodeService;
import com.tykj.classified.utils.idwork.IdWorker;
import com.tykj.classified.utils.string.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhaolu
 * @create 2022-11-14 13:34
 */

@Service
public class ConfUnitNodeServiceImpl implements ConfUnitNodeService {

    @Autowired
    private ConfUnitNodeDao confUnitNodeDao;

    @Value("${unit.firstNode}")
    private String unitFirstNode;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private ConfManageDao confManageDao;

    @Autowired
    private ConfManageDetailDao confManageDetailDao;

    @Autowired
    private RegionDao regionDao;

    @Autowired
    private DataUnitDao dataUnitDao;

    @Override
    public List<ConfUnitNode> getTree() {
        List<ConfUnitNode> confUnitNodeList = confUnitNodeDao.findAll();
        //获取父节点
        List<ConfUnitNode> collect = confUnitNodeList.stream().filter(m -> unitFirstNode.equals(m.getParentId())).map(
                (m) -> {
                    m.setChildNodes(getChildrenList(m, confUnitNodeList));
                    return m;
                }
        ).collect(Collectors.toList());

        // 获取顶级节点
        List<ConfUnitNode> firstNode = confUnitNodeList.stream()
                .filter(confUnitNode -> confUnitNode.getId().equals(unitFirstNode))
                .collect(Collectors.toList());
        if (firstNode.size() > 0) {
            // 顶级节点
            ConfUnitNode confFirstUnitNode = firstNode.get(0);
            confFirstUnitNode.setChildNodes(collect);
            List<ConfUnitNode> newTree = new ArrayList<>();
            newTree.add(confFirstUnitNode);
            return newTree;
        } else {
            throw new BizException("顶级节点不存在!");
        }
    }

    @Override
    public void addTree(ConfUnitNodeAddVo confUnitNodeAddVo) {
        Date date = new Date();
        ConfUnitNode addConfUnitNode = new ConfUnitNode();
        ConfUnitNode confUnitNode;
        if (StringUtils.isNotEmpty(confUnitNodeAddVo.getParentId())) {
            // 先查出上级节点的路径
            Optional<ConfUnitNode> byId = confUnitNodeDao.findById(confUnitNodeAddVo.getParentId());
            if (!byId.isPresent()) {
                throw new BizException("父节点不存在!");
            }
            confUnitNode = byId.get();
        } else {
            throw new BizException("父节点不存在!");
        }
        if (StringUtils.isNotEmpty(confUnitNodeAddVo.getId())) { // 修改
            Optional<ConfUnitNode> byId1 = confUnitNodeDao.findById(confUnitNodeAddVo.getId());
            if (!byId1.isPresent()) {
                throw new BizException("要修改的节点不存在!");
            }
            addConfUnitNode = byId1.get();
            addConfUnitNode.setNodeName(confUnitNodeAddVo.getNodeName());
            addConfUnitNode.setUnitManagementId(confUnitNodeAddVo.getUnitManagementId());
            addConfUnitNode.setUnitManagement(confUnitNodeAddVo.getUnitManagement());
            addConfUnitNode.setUnitTypeId(confUnitNodeAddVo.getUnitTypeId());
            addConfUnitNode.setUnitType(confUnitNodeAddVo.getUnitType());
            addConfUnitNode.setUnitTerritoryId(confUnitNodeAddVo.getUnitTerritoryId());
            addConfUnitNode.setUnitTerritory(confUnitNodeAddVo.getUnitTerritory());
            addConfUnitNode.setIsUnitNode(confUnitNodeAddVo.getIsUnitNode());
            addConfUnitNode.setIsManageNode(confUnitNodeAddVo.getIsManageNode());
            addConfUnitNode.setUpdateTime(date);
        } else { // 新增
            String id = idWorker.nextId() + "";
            BeanUtils.copyProperties(confUnitNodeAddVo,addConfUnitNode);
            addConfUnitNode.setId(id);
            // 传入父节点路径
            addConfUnitNode.setNodeRelationship(confUnitNode.getNodeRelationship() + id + ".");
            addConfUnitNode.setOperatorId(MyThreadLocal.get().getId());
            addConfUnitNode.setOperatorUnit(MyThreadLocal.get().getUnitId());
            // 节点
            addConfUnitNode.setNodeLevel("1");
            addConfUnitNode.setCreateTime(date);
            addConfUnitNode.setUpdateTime(date);
        }
        confUnitNodeDao.save(addConfUnitNode);
    }

    @Override
    public UnitInfoVo getUnitTerritoryAndUnitType(Integer chooseType) {
        UnitInfoVo unitInfoVo = new UnitInfoVo();
        ConfManage confManageByManageName = confManageDao.findConfManageByManageName("单位类型");
        if (confManageByManageName != null) {
            List<ConfManageDetail> allByManageIdOrderBySortNum = confManageDetailDao.findAllByManageIdOrderBySortNum(confManageByManageName.getId());
            if (chooseType == 1) {
                ConfManageDetail confManageDetail = new ConfManageDetail();
                confManageDetail.setId("0");
                confManageDetail.setManageId(confManageByManageName.getId());
                confManageDetail.setManageOptions("全部");
                confManageDetail.setSortNum(0);
                allByManageIdOrderBySortNum.add(0,confManageDetail);
            }
            unitInfoVo.setConfManageDetailList(allByManageIdOrderBySortNum);
            List<Region> allByParentIdOrderById = regionDao.findAllByParentIdOrderById("330100");
            unitInfoVo.setRegionList(allByParentIdOrderById);
            List<DataUnit> allByIsManageNode = dataUnitDao.findAllByIsManageNode(true);
            unitInfoVo.setDataUnitList(allByIsManageNode);
        } else {
            throw new BizException("没有单位类型参数!");
        }
        return unitInfoVo;
    }

    @Override
    public void deleteTree(ConfUnitNodeAddVo confUnitNodeAddVo) {
        // 判断要删除的节点是否含有子节点
        PredicateBuilder<ConfUnitNode> predicateBuilder = Specifications.and();
        predicateBuilder.eq("parentId",confUnitNodeAddVo.getId());
        List<ConfUnitNode> all = confUnitNodeDao.findAll(predicateBuilder.build());
        if (all.size() > 0) {
            throw new BizException("要删除的节点下存在子节点,不能删除!");
        }
        // 是单位节点判断要删除的节点是否有单位
        if (confUnitNodeAddVo.getIsUnitNode()) {
            PredicateBuilder<DataUnit> predicateBuilder2 = Specifications.and();
            if (!confUnitNodeAddVo.getUnitTerritoryId().equals("0")) {
                predicateBuilder2.eq("unitArea",confUnitNodeAddVo.getUnitTerritoryId());
            }
            if (!confUnitNodeAddVo.getUnitType().equals("全部")) {
                predicateBuilder2.eq("unitType",confUnitNodeAddVo.getUnitType());
            }
            List<DataUnit> all2 = dataUnitDao.findAll(predicateBuilder2.build());
            if (all2.size() > 0) {
                throw new BizException("要删除的节点下存在单位,不能删除!");
            }
        }
        Optional<ConfUnitNode> byId = confUnitNodeDao.findById(confUnitNodeAddVo.getId());
        if (!byId.isPresent()) {
            throw new BizException("要删除的节点不存在!");
        }
        ConfUnitNode confUnitNode = byId.get();
        confUnitNodeDao.delete(confUnitNode);
    }


    /**
     * 获取子节点列表
     *
     * @param tree
     * @param list
     * @return
     */
    public static List<ConfUnitNode> getChildrenList(ConfUnitNode tree, List<ConfUnitNode> list) {
        List<ConfUnitNode> children = list.stream().filter(item -> Objects.equals(item.getParentId(), tree.getId())).map(
                (item) -> {
                    item.setChildNodes(getChildrenList(item, list));
                    return item;
                }
        ).collect(Collectors.toList());
        return children;
    }
}
