package com.tykj.classified.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.classified.config.exception.BizException;
import com.tykj.classified.dao.db1.*;
import com.tykj.classified.entity.db1.*;
import com.tykj.classified.entity.vo.*;
import com.tykj.classified.entity.vo.mythreadlocal.MyThreadLocal;
import com.tykj.classified.response.ServerResponse;
import com.tykj.classified.service.EmployeeService;
import com.tykj.classified.utils.http.HttpUtils;
import com.tykj.classified.utils.idwork.IdWorker;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.transaction.Transactional;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class EmployeeServiceImpl implements EmployeeService {

    @Value("${sys.file.perSonName}")
    private String perSonName;

    @Value("${sys.file.syncUrl}")
    private String syncUrl;

    // 默认最大权限配置
    @Value("${employee.unitId}")
    private String code;

    private final EmployeeDao employeeDao;

    private final IdWorker idWorker;

    private final ConfUnitNodeDao confUnitNodeDao;

    private final DataUnitDao dataUnitDao;

    private final ConfClassifiedBasisDao confClassifiedBasisDao;

    private final ConfManageDao confManageDao;

    private final UnitBasisDao unitBasisDao;

    public EmployeeServiceImpl(EmployeeDao employeeDao, IdWorker idWorker, ConfUnitNodeDao confUnitNodeDao, DataUnitDao dataUnitDao, ConfClassifiedBasisDao confClassifiedBasisDao, ConfManageDao confManageDao, UnitBasisDao unitBasisDao) {
        this.employeeDao = employeeDao;
        this.idWorker = idWorker;
        this.confUnitNodeDao = confUnitNodeDao;
        this.dataUnitDao = dataUnitDao;
        this.confClassifiedBasisDao = confClassifiedBasisDao;
        this.confManageDao = confManageDao;
        this.unitBasisDao = unitBasisDao;
    }

    /**
     * 同步人员
     *
     * @return 同步结果
     */
    @Override
    public ServerResponse<String> syncPerson() {
        Map<String, String> map = new HashMap<>();
        map.put("tableName", perSonName);
        String persons = HttpUtils.sendGet(syncUrl, map);
        if (persons.equals("400")) {
            throw new BizException("同步人员数据失败");
        }
        if (StringUtils.hasText(persons)) {
            List<Employee> employeeDaoAll = employeeDao.findAll();
            Map<String, List<Employee>> collect = employeeDaoAll.stream()
                    .collect(Collectors.groupingBy(Employee::getPersonId));

            JSONObject jsonObject = JSONObject.parseObject(persons);
            JSONArray data = jsonObject.getJSONArray("data");
            List<Employee> employeeList = data.toJavaList(Employee.class);

            List<Employee> newEmployeeList = new ArrayList<>();
            for (Employee employee : employeeList) {
                List<Employee> orDefault = collect.getOrDefault(employee.getPersonId(), new ArrayList<>());
                if (orDefault.size() > 0) {
                    newEmployeeList.add(orDefault.get(0));
                } else {
                    // 承办人默认选中
                    employee.setUndertaker(1);
                    newEmployeeList.add(employee);
                }
            }
            employeeDao.saveAll(newEmployeeList);
        }
        return ServerResponse.ok("同步成功");
    }

    @Override
    public EmployeeVo findAllEmployeePaging(EmployeePageVo employeePageVo) {
        // 用户只能看自己单位下的人员（市区都只能看自己单位）
        PredicateBuilder<Employee> employeeBuilder = Specifications.and();
        employeeBuilder.like(employeePageVo != null && employeePageVo.getPersonName() != null, "personName", "%" + employeePageVo.getPersonName() + "%");
        employeeBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        List<Sort.Order> orders = new ArrayList<>();
        Sort.Order order = new Sort.Order(Sort.Direction.DESC, "legalClassifiedResponsible");
        Sort.Order order2 = new Sort.Order(Sort.Direction.DESC, "specifyClassifiedResponsible");
        orders.add(order);
        orders.add(order2);
        Sort sort = Sort.by(orders);
        PageRequest pageRequest = PageRequest.of(employeePageVo.getCurrentPage() - 1, employeePageVo.getPageSize(),sort);
        Page<Employee> employeePage = employeeDao.findAll(employeeBuilder.build(), pageRequest);
        for (Employee employee : employeePage.getContent()) {
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employee.getSecretRelateLevel())) {
                if (employee.getSecretRelateLevel().equals("一般")) {
                    employee.setSecretRelateLevel("秘密");
                } else if (employee.getSecretRelateLevel().equals("重要") || employee.getSecretRelateLevel().equals("核心")) {
                    employee.setSecretRelateLevel("机密");
                }
            }
        }
        EmployeeVo employeeVo = new EmployeeVo();
        employeeVo.setEmployeeList(employeePage.getContent());
        employeeVo.setTotalPage(employeePage.getTotalElements());
        return employeeVo;
    }

    @Override
    public EmployeeEditVo findEmployeeByEmployeeId(String personId) {
        Employee employee = employeeDao.findEmployeeByPersonId(personId);
        if (employee != null) {
            EmployeeEditVo employeeEditVo = new EmployeeEditVo();
            BeanUtils.copyProperties(employee, employeeEditVo);
            return employeeEditVo;
        } else {
            throw new BizException("人员信息不存在");
        }
    }

    @Override
    public void editEmployee(EmployeeEditVo employeeEditVo) {
        if (employeeEditVo != null) {
            Employee employee = employeeDao.findEmployeeByPersonId(employeeEditVo.getPersonId());
            employee.setLegalClassifiedResponsible(employeeEditVo.getLegalClassifiedResponsible());
            employee.setSpecifyClassifiedResponsible(employeeEditVo.getSpecifyClassifiedResponsible());
            employee.setUndertaker(employeeEditVo.getUndertaker());
            employeeDao.save(employee);
        } else {
            throw new BizException("编辑信息为空，保存失败");
        }

    }

    @Override
    public List<Employee> selectEmployee(EmployeeSelectPageVo employeeSelectPageVo) {
        PredicateBuilder<Employee> predicateBuilder = Specifications.and();
//        if (!MyThreadLocal.get().getUnitId().equals(code)) {
//            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitId());
//        }
        if (com.tykj.classified.utils.string.StringUtils.isEmpty(employeeSelectPageVo.getEditUnitId())) {
            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        } else {
            predicateBuilder.eq("unitId", employeeSelectPageVo.getEditUnitId());
        }
//        predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitId());
        predicateBuilder.eq("legalClassifiedResponsible", 1);
        List<Employee> employeeList = employeeDao.findAll(predicateBuilder.build());
        int i = -1;
        // 法定定m责任人
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getLegalClassifiedResponsible())) {
            for (int j = 0; j < employeeList.size(); j++) {
                if (employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getLegalClassifiedResponsible())) {
                    i = j;
                }
            }
            // 找到这个人并放到首位（前端需要找到这个元素才显示）
            if (i != -1) {
                employeeList.add(0,employeeList.remove(i));
            }
        }
        return employeeList;
    }

    @Override
    public List<Employee> selectEmployeeTwo(EmployeeSelectPageVo employeeSelectPageVo) {
        PredicateBuilder<Employee> predicateBuilder = Specifications.and();
//        if (!MyThreadLocal.get().getUnitId().equals(code)) {
//            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitId());
//        }
        if (com.tykj.classified.utils.string.StringUtils.isEmpty(employeeSelectPageVo.getEditUnitId())) {
            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        } else {
            predicateBuilder.eq("unitId", employeeSelectPageVo.getEditUnitId());
        }
//        predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitId());
        predicateBuilder.eq("specifyClassifiedResponsible", 1);
        List<Employee> employeeList = employeeDao.findAll(predicateBuilder.build());
        int i = -1;
        // 指定定m责任人
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getSpecifyClassifiedResponsible())) {
            for (int j = 0; j < employeeList.size(); j++) {
                if (employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getSpecifyClassifiedResponsible())) {
                    i = j;
                }
            }
            if (i != -1) {
                employeeList.add(0,employeeList.remove(i));
            }
        }
        return employeeList;
    }

    @Override
    public List<Employee> selectEmployeeThree(EmployeeSelectPageVo employeeSelectPageVo) {
        PredicateBuilder<Employee> predicateBuilder = Specifications.and();
//        if (!MyThreadLocal.get().getUnitId().equals(code)) {
//            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitId());
//        }
        if (com.tykj.classified.utils.string.StringUtils.isEmpty(employeeSelectPageVo.getEditUnitId())) {
            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        } else {
            predicateBuilder.eq("unitId", employeeSelectPageVo.getEditUnitId());
        }
//        predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitId());
        predicateBuilder.eq("undertaker", 1);
        List<Employee> employeeList = employeeDao.findAll(predicateBuilder.build());
        int i = -1;
        // 承办人
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getUndertaker())) {
            for (int j = 0; j < employeeList.size(); j++) {
                if (employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getUndertaker())) {
                    i = j;
                }
            }
            if (i != -1) {
                employeeList.add(0,employeeList.remove(i));
            }
        }
        return employeeList;
    }

    @Override
    public List<Employee> selectEmployeeFour(EmployeeSelectPageVo employeeSelectPageVo) {
        PredicateBuilder<Employee> predicateBuilder = Specifications.and();
        List<Employee> employeeList;
//        if (employeeSelectPageVo.getType() != null && employeeSelectPageVo.getType() == 1) { // 如果是发文,只查法定和指定
        PredicateBuilder<Employee> predicateBuilder2 = Specifications.and();
        if (com.tykj.classified.utils.string.StringUtils.isEmpty(employeeSelectPageVo.getEditUnitId())) {
            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
            predicateBuilder2.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        } else {
            predicateBuilder.eq("unitId", employeeSelectPageVo.getEditUnitId());
            predicateBuilder2.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        }
        predicateBuilder.eq("legalClassifiedResponsible",1);
        predicateBuilder2.eq("specifyClassifiedResponsible",1);
        employeeList = employeeDao.findAll(predicateBuilder.build().or(predicateBuilder2.build()));
//        } else {
//            if (com.tykj.classified.utils.string.StringUtils.isEmpty(employeeSelectPageVo.getEditUnitId())) {
//                predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
//            } else {
//                predicateBuilder.eq("unitId", employeeSelectPageVo.getEditUnitId());
//            }
//            employeeList = employeeDao.findAll(predicateBuilder.build());
//        }

        int i = -1, a = -1, b = -1, c = -1, d = -1;
        for (int j = 0; j < employeeList.size(); j++) {
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getChargeLeaderReviewer()) &&
                    employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getChargeLeaderReviewer())) {
                i = j;
            }
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getUnitReviewer()) &&
                    employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getUnitReviewer())) {
                a = j;
            }
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getClassificationPerson()) &&
                    employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getClassificationPerson())) {
                b = j;
            }
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getDepartReviewer()) &&
                    employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getDepartReviewer())) {
                c = j;
            }
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getApprover()) &&
                    employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getApprover())) {
                d = j;
            }
        }
        if (i != -1) {
            employeeList.add(0,employeeList.remove(i));
        }
        if (a != -1) {
            employeeList.add(0,employeeList.remove(a));
        }
        if (b != -1) {
            employeeList.add(0,employeeList.remove(b));
        }
        if (c != -1) {
            employeeList.add(0,employeeList.remove(c));
        }
        if (d != -1) {
            employeeList.add(0,employeeList.remove(d));
        }
        return employeeList;
    }

    @Override
    public List<Employee> findEmployeeByName(EmployeeSelectVo employeeSelectVo) {
        PredicateBuilder<Employee> employeePredicateBuilder = Specifications.and();
        employeePredicateBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        employeePredicateBuilder.eq(com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectVo.getPersonName()),"personName",employeeSelectVo.getPersonName());
        List<Employee> employeeList = employeeDao.findAll(employeePredicateBuilder.build());
        for (Employee employee : employeeList) {
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employee.getSecretRelateLevel())) {
                if (employee.getSecretRelateLevel().equals("核心") || employee.getSecretRelateLevel().equals("重要")) {
                    employee.setSecretRelateLevel("机密");
                } else if (employee.getSecretRelateLevel().equals("一般")) {
                    employee.setSecretRelateLevel("秘密");
                }
            }
        }
        return employeeList;
    }


    @Override
    public List<Employee> selectEmployeeFive(FindEmployeeVo findEmployeeVo) {
        PredicateBuilder<Employee> predicateBuilder = Specifications.and();
//        if (!findEmployeeVo.getEditUnitId().equals(code)) {
//            predicateBuilder.eq("unitId", findEmployeeVo.getEditUnitId());
//        }
        if (com.tykj.classified.utils.string.StringUtils.isEmpty(findEmployeeVo.getEditUnitId())) {
            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitId());
        } else {
            predicateBuilder.eq("unitId", findEmployeeVo.getEditUnitId());
        }
        List<Employee> employeeList = employeeDao.findAll(predicateBuilder.build());
        int i = -1;
        // 人员
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(findEmployeeVo.getEditUnitId())) {
            for (int j = 0; j < employeeList.size(); j++) {
                if (employeeList.get(j).getPersonId().equals(findEmployeeVo.getPersonId())) {
                    i = j;
                }
            }
            if (i != -1) {
                employeeList.add(0,employeeList.remove(i));
            }
        }
        return employeeList;
    }

    @Override
    public EmployeeShowTwoVo findEmployeeByUnit(FindEmployeeByUnitVo findEmployeeByUnitVo) {
        EmployeeShowTwoVo employeeShowTwoVo = new EmployeeShowTwoVo();
        PredicateBuilder<Employee> predicateBuilder = Specifications.and();
        predicateBuilder.eq("unitId",findEmployeeByUnitVo.getUnitId());
        predicateBuilder.like(com.tykj.classified.utils.string.StringUtils.isNotEmpty(findEmployeeByUnitVo.getPersonName()),"personName","%" + findEmployeeByUnitVo.getPersonName() + "%");
        List<Employee> all = employeeDao.findAll(predicateBuilder.build());
        for (Employee employee : all) {
            if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employee.getSecretRelateLevel())) {
                if (employee.getSecretRelateLevel().equals("一般")) {
                    employee.setSecretRelateLevel("秘密");
                } else if (employee.getSecretRelateLevel().equals("重要") || employee.getSecretRelateLevel().equals("核心")) {
                    employee.setSecretRelateLevel("机密");
                }
            }
        }
        employeeShowTwoVo.setEmployeeList(all);
        employeeShowTwoVo.setTotalPage(all.size());
        return employeeShowTwoVo;
    }

    @Override
    public void addEmployee(EmployeeAddVo employeeAddVo) {
        Employee employee;
        Date date = new Date();
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeAddVo.getPersonId())) { // 修改
            Optional<Employee> byId = employeeDao.findById(employeeAddVo.getPersonId());
            if (!byId.isPresent()) {
                throw new BizException("人员不存在!");
            }
            employee = byId.get();
            employee.setPersonName(employeeAddVo.getPersonName());
            employee.setPersonTel(employeeAddVo.getPersonTel());
            employee.setSecretRelateLevel(employeeAddVo.getSecretRelateLevel());
            employee.setUnitDepartment(employeeAddVo.getUnitDepartment());
            employee.setOfficialCpacity(employeeAddVo.getOfficialCpacity());
            employee.setUpdateTime(date);
        } else { // 新增
            String id = idWorker.nextId() + "";
            employee = new Employee();
            BeanUtils.copyProperties(employeeAddVo,employee);
            employee.setPersonId(id);
            employee.setLegalClassifiedResponsible(0);
            employee.setSpecifyClassifiedResponsible(0);
            employee.setUndertaker(0);
            employee.setApprover(0);
            employee.setCreateTime(date);
            employee.setUpdateTime(date);
        }
        employeeDao.save(employee);
    }

    @Override
    public void checkApprover(EmployeeCheckVo employeeCheckVo) {
        Optional<Employee> byId = employeeDao.findById(employeeCheckVo.getPersonId());
        if (!byId.isPresent()) {
            throw new BizException("人员不存在!");
        }
        Employee employee = byId.get();
        if (employeeCheckVo.getType() == 1) { // 选中的承办人
            if (employee.getUndertaker() == 1) {
                employee.setUndertaker(0);
            } else {
                employee.setUndertaker(1);
            }
        } else { // 选中的审批人
            if (employee.getApprover() == 1) {
                employee.setApprover(0);
            } else {
                employee.setApprover(1);
            }
        }
        employeeDao.save(employee);
    }

    @Override
    public List<Employee> selectEmployeeSix(EmployeeSelectPageVo employeeSelectPageVo) {
        PredicateBuilder<Employee> predicateBuilder = Specifications.and();

        if (com.tykj.classified.utils.string.StringUtils.isEmpty(employeeSelectPageVo.getEditUnitId())) {
            predicateBuilder.eq("unitId", MyThreadLocal.get().getUnitIdTwo());
        } else {
            predicateBuilder.eq("unitId", employeeSelectPageVo.getEditUnitId());
        }
        predicateBuilder.eq("approver", 1);
        List<Employee> employeeList = employeeDao.findAll(predicateBuilder.build());
        int i = -1;
        // 审批人
        if (com.tykj.classified.utils.string.StringUtils.isNotEmpty(employeeSelectPageVo.getApprover())) {
            for (int j = 0; j < employeeList.size(); j++) {
                if (employeeList.get(j).getPersonId().equals(employeeSelectPageVo.getApprover())) {
                    i = j;
                }
            }
            if (i != -1) {
                employeeList.add(0,employeeList.remove(i));
            }
        }
        return employeeList;

    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void initData() {
        Date date = new Date();
        // 初始化配置项
        List<ConfManage> confManageList = new ArrayList<>();
        ConfManage confManage = new ConfManage();
        confManage.setId("6");
        confManage.setManageName("单位类型");
        confManage.setUpdateTime(date);
        ConfManage confManage2 = new ConfManage();
        confManage2.setId("7");
        confManage2.setManageName("审批人意见");
        confManage2.setUpdateTime(date);
        ConfManage confManage3 = new ConfManage();
        confManage3.setId("8");
        confManage3.setManageName("知悉范围");
        confManage3.setUpdateTime(date);
        ConfManage confManage4 = new ConfManage();
        confManage4.setId("9");
        confManage4.setManageName("分管领导意见");
        confManage4.setUpdateTime(date);
        ConfManage confManage5 = new ConfManage();
        confManage5.setId("10");
        confManage5.setManageName("单位保密委员会或保密工作小组审核意见");
        confManage5.setUpdateTime(date);
        ConfManage confManage6 = new ConfManage();
        confManage6.setId("11");
        confManage6.setManageName("定密责任人意见");
        confManage6.setUpdateTime(date);
        ConfManage confManage7 = new ConfManage();
        confManage7.setId("12");
        confManage7.setManageName("部门审核意见");
        confManage7.setUpdateTime(date);
        ConfManage confManage8 = new ConfManage();
        confManage8.setId("13");
        confManage8.setManageName("承办人意见");
        confManage8.setUpdateTime(date);
        confManageList.add(confManage);
        confManageList.add(confManage2);
        confManageList.add(confManage3);
        confManageList.add(confManage4);
        confManageList.add(confManage5);
        confManageList.add(confManage6);
        confManageList.add(confManage7);
        confManageList.add(confManage8);

        confManageDao.saveAll(confManageList);
    }
}
