package com.tykj.classified.task;

import com.tykj.classified.utils.info.JwtKeys;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.io.*;

/**
 * @author huangjiafu
 * @version V1.0
 * @data 2021/12/3 10:04
 **/
@Slf4j
@Component
public class TaskRunner implements ApplicationRunner {

    final JwtKeys keys;

    public TaskRunner(JwtKeys keys) {
        this.keys = keys;
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        initCache();
    }

    public void initCache(){
        //生成Jwt所需要的4个Key
        File rsaPublicKeyFile = new File(keys.getRsaPublicKeyFilePath());
        File rsaPrivateKeyFile = new File(keys.getRsaPrivateKeyFilePath());
        File jwtPublicKeyFile = new File(keys.getJwtPublicKeyFilePath());
        File jwtPrivateKeyFile = new File(keys.getJwtPrivateKeyFilePath());
        try {
            keys.setRsaPublicKey(readFileStr(rsaPublicKeyFile));
            keys.setRsaPrivateKey(readFileStr(rsaPrivateKeyFile));
            keys.setJwtPublicKey(readFileStr(jwtPublicKeyFile));
            keys.setJwtPrivateKey(readFileStr(jwtPrivateKeyFile));
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            e.printStackTrace();
            log.error("未找到对应的文件");
        }
    }

    public String readFileStr(File file) throws FileNotFoundException {
        String s = "";
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(
                new FileReader(file)
        );
        try {
            while ((s = in.readLine()) != null) {
                sb.append(s);
            }
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
            log.error("读取文件失败");
        }
        return sb.toString();
    }

}
