package com.tykj.classified.utils.date;

import com.tykj.classified.config.exception.BizException;

import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Date;

/**
 * @author zhaolu
 * @create 2022-08-18 15:49
 */
public class DateUtils {

    /**
     * 添加年或月
     *
     * @param date     开始时间
     * @param calendar 年或月
     * @param amont    几年或几月
     * @return
     */
    public static Date addYearOrMonth(Date date, int calendar, int amont) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (calendar == Calendar.YEAR) {
                cal.add(Calendar.YEAR, amont);//增加年
            } else if (calendar == Calendar.MONTH) {
                cal.add(Calendar.MONTH, amont);//增加月
            } else {
                cal.add(Calendar.DATE, amont);//增加日
            }
            return cal.getTime();
        } else {
            throw new BizException("签发日期为空");
        }
    }

    public static Date addYear(Date date, int amont) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.YEAR, amont);//增加年
        return cal.getTime();
    }

    public static Date addMonth(Date date,int amont) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.MONTH, amont);//增加月
        return cal.getTime();
    }

}
