package com.tykj.classified.utils.freemake;


import com.deepoove.poi.XWPFTemplate;
import com.tykj.classified.config.exception.BizException;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.Version;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;

@Slf4j
public class FreeMakerUtils {

    public static void main(String[] args) throws Exception {
//        Map<String,Object> data = new HashMap<>();
//        data.put("itemName","有关事项");
//        data.put("legalClassifiedResponsible","有关事项");
//        data.put("specifyClassifiedResponsible","有关事项");
//        data.put("undertaker","有关事项");
//        data.put("undertakerPhone","");
//        data.put("classifiedBasicContent",null);
//        data.put("range","有关事项");
//        data.put("mj",new TextRenderData("R",new Style("Wingdings 2",14)));
//        data.put("bmqx",new TextRenderData("□",new Style("宋体",14)));
//        data.put("urgency","无需加急");
//        data.put("printNum",10);
//        data.put("documentNumContent","有关事项");
//        generateWord(data,"gmfwng.ftl","D:/conf/opt/test.docx");
        XWPFDocument doc = new XWPFDocument(new FileInputStream("D:/opt/conf/gmspp.docx"));// docx
        PdfOptions options = PdfOptions.create();
        PdfConverter.getInstance().convert(doc, new FileOutputStream("D:/opt/conf/gmsp.pdf"), options);// pdf
//        createTest(data);

    }

    private static void createTest(Map<String, Object> datas)  {
        try {
            Resource resource = new ClassPathResource("templates/gmfwng.docx");
            InputStream is = resource.getInputStream();
            XWPFTemplate template = XWPFTemplate.compile(is).render(datas);

            FileOutputStream out = new FileOutputStream(new File("D:/conf/opt/gmfwng.docx"));
            template.write(out);
            template.close();
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 生成word
     * @param type 1-发文，2-采购，3-事项，4-事项表单，5-解密审核，6-工作mm审批
     * @param datas 数据
     */
    public String createWord(String path,Integer type, Map datas, String idWork)  {
        String temp;String path2;String pdfPath;
        if (type == 1) {
            temp = "templates/gmfwng.docx";
        } else if (type == 2) {
            temp = "templates/mcg.docx";
        } else if (type == 3) {
            temp = "templates/gmsmsx.docx";
        } else if (type == 4) {
            temp = "templates/cgba.docx";
        } else if (type == 5) {
            temp = "templates/dmbgg.docx";
        } else if (type == 6) {
            temp = "templates/gmspp.docx";
        } else if (type == 7) {
            temp = "templates/jm.docx";
        } else if (type == 8) {
            temp = "templates/gmfwng2.docx";
        } else if (type == 9) {
            temp = "templates/gmfwng3.docx";
        } else if (type == 10) {
            temp = "templates/gmfwng4.docx";
        } else {
            throw new BizException("模板不存在！");
        }
        path2 = path + idWork +".docx";
        pdfPath = path + idWork + ".pdf";

        log.info("path2:{}",path2);


        /**
         * 判断文件夹是否存在，不存在就创建
         * @param file
         */
        File file = new File(path);
        if(!file.exists()){//如果文件夹不存在
            file.mkdir();//创建文件夹
        }

        try {
            Resource resource = new ClassPathResource(temp);
            InputStream is = resource.getInputStream();
            XWPFTemplate template = XWPFTemplate.compile(is).render(datas);

            FileOutputStream out = new FileOutputStream(path2);
            template.write(out);
            template.close();
            out.flush();

            XWPFDocument doc = new XWPFDocument(Files.newInputStream(Paths.get(path2)));
            // docx
            PdfOptions options = PdfOptions.create();
            PdfConverter.getInstance().convert(doc, Files.newOutputStream(Paths.get(pdfPath)), options);
            // pdf

            return "/conf/"+idWork + ".pdf";
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 生成 word 文档方法
     *
     * @param dataMap      要填充的数据
     * @param templateName 模版名称
     * @param fileName     要输出的文件路径
     * @throws Exception 抛出的异常
     */
    public static void generateWord(Map<String, Object> dataMap, String templateName, String fileName) throws Exception {

        // 设置FreeMarker的版本和编码格式
        Configuration configuration = new Configuration(new Version("2.3.28"));
        configuration.setDefaultEncoding("UTF-8");

        // 设置FreeMarker生成Word文档所需要的模板的路径
        // configuration.setDirectoryForTemplateLoading(new File("/Users/xxx/Desktop/"));
        // 此处把模版文件都放在 resources 下的 templates 中
        configuration.setClassForTemplateLoading(WordUtils.class, "/templates");

        // 设置FreeMarker生成Word文档所需要的模板
        Template tem = configuration.getTemplate(templateName, "UTF-8");
        // 创建一个Word文档的输出流
        Writer out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(fileName)), StandardCharsets.UTF_8));
        // FreeMarker使用Word模板和数据生成Word文档
        tem.process(dataMap, out);
        out.flush();
        out.close();
    }
}
