package com.tykj.classified.utils.http;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;


public class HttpUtils {

    /**
     * get请求不带参数
     * @param url 访问json数据接口
     * @return
     */
    public static String doGet(String url) {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse response = null;
        try {
            response = client.execute(httpGet);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(entity, "UTF-8");
            }else {
                return "400";
            }
        } catch (Exception e) {
            return "400";
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                client.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    
    /**
     * get请求带参数
     * @param getUrl 访问json数据接口
     * @param paraMap 参数
     * @return
     */
    public static String sendGet(String getUrl,Map<String, String> paraMap){
        if(paraMap == null){
            paraMap = new HashMap<>();
        }
        paraMap= new TreeMap<>(paraMap);
        StringBuilder sb = new StringBuilder();
        paraMap.entrySet().stream().forEach(entry ->{
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("&");
        });
        getUrl = getUrl.contains("?")?getUrl:getUrl+"?";
        return doGet(getUrl+sb.toString());
    }

    public static void main(String[] args) {
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        String format1 = simpleDateFormat2.format(new Date());
        Map<String, String> map = new HashMap<>();
        map.put("date", format1);
        String s1 = HttpUtils.sendGet("http://192.168.102.222:19061/isNotWeekdays", map);
        JSONObject jsonObject = JSONObject.parseObject(s1);
        String data = jsonObject.get("data").toString();
        if(data.equals("1")){
            System.out.println("11111111111111");
        }
        System.out.println(data);
    }
}
