package com.tykj.classified.utils.info;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * 字符串处理工具类
 */
public class MD5Util {

    /**
     * 使用md5的算法进行加密
     */
    public static String md5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes());
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("没有md5这个算法！");
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);// 16进制数字
        // 如果生成数字未满32位，需要前面补0
        for (int i = 0; i < 32 - md5code.length(); i++) {
            md5code = "0" + md5code;
        }
        return md5code;
    }


    /**
     * 获取当前格式化时间（yyyy-MM-dd hh:mm:ss）<BR/>
     * 方法名：getCurrentFormatDate<BR/>
     *
     * @return String<BR />
     * @throws <BR/>
     * @since 1.0.0
     */
    public static String getCurrentFormatDate() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String datetime = sdf.format(date);
        return datetime;
    }


    /**
     * 获取当前时间戳<BR/>
     */
    public static long getCurrentTimeStamp() {
        return new Date().getTime();
    }


    /**
     * 将时间戳转换成时间格式为 yyy-MM-dd hh:mm:ss 的时间<BR/>
     * 方法名：getDateByTimeStamp<BR/>
     *
     * @param timestamp
     * @return String<BR />
     * @throws <BR/>
     * @since 1.0.0
     */
    public static String getDateByTimeStamp(long timestamp) {
        if (timestamp != 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String date = sdf.format(new Date(timestamp));
            System.out.println(date);
            return date;
        } else {
            return "";
        }
    }


    /**
     * 将时间戳转换成时间格式为 yyy-MM-dd hh:mm:ss或者yyy-MM-dd 的时间<BR/>
     * 方法名：getDateByTimeStamp<BR/>
     *
     * @param timestamp
     * @param format
     * @return String<BR />
     * @throws <BR/>
     * @since 1.0.0
     */
    public static String getDateByTimeStamp(long timestamp, String format) {
        if (timestamp != 0) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            String date = sdf.format(new Date(timestamp));
            return date;
        } else {
            return "";
        }
    }


    /**
     * 将时间字符串转换成时间戳<BR/>
     * 方法名：getTime<BR/>
     *
     * @param user_time
     * @return String<BR />
     * @throws ParseException
     * @throws <BR/>
     * @since 1.0.0
     */
    public static Long getTime(String user_time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(
                "yyyy-MM-dd HH:mm:ss");
        Date date;
        try {
            date = simpleDateFormat.parse(user_time);
            Long timeStemp = date.getTime();
            return timeStemp;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static void main(String[] args) {

        String time ="1631848174036";
//        String s2 = String.valueOf(time);
        String sign = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo01kRn2ltskmnNp6bGkMk3JkG/8ZBvRRTSheuymdgpDI+g77k3Ut2ZkxQAyiXtEu0ghba68mloK8Wt1IMb803JjbFm6ATmLG4YQvrOtjMcJfCHHYR8B2JsgAafKo1jtgBNJLIXBsPRhe7e8WBO7K4xg2ASU19rVzp8eNx5c9B6DxvLgJUKjZOKrE+/fpxXrJXr04H00cHZUlYE9ZW6fR24KYLU22f1Qz0ni+zpKNJSWpy2PdB/d9iozE26bDYOOmQCX7hWjqYdXqWHbQkPlbBPvZmk5DqD43i4MVAVPXEsgx0c76u+8g+OqXkf/NXctp025Q7uTZSX4QZWiygszMGQIDAQAB";

        String s = md5(time+"9caaffd3-a21c-4652-8a3e-f53458fe4620"+sign);
        String s1 = md5("1630552333137"+"01fffe20-9764-44cb-9633-e642fd94cdd1");
        System.out.println(s);
//        System.out.println(s1);
        System.out.println(time);

    }
}
