package com.tykj.classified.utils.log;

import com.tykj.classified.entity.db1.ConfOperationRecord;
import com.tykj.classified.service.ConfOperationRecordService;
import com.tykj.classified.utils.idwork.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Date;

/**
 * 操作记录工具类
 *
 * @author zhaolu
 * @create 2022-08-12 16:56
 */

@Component
public class LogUtils {

    @Autowired
    private ConfOperationRecordService confOperationRecordService;

    @Autowired
    private IdWorker idWorker;

    private static LogUtils logUtil;

    @PostConstruct
    public void init() {
        logUtil = this;
    }

    /**
     * 添加操作记录
     * @param classifiedId 定密id
     * @param operationContent 具体操作名称
     * @param date 操作时间
     * @param operatorId 操作人id
     * @param operatorName 操作人名称
     * @param operatorUnit 单位信用代码
     */
    public static void addOperationRecord(String classifiedId, String operationContent, Date date, String operatorId, String operatorName, String operatorUnit) {
        ConfOperationRecord confOperationRecord = new ConfOperationRecord();
        confOperationRecord.setId(logUtil.idWorker.nextId() + "");
        confOperationRecord.setClassifiedId(classifiedId);
        confOperationRecord.setOperationContent(operationContent);
        confOperationRecord.setOperationTime(date);
        confOperationRecord.setOperatorId(operatorId);
        confOperationRecord.setOperatorName(operatorName);
        confOperationRecord.setOperatorUnit(operatorUnit);
        logUtil.confOperationRecordService.save(confOperationRecord);
    }
}
