package com.tykj.diagramking.controller;


import com.alibaba.fastjson.JSON;
import com.tykj.diagramking.entity.Images;
import com.tykj.diagramking.service.ImagesService;
import com.tykj.diagramking.util.ResultUtil;
import com.tykj.diagramking.vo.ImagesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.annotation.MultipartConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@RestController
@RequestMapping("/images")
@Api(tags = "图片管理")
public class ImagesController {

    private final String BASE_PATH = System.getProperty("user.dir");
    private static String XML_FILE_PATH = File.separator+"images"+File.separator;


    @Autowired
    private ImagesService imagesService;


    @ApiOperation("单文件上传")
    @PostMapping("/singleUploadImages")
    public String singleUploadImages(@RequestParam("file")MultipartFile file){
        String realPath = null;
        File file1 = new File(BASE_PATH+XML_FILE_PATH);
        if (!file1.isDirectory()){
            file1.mkdirs();
        }
        if (!file.isEmpty()) {
            //获取文件名
            String fileName = file.getOriginalFilename();
            System.out.println(fileName);
            //获取文件后缀
            String suffixName = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            System.out.println(fileName);
            //指定本地存入路径
            File fileNew = new File(BASE_PATH+XML_FILE_PATH + fileName);
            realPath = fileName;
            try {
                file.transferTo(fileNew);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return realPath;
    }

    @ApiOperation("多文件上传")
    @PostMapping("/UploadImages")
    public String UploadImages(@RequestParam("file") List<MultipartFile> files){
        List<String> filePathList = new ArrayList<>();
        // 多文件上传
        for (MultipartFile file : files){
            String s = singleUploadImages(file);
            filePathList.add(s);
        }
        String jsonString = JSON.toJSONString(filePathList);
        return jsonString;
    }

    @ApiOperation("保存图片")
    @PostMapping("/saveImages")
    public ResponseEntity saveImages(@RequestBody ImagesVo imagesVo){
        Images images = imagesService.saveImages(imagesVo);
        if (images != null){
            return ResultUtil.success(images,"保存图片成功");
        }else {
            return ResultUtil.failed("保存图片失败");
        }
    }

    @ApiOperation("根据用户id查询图片")
    @PostMapping("/findByUserId")
    public List<Images> findByUserId(String userId){
        List<Images> imagesList = imagesService.findByUserId(userId);
        return imagesList;
    }

}
