package com.tykj.diagramking.controller;


import com.tykj.diagramking.entity.User;
import com.tykj.diagramking.service.UserService;
import com.tykj.diagramking.util.ResultUtil;
import com.tykj.diagramking.vo.UserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/user")
@Api(tags = "用户管理接口")
public class UserController {

    @Autowired
    private UserService userService;

    @ApiOperation("用户注册")
    @PostMapping("/registerUser")
    public ResponseEntity registerUser(@RequestBody User user){
        //先查询用户是否注册
        User byUserName = userService.findByUserName(user.getUserName());
        if (byUserName != null){
            System.out.println("sddsdsd");
            return ResultUtil.failed("该用户名已经被注册了");
        }else {
            User user1 = userService.registerUser(user);
            System.out.println("555555");
            return ResultUtil.success(user1,"用户注册成功");
        }
    }

    @ApiOperation("用户登录")
    @PostMapping("/loginUser")
    public ResponseEntity loginUser(@RequestBody UserVo userVo){
        User user = userService.loginUser(userVo.toEntity());
        if (user != null){
            return ResultUtil.success(user,"用户登录成功");
        }else {
            return ResultUtil.failed("用户登录失败");
        }
    }


}
