package com.tykj.diagramking.entity;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@Table(name = "diagram")
@ApiModel(value = "DiagramEntity")
public class DiagramEntity {

    @Id
    @ApiModelProperty("id")
    private String id;

    @Lob
    @ApiModelProperty("图片")
    private String image;

    @Lob
    @ApiModelProperty("json对象")
    private String json;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("v")
    private String v;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新时间")
//    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private String updateTime;

    @ApiModelProperty("json文件路径")
    private String jsonPath;
}
