package com.tykj.diagramking.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.diagramking.dao.DiagramEntityDao;
import com.tykj.diagramking.entity.DiagramEntity;
import com.tykj.diagramking.service.DiagramService;
import com.tykj.diagramking.vo.DiagramEntityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class DiagramServiceImpl implements DiagramService {

    @Autowired
    private DiagramEntityDao diagramEntityDao;

    @Override
    public DiagramEntity saveFile(DiagramEntity diagramEntity) {

        return diagramEntityDao.save(diagramEntity);
    }

    @Override
    public DiagramEntity findById(String id) {
        Optional<DiagramEntity> byId = diagramEntityDao.findById(id);
        if (byId.isPresent()){
            return byId.get();
        }else {
            return null;
        }

    }

    @Override
    public List<DiagramEntity> getAllFilesByUserId(String userId) {
        return diagramEntityDao.findByUserId(userId);
    }

    @Override
    public List<DiagramEntity> getAllFilesByName(String name) {
        PredicateBuilder<DiagramEntity> builder = Specifications.and();
        builder.like("name","%"+name+"%");
        List<DiagramEntity> all = diagramEntityDao.findAll(builder.build());
        return all;
    }

    @Override
    public List<DiagramEntity> getAllFilesByNameAndUserId(DiagramEntityVo diagramEntityVo) {

        PredicateBuilder<DiagramEntity> builder = Specifications.and();
        builder.like(diagramEntityVo.getName()!=null,"name","%"+diagramEntityVo.getName()+"%");
        builder.eq(diagramEntityVo.getUserId()!=null,"userId",diagramEntityVo.getUserId());
        List<DiagramEntity> all = diagramEntityDao.findAll(builder.build());
        return all;
    }

    @Override
    public void deleteDiagramEntity(String id) {
        diagramEntityDao.deleteById(id);
    }
}
