package com.tykj.diagramking.service.impl;

import com.tykj.diagramking.dao.ImagesDao;
import com.tykj.diagramking.entity.Images;
import com.tykj.diagramking.service.ImagesService;
import com.tykj.diagramking.vo.ImagesVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ImagesServiceImpl implements ImagesService {

    @Autowired
    private ImagesDao imagesDao;

    @Override
    public Images saveImages(ImagesVo imagesVo) {
        Images images = imagesVo.toEntity();
        return imagesDao.save(images);

    }

    @Override
    public List<Images> findByUserId(String userId) {
        List<Images> byUserId = imagesDao.findByUserId(userId);
        return byUserId;
    }
}
