package com.tykj.diagramking.service.impl;

import com.tykj.diagramking.dao.UserDao;
import com.tykj.diagramking.entity.User;
import com.tykj.diagramking.service.UserService;
import com.tykj.diagramking.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl implements UserService {

    @Autowired
    private UserDao userDao;

    @Override
    public User registerUser(User user) {

        return userDao.save(user);
    }

    @Override
    public User loginUser(User user) {
        String userName = user.getUserName();
        String passWord = user.getPassWord();
        return userDao.findByUserNameAndPassWord(userName,passWord);
    }

    @Override
    public User findByUserName(String userName) {
        return userDao.findByUserName(userName);
    }
}
