package com.tykj.diagramking.util;

import java.io.*;
import java.util.UUID;

public class CreateFileUtil {
    /**
     * 生成.json格式文件
     */
    private static final String BASE_PATH = System.getProperty("user.dir");
    private static String XML_FILE_PATH = File.separator+"json"+File.separator;

    public static String createJsonFile(String jsonString, String fileName) {
        // 标记文件生成是否成功
//        boolean flag = true;

        // 拼接文件完整路径
        String fullPath = BASE_PATH + XML_FILE_PATH + UUID.randomUUID().toString() + fileName + ".json";

        // 生成json格式文件
        try {
            // 保证创建一个新文件
            File file = new File(fullPath);
            if (!file.getParentFile().exists()) { // 如果父目录不存在，创建父目录
                file.getParentFile().mkdirs();
            }
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();

            if (jsonString.indexOf("'") != -1) {
                //将单引号转义一下，因为JSON串中的字符串类型可以单引号引起来的
                jsonString = jsonString.replaceAll("'", "\\'");
            }
            if (jsonString.indexOf("\"") != -1) {
                //将双引号转义一下，因为JSON串中的字符串类型可以单引号引起来的
                jsonString = jsonString.replaceAll("\"", "\\\"");
            }

            if (jsonString.indexOf("\r\n") != -1) {
                //将回车换行转换一下，因为JSON串中字符串不能出现显式的回车换行
                jsonString = jsonString.replaceAll("\r\n", "\\u000d\\u000a");
            }
            if (jsonString.indexOf("\n") != -1) {
                //将换行转换一下，因为JSON串中字符串不能出现显式的换行
                jsonString = jsonString.replaceAll("\n", "\\u000a");
            }

            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(jsonString);
            write.flush();
            write.close();
        } catch (Exception e) {
//            flag = false;
            e.printStackTrace();
        }

        // 返回是否成功的标记
        return UUID.randomUUID().toString() + fileName+".json";
    }
}
