package com.tykj.diagramking.controller;

import com.tykj.diagramking.entity.DiagramEntity;
import com.tykj.diagramking.service.DiagramService;
import com.tykj.diagramking.util.CreateFileUtil;
import com.tykj.diagramking.util.ResultUtil;
import com.tykj.diagramking.vo.DiagramEntityVo;
import com.tykj.diagramking.vo.DiagramEntityVos;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/diagram")
@Api(tags = "构图王管理接口")
public class DiagramEntityController {



    @Autowired
    private DiagramService diagramService;

    @ApiOperation("保存构图王文件")
    @PostMapping("/saveFile")
    public ResponseEntity saveFile(@RequestBody DiagramEntity diagramEntity){
        diagramEntity.setCreateTime(new Date());
        String jsonFile = CreateFileUtil.createJsonFile(diagramEntity.getJson(), diagramEntity.getName());
        diagramEntity.setJsonPath(jsonFile);
        DiagramEntity diagramEntity1 = diagramService.saveFile(diagramEntity);
        return ResultUtil.success(diagramEntity1,"保存成功");
    }

    @ApiOperation("保存多个构图王文件")
    @PostMapping("/saveFiles")
    public ResponseEntity saveFiles(@RequestBody DiagramEntityVos diagramEntity){
        List<DiagramEntity> diagramEntities = diagramEntity.getDiagramEntities();
        for (DiagramEntity entity : diagramEntities) {
            saveFile(entity);
        }
        return ResultUtil.success("同步成功");
    }

    @ApiOperation("编辑文件")
    @GetMapping("/findById")
    public DiagramEntity findById(String id){
        return diagramService.findById(id);
    }

//    @ApiOperation("根据用户id查询所有文件")
//    @GetMapping("/getAllFiles")
//    public List<DiagramEntity> getAllFiles(String userId){
//        return diagramService.getAllFilesByUserId(userId);
//    }
//
//    @ApiOperation("名称模糊查询所有文件")
//    @GetMapping("/findFilesByName")
//    public List<DiagramEntity> findFilesByName(String name){
//        List<DiagramEntity> allFilesByName = diagramService.getAllFilesByName(name);
//        return allFilesByName;
//    }

    @ApiOperation("名称模糊查询所有文件")
    @PostMapping("/findFilesByNameAndUserId")
    public List<DiagramEntity> findFilesByNameAndUserId(@RequestBody DiagramEntityVo diagramEntityVo){
        List<DiagramEntity> allFilesByNameAndUserId = diagramService.getAllFilesByNameAndUserId(diagramEntityVo);
        return allFilesByNameAndUserId;
    }

    @ApiOperation("根据id删除文件")
    @DeleteMapping("/deleteDiagram")
    public ResponseEntity deleteDiagram(String id){
        DiagramEntity byId = diagramService.findById(id);
        if (byId == null){
            return ResultUtil.failed("该文件未被同步，不能删除");
        }else {
            diagramService.deleteDiagramEntity(id);
            return ResultUtil.success("删除文件成功");
        }
    }

}
