package com.example.spingbootjwt.controller;

import com.example.spingbootjwt.dao.SysUserDao;
import com.example.spingbootjwt.entity.SecurityUserDetails;
import com.example.spingbootjwt.entity.SysUser;
import com.example.spingbootjwt.jwt.JwtTokenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@RestController
public class LoginController {

    @Autowired
    @Qualifier("jwtUserDetailsService")
    private UserDetailsService userDetailsService;

    @Autowired
    private JwtTokenUtil jwtTokenUtil;

    @Resource
    private SysUserDao sysUserDao;

    @PostMapping("/login")
    public String login(@RequestBody SysUser sysUser, HttpServletRequest request){
        final UserDetails userDetails = userDetailsService.loadUserByUsername(sysUser.getUsername());
        final String token = jwtTokenUtil.generateToken(userDetails);
        sysUser.setId(2);
        sysUser.setToken(token);
        //进行更新
        sysUserDao.save(sysUser);
        return token;
    }

    @PostMapping("haha")
    public String haha(){
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
//        UserDetails userDetails = (UserDetails) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
//        return "haha:"+userDetails.getUsername()+","+userDetails.getPassword();
        return "haha:"+principal;
    }

}

