package com.example.spingbootjwt.jwt;

import com.example.spingbootjwt.Vo.Result;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@Component
public class JwtAuthenticationEntryPoint implements AuthenticationEntryPoint {
    @Override
    public void commence(HttpServletRequest request,
                         HttpServletResponse response,
                         AuthenticationException authException)
            throws IOException, ServletException {
//        if (request.getHeader("Authorization") == null){
//            response.sendError(HttpServletResponse.SC_UNAUTHORIZED,"没有凭证");
//        }
//        System.out.println("JwtAuthenticationEntryPoint:"+authException.getMessage());
        response.setStatus(403);
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.getWriter().println("{\"code\":403,\"msg\":\"用户未登陆\"}");

    }
}

