package com.tykj.zspdemo.aop;

/**
 * @author: zsp
 * @create: 2023 02-10 17:43
 **/

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.*;
import org.springframework.stereotype.Component;

@Slf4j
@Aspect
@Component
public class CountAspect {

    @Pointcut("@within(com.tykj.zspdemo.aop.CountAop)")
    public void operateTimerPointCut() {
    }

    @Around("operateTimerPointCut()")
    public Object measureMethodExecutionTime(ProceedingJoinPoint joinPoint) throws Throwable {
        String methodName = joinPoint.getSignature().getName();
        System.out.println("Begin monitor method: " + methodName);

        long startTime = System.nanoTime();
        Object result = joinPoint.proceed();
        long elapsedTime = System.nanoTime() - startTime;

        System.out.println("End monitor method: " + methodName + ", elapsed time: " + elapsedTime + " ns");
        return result;
    }

}

