package com.tykj.zspdemo.base;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhoushaopan
 */
@Data
public class CustomPage {

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private Integer currentPage = 0;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private Integer pageSize = 15;

    private List<CustomOrder> orders = new ArrayList<>();

    @JsonIgnore
    public <T> Page<T> getPageable() {
        Page<T> objectPage = new Page<>();
        if (orders.size() != 0) {
            List<OrderItem> orders = new ArrayList<>();
            this.orders.forEach(item -> {
                        OrderItem orderItem = new OrderItem();
                        orderItem.setColumn(item.getColumn());
                        if ("ASC".equals(item.getDirection())) {
                            orderItem.setAsc(true);
                        } else if ("DESC".equals(item.getDirection())) {
                            orderItem.setAsc(false);
                        }
                        orders.add(orderItem);
                    }
            );
            if (orders.size() > 0) {
                objectPage.setCurrent(currentPage);
                objectPage.setSize(pageSize);
                objectPage.setOrders(orders);
                return objectPage;
            }
        }
        return objectPage;
    }

}
