package com.tykj.zspdemo.exception;


import lombok.extern.slf4j.Slf4j;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;


/**
 * @author zhoushaopan
 */
@RestControllerAdvice
@Slf4j
public class GlobalExceptionHandler {


    /**
     *用户名用户密码错误
     *
     * @param e 报错信息
     */
    @ResponseBody
    @ExceptionHandler(BadCredentialsException.class)
    public String errorMessage(BadCredentialsException e) {
        log.warn("[用户或者密码错误]");
        return e.getMessage();
    }

    @ResponseBody
    @ExceptionHandler(UsernameNotFoundException.class)
    public String errorMessage(UsernameNotFoundException e) {
        log.warn("[用户名不存在]");
        return e.getMessage();
    }

    @ResponseBody
    @ExceptionHandler(AccessDeniedException.class)
    public String errorMessage(AccessDeniedException e) {
        log.warn("[用户名不存在]");
        return e.getMessage();
    }

    @ResponseBody
    @ExceptionHandler(ApiException.class)
    public String errorMessage(ApiException e) {
        log.warn("[用户名不存在]");
        return e.getMessage();
    }

}

