package com.tykj.zspdemo.jwt;

import com.tykj.zspdemo.exception.ApiException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;

/**
 * @author: zsp
 * @create: 2023-08-23 15:55
 **/
@Component
@Slf4j
public class ApiAccessDecisionManager implements AccessDecisionManager {

    @Override
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        log.info("object:{}",object);
        if (configAttributes == null) {
            return;
        }

        for (ConfigAttribute attribute : configAttributes) {
            if (!authentication.isAuthenticated()) {
                throw new AccessDeniedException("Access Denied");
            }

            boolean hasPermission = checkPermission(authentication, attribute.getAttribute());
            if (!hasPermission) {
                throw new AccessDeniedException("Access Denied");
            }
        }
    }

    private boolean checkPermission(Authentication authentication, String requiredPermission) {
        // 根据authentication和requiredPermission进行权限验证的逻辑
        // 返回true表示有权限，返回false表示无权限
        // 这里可以根据具体业务需求进行实现
        return true;
    }

    @Override
    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return true;
    }
}

